/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ProgramBinding;
import org.eclipse.edt.compiler.binding.ProgramBindingCompletor;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ProgramScope;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class ProgramBinder
extends FunctionContainerBinder {
    private ProgramBinding programBinding;
    private Scope scope;

    public ProgramBinder(ProgramBinding programBinding, Scope scope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(programBinding, scope, dependencyRequestor, problemRequestor, compilerOptions);
        this.programBinding = programBinding;
        this.scope = scope;
    }

    @Override
    public boolean visit(Program program) {
        program.accept(new ProgramBindingCompletor(this.scope, this.programBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        this.currentScope = new ProgramScope(this.currentScope, this.programBinding);
        this.preprocessPart(program);
        return true;
    }

    @Override
    public void endVisit(Program program) {
        this.doneVisitingPart();
    }

    @Override
    public boolean visit(ProgramParameter programParameter) {
        if (programParameter.getName().resolveBinding() == IBinding.NOT_FOUND_BINDING) {
            return false;
        }
        this.processResolvableProperties(programParameter.getName());
        return false;
    }
}

