/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.edt.compiler.binding.IPartBinding;

public class PartBindingCache {
    private static final boolean DEBUG = false;
    private Map softReferences;
    private ReferenceQueue referenceQueue;

    public PartBindingCache() {
        this.softReferences = new LinkedHashMap(16, 0.75f, true);
        this.referenceQueue = new ReferenceQueue();
    }

    public PartBindingCache(final int maxSize) {
        this.softReferences = new LinkedHashMap((int)((float)maxSize * 0.75f), 0.75f, true){
            private static final long serialVersionUID = 343884753499895404L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > maxSize;
            }
        };
        this.referenceQueue = new ReferenceQueue();
    }

    public void put(String[] packageName, String partName, IPartBinding partBinding) {
        this.removeClearedReferences();
        PartKey partKey = new PartKey(packageName, partName);
        this.softReferences.put(partKey, new SoftReferenceWithKey(partKey, partBinding, this.referenceQueue));
    }

    public IPartBinding get(String[] packageName, String partName) {
        this.removeClearedReferences();
        SoftReferenceWithKey ref = (SoftReferenceWithKey)this.softReferences.get(new PartKey(packageName, partName));
        if (ref == null) {
            return null;
        }
        Object result = ref.get();
        return (IPartBinding)result;
    }

    public void remove(String[] packageName, String partName) {
        this.softReferences.remove(new PartKey(packageName, partName));
    }

    private void removeClearedReferences() {
        SoftReferenceWithKey ref;
        while ((ref = (SoftReferenceWithKey)this.referenceQueue.poll()) != null) {
            this.softReferences.remove(ref.key);
        }
    }

    private static class PartKey {
        String[] packageName;
        String partName;

        PartKey(String[] packageName, String partName) {
            this.packageName = packageName;
            this.partName = partName;
        }

        public int hashCode() {
            return this.partName.hashCode();
        }

        public boolean equals(Object obj) {
            PartKey anotherPartKey = (PartKey)obj;
            return anotherPartKey.packageName == this.packageName && anotherPartKey.partName == this.partName;
        }
    }

    private static class SoftReferenceWithKey
    extends SoftReference {
        Object key;

        SoftReferenceWithKey(Object key, Object referent, ReferenceQueue q) {
            super(referent, q);
        }
    }
}

