/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IFieldContentAnnotationValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class AbstractSelectedItemAnnotationValidator
extends DefaultFieldContentAnnotationValidationRule
implements IFieldContentAnnotationValidationRule,
IAnnotationValidationRule {
    private String propertyName;

    public AbstractSelectedItemAnnotationValidator(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.doValidate(errorNode, target, null, targetTypeBinding, null, allAnnotations, problemRequestor, compilerOptions);
    }

    @Override
    public void validate(Node errorNode, Node target, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        ITypeBinding targetTypeBinding = containerBinding.getType();
        if (targetTypeBinding != null && IBinding.NOT_FOUND_BINDING != targetTypeBinding) {
            this.doValidate(errorNode, target, containerBinding, targetTypeBinding, canonicalContainerName, allAnnotations, problemRequestor, compilerOptions);
        }
    }

    public void doValidate(Node errorNode, Node target, IBinding targetBinding, ITypeBinding targetTypeBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        ITypeBinding tBinding;
        IDataBinding value;
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)this.propertyName));
        if (annotationBinding != null && annotationBinding.getValue() != null && annotationBinding.getValue() instanceof Name && (value = ((Name)annotationBinding.getValue()).resolveDataBinding()) != null && IBinding.NOT_FOUND_BINDING != value && (tBinding = value.getType()) != null && IBinding.NOT_FOUND_BINDING != tBinding) {
            if (5 == targetTypeBinding.getKind() || 2 == targetTypeBinding.getKind() && (7 == targetTypeBinding.getBaseType().getKind() || 6 == targetTypeBinding.getBaseType().getKind())) {
                this.targetIsDataTableOrRecordArray(errorNode, targetBinding, targetTypeBinding, tBinding, value, allAnnotations, problemRequestor, compilerOptions);
            } else if (2 == targetTypeBinding.getKind() && 3 == targetTypeBinding.getBaseType().getKind()) {
                int targetPrim = ((PrimitiveTypeBinding)targetTypeBinding.getBaseType()).getPrimitive().getType();
                switch (targetPrim) {
                    case 9: 
                    case 21: {
                        problemRequestor.acceptProblem(errorNode, 7694, new String[]{this.propertyName, StatementValidator.getTypeString(targetTypeBinding)});
                        break;
                    }
                    default: {
                        this.targetIsPrimitiveArray(errorNode, targetBinding, targetTypeBinding, tBinding, value, allAnnotations, problemRequestor, compilerOptions);
                        break;
                    }
                }
            } else {
                problemRequestor.acceptProblem(errorNode, 7693, new String[]{this.propertyName});
            }
        }
    }

    protected abstract void targetIsDataTableOrRecordArray(Node var1, IBinding var2, ITypeBinding var3, ITypeBinding var4, IDataBinding var5, Map var6, IProblemRequestor var7, ICompilerOptions var8);

    protected abstract void targetIsPrimitiveArray(Node var1, IBinding var2, ITypeBinding var3, ITypeBinding var4, IDataBinding var5, Map var6, IProblemRequestor var7, ICompilerOptions var8);
}

