/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class CurrencySymbolValidator
implements IAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"currencySymbol"));
        if (annotationBinding != null && annotationBinding.getValue() != null) {
            int lengthWithoutEscapeChars = CurrencySymbolValidator.lengthWithoutEscapeChars((String)annotationBinding.getValue());
            if (lengthWithoutEscapeChars == 0) {
                problemRequestor.acceptProblem(errorNode, 5352, new String[]{"currencySymbol"});
            } else if (lengthWithoutEscapeChars > 3) {
                problemRequestor.acceptProblem(errorNode, 3101, new String[]{(String)annotationBinding.getValue(), "currencySymbol", Integer.toString(3)});
            }
        }
    }

    public static int lengthWithoutEscapeChars(String input) {
        String tempString = input;
        int len = input.length();
        if (tempString == "\\") {
            return 1;
        }
        int slashIndex = tempString.indexOf(92);
        while (slashIndex != -1) {
            if (slashIndex == input.length() - 1) {
                slashIndex = -1;
                --len;
                continue;
            }
            tempString = tempString.substring(slashIndex + 2);
            slashIndex = tempString.indexOf(92);
            --len;
        }
        return len;
    }
}

