/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.edt.compiler.binding.AnnotationValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class DateFormatAnnotationValidator
extends AnnotationValidationAnnotationTypeBinding {
    private static Set invalidDateFormatChars = new TreeSet();
    protected IAnnotationTypeBinding annotationType;
    protected String canonicalAnnotationName;

    static {
        invalidDateFormatChars.add(new Character('Y'));
    }

    public DateFormatAnnotationValidator() {
        super(InternUtil.internCaseSensitive((String)"dateformat"));
    }

    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (targetTypeBinding.getKind() == 3) {
            Primitive prim = ((PrimitiveTypeBinding)targetTypeBinding).getPrimitive();
            if (prim == Primitive.DBCHAR || prim == Primitive.MBCHAR || prim == Primitive.HEX || prim == Primitive.UNICODE || prim == Primitive.CLOB || prim == Primitive.BLOB || prim == Primitive.MONTHSPAN_INTERVAL || prim == Primitive.SECONDSPAN_INTERVAL || prim == Primitive.TIME || prim == Primitive.TIMESTAMP || prim == Primitive.BOOLEAN) {
                problemRequestor.acceptProblem(errorNode, 3174, new String[]{"dateFormat", prim.getName()});
            } else if (((PrimitiveTypeBinding)targetTypeBinding).getDecimals() > 0) {
                problemRequestor.acceptProblem(errorNode, 3175, new String[]{"dateFormat"});
            }
        }
    }
}

