/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.HandlerBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBMiProgramAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AbstractAS400ParameterAnnotaionValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IBMiProgramParameterAnnotationsValidator;

public class IBMiProgramValidator
implements IAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (!(Binding.isValidBinding(targetTypeBinding) && targetTypeBinding.isFunctionBinding() && target instanceof NestedFunction)) {
            return;
        }
        IFunctionBinding funcBinding = (IFunctionBinding)targetTypeBinding;
        this.validateContainerIsCorrect(funcBinding, errorNode, problemRequestor);
        this.validateFunctionBodyIsEmpty((NestedFunction)target, problemRequestor);
        this.validateReturns((NestedFunction)target, funcBinding, problemRequestor);
        IAnnotationBinding annotation = (IAnnotationBinding)allAnnotations.get(IBMiProgramAnnotationTypeBinding.name);
        if (annotation == null) {
            return;
        }
        Object obj = this.getValue(annotation, "parameterAnnotations");
        if (obj == null) {
            this.validateParmsDoNotRequireParameterAnnotations(funcBinding, errorNode, problemRequestor);
        }
        this.validateParameters(funcBinding, obj, errorNode, problemRequestor);
    }

    private void validateParameters(IFunctionBinding funcBinding, Object parmAnnValue, Node errorNode, IProblemRequestor problemRequestor) {
        int index = -1;
        Iterator i = funcBinding.getParameters().iterator();
        Object[] parmAnnArr = null;
        if (parmAnnValue instanceof Object[] && ((Object[])parmAnnValue).length == funcBinding.getParameters().size()) {
            parmAnnArr = (Object[])parmAnnValue;
        }
        while (i.hasNext()) {
            ITypeBinding elemType;
            FunctionParameterBinding parm = (FunctionParameterBinding)i.next();
            if (!Binding.isValidBinding(parm.getType()) || parmAnnArr != null && parmAnnArr[++index] != null) continue;
            if (!IBMiProgramValidator.isValidAS400Type(parm.getType())) {
                problemRequestor.acceptProblem(errorNode, 5717, new String[]{parm.getCaseSensitiveName()});
                continue;
            }
            if (parm.getType().isNullable()) {
                problemRequestor.acceptProblem(errorNode, 5718, new String[]{String.valueOf(parm.getType().getCaseSensitiveName()) + "?", parm.getCaseSensitiveName()});
                continue;
            }
            if (2 == parm.getType().getKind() && Binding.isValidBinding(((ArrayTypeBinding)parm.getType()).getElementType()) && (elemType = ((ArrayTypeBinding)parm.getType()).getElementType()).isNullable()) {
                problemRequestor.acceptProblem(errorNode, 5719, new String[]{String.valueOf(elemType.getCaseSensitiveName()) + "?[]", parm.getCaseSensitiveName()});
                continue;
            }
            this.validateFieldsInStructure(parm, parm.getType(), errorNode, problemRequestor);
        }
    }

    private void validateParmsDoNotRequireParameterAnnotations(IFunctionBinding funcBinding, Node errorNode, IProblemRequestor problemRequestor) {
        int index = 0;
        for (FunctionParameterBinding parm : funcBinding.getParameters()) {
            if (IBMiProgramValidator.requiresAS400TypeAnnotation(parm.getType())) {
                problemRequestor.acceptProblem(errorNode, 5715, new String[]{parm.getCaseSensitiveName()});
            }
            ++index;
        }
    }

    private void validateFieldsInStructure(FunctionParameterBinding parm, ITypeBinding type, Node errorNode, IProblemRequestor problemRequestor) {
        if (Binding.isValidBinding(type)) {
            if (10 == type.getKind()) {
                this.validateHandlerFields(parm, (HandlerBinding)type, errorNode, problemRequestor);
                return;
            }
            if (7 == type.getKind()) {
                this.validateRecordFields(parm, (FlexibleRecordBinding)type, errorNode, problemRequestor);
                return;
            }
            if (2 == type.getKind() && Binding.isValidBinding(((ArrayTypeBinding)type).getElementType())) {
                this.validateFieldsInStructure(parm, ((ArrayTypeBinding)type).getElementType(), errorNode, problemRequestor);
            }
        }
    }

    private void validateHandlerFields(FunctionParameterBinding parm, HandlerBinding binding, Node errorNode, IProblemRequestor problemRequestor) {
        for (ClassFieldBinding field : binding.getClassFields()) {
            if (field.isPrivate()) continue;
            this.validateField(parm, field, errorNode, problemRequestor);
        }
    }

    private void validateRecordFields(FunctionParameterBinding parm, FlexibleRecordBinding binding, Node errorNode, IProblemRequestor problemRequestor) {
        for (FlexibleRecordFieldBinding field : binding.getDeclaredFields()) {
            this.validateField(parm, field, errorNode, problemRequestor);
        }
    }

    private AbstractAS400ParameterAnnotaionValidator getAS400ParmValidator(IDataBinding binding) {
        Iterator i = binding.getAnnotations().iterator();
        while (i.hasNext()) {
            AbstractAS400ParameterAnnotaionValidator val = IBMiProgramParameterAnnotationsValidator.getValidator(i.next());
            if (val == null) continue;
            return val;
        }
        return null;
    }

    private void validateField(FunctionParameterBinding parm, IDataBinding field, Node errorNode, IProblemRequestor problemRequestor) {
        ITypeBinding elemType;
        if (!Binding.isValidBinding(field.getType())) {
            return;
        }
        if (this.getAS400ParmValidator(field) != null) {
            return;
        }
        if (!IBMiProgramValidator.isValidAS400Type(field.getType())) {
            problemRequestor.acceptProblem(errorNode, 5720, new String[]{parm.getCaseSensitiveName(), field.getDeclaringPart().getCaseSensitiveName(), field.getCaseSensitiveName(), field.getType().getCaseSensitiveName()});
            return;
        }
        if (field.getType().isNullable()) {
            problemRequestor.acceptProblem(errorNode, 5721, new String[]{parm.getCaseSensitiveName(), field.getDeclaringPart().getCaseSensitiveName(), field.getCaseSensitiveName(), String.valueOf(field.getType().getCaseSensitiveName()) + "?"});
            return;
        }
        if (2 == field.getType().getKind() && Binding.isValidBinding(((ArrayTypeBinding)field.getType()).getElementType()) && (elemType = ((ArrayTypeBinding)field.getType()).getElementType()).isNullable()) {
            problemRequestor.acceptProblem(errorNode, 5722, new String[]{parm.getCaseSensitiveName(), field.getDeclaringPart().getCaseSensitiveName(), field.getCaseSensitiveName(), elemType + "?[]"});
            return;
        }
        if (IBMiProgramValidator.requiresAS400TypeAnnotation(field.getType())) {
            problemRequestor.acceptProblem(errorNode, 5723, new String[]{parm.getCaseSensitiveName(), field.getDeclaringPart().getCaseSensitiveName(), field.getCaseSensitiveName()});
        }
        this.validateFieldsInStructure(parm, field.getType(), errorNode, problemRequestor);
    }

    private void validateReturns(NestedFunction function, IFunctionBinding funcBinding, IProblemRequestor problemRequestor) {
        if (!Binding.isValidBinding(funcBinding.getReturnType())) {
            return;
        }
        IAnnotationBinding ibmiAnn = funcBinding.getAnnotation(IBMiProgramAnnotationTypeBinding.pkgName, IBMiProgramAnnotationTypeBinding.name);
        if (ibmiAnn == null) {
            return;
        }
        IDataBinding srvPgmAnn = ibmiAnn.findData("isServiceProgram");
        if (!Binding.isValidBinding(srvPgmAnn) || ((AnnotationFieldBinding)srvPgmAnn).getValue() != Boolean.YES) {
            problemRequestor.acceptProblem((Node)function.getReturnDeclaration(), 5705, new String[]{function.getName().getCaseSensitiveIdentifier()});
        }
        if (funcBinding.getReturnType() != PrimitiveTypeBinding.getInstance(Primitive.INT)) {
            problemRequestor.acceptProblem((Node)function.getReturnDeclaration(), 5706, new String[]{function.getName().getCaseSensitiveIdentifier()});
        }
    }

    private void validateFunctionBodyIsEmpty(NestedFunction function, IProblemRequestor problemRequestor) {
        if (function.getStmts() != null && function.getStmts().size() > 0) {
            for (Node node : function.getStmts()) {
                if (!(node instanceof Statement)) continue;
                problemRequestor.acceptProblem(node, 5704, new String[]{function.getName().getCaseSensitiveIdentifier()});
            }
        }
    }

    private void validateContainerIsCorrect(IFunctionBinding funcBinding, Node errorNode, IProblemRequestor problemRequestor) {
        IPartBinding part = funcBinding.getDeclarer();
        if (Binding.isValidBinding(part)) {
            if (13 == part.getKind()) {
                return;
            }
            if (11 == part.getKind()) {
                return;
            }
            if (14 == part.getKind()) {
                return;
            }
            if (10 == part.getKind() && part.getSubType() == null) {
                return;
            }
        }
        problemRequestor.acceptProblem(errorNode, 5703, new String[]{funcBinding.getCaseSensitiveName()});
    }

    public static boolean isValidAS400Type(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return true;
        }
        if (type.getKind() == 3) {
            Primitive prim = ((PrimitiveTypeBinding)type).getPrimitive();
            return prim == Primitive.SMALLINT || prim == Primitive.INT || prim == Primitive.BIGINT || prim == Primitive.DECIMAL || prim == Primitive.SMALLFLOAT || prim == Primitive.FLOAT || prim == Primitive.DATE || prim == Primitive.TIME || prim == Primitive.TIMESTAMP || prim == Primitive.STRING;
        }
        if (type.getKind() == 10) {
            return true;
        }
        if (type.getKind() == 7) {
            return true;
        }
        if (type.getKind() == 2) {
            ArrayTypeBinding arr = (ArrayTypeBinding)type;
            if (!Binding.isValidBinding(arr.getElementType())) {
                return true;
            }
            if (arr.getElementType().getKind() == 2) {
                return false;
            }
            return IBMiProgramValidator.isValidAS400Type(arr.getElementType());
        }
        return false;
    }

    public static boolean requiresAS400TypeAnnotation(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        if (type.getKind() == 3) {
            PrimitiveTypeBinding primType = (PrimitiveTypeBinding)type;
            Primitive prim = primType.getPrimitive();
            if (prim == Primitive.DECIMAL) {
                return primType.isReference();
            }
            if (prim == Primitive.TIMESTAMP) {
                return primType.isReference();
            }
            if (prim == Primitive.STRING) {
                return primType.getLength() == 0;
            }
            return false;
        }
        if (type.getKind() == 2) {
            ArrayTypeBinding arr = (ArrayTypeBinding)type;
            if (!Binding.isValidBinding(arr.getElementType())) {
                return false;
            }
            if (arr.getElementType().getKind() == 2) {
                return false;
            }
            return IBMiProgramValidator.requiresAS400TypeAnnotation(arr.getElementType());
        }
        return false;
    }

    protected Object getValue(IAnnotationBinding ann, String fieldName) {
        if (!Binding.isValidBinding(ann)) {
            return null;
        }
        IDataBinding db = ann.findData(fieldName);
        if (!Binding.isValidBinding(db)) {
            return null;
        }
        return ((AnnotationFieldBinding)db).getValue();
    }
}

