/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class IsBooleanAnnotationValidator
extends AnnotationValidationAnnotationTypeBinding {
    protected IAnnotationTypeBinding annotationType;
    protected String canonicalAnnotationName;
    private static final Primitive[] acceptedPrimitives = new Primitive[11];

    static {
        IsBooleanAnnotationValidator.acceptedPrimitives[0] = Primitive.CHAR;
        IsBooleanAnnotationValidator.acceptedPrimitives[1] = Primitive.BIN;
        IsBooleanAnnotationValidator.acceptedPrimitives[2] = Primitive.NUM;
        IsBooleanAnnotationValidator.acceptedPrimitives[3] = Primitive.NUMC;
        IsBooleanAnnotationValidator.acceptedPrimitives[4] = Primitive.DECIMAL;
        IsBooleanAnnotationValidator.acceptedPrimitives[5] = Primitive.PACF;
        IsBooleanAnnotationValidator.acceptedPrimitives[6] = Primitive.INT;
        IsBooleanAnnotationValidator.acceptedPrimitives[7] = Primitive.BIGINT;
        IsBooleanAnnotationValidator.acceptedPrimitives[8] = Primitive.SMALLINT;
        IsBooleanAnnotationValidator.acceptedPrimitives[9] = Primitive.FLOAT;
        IsBooleanAnnotationValidator.acceptedPrimitives[10] = Primitive.MONEY;
    }

    public IsBooleanAnnotationValidator() {
        super(InternUtil.internCaseSensitive((String)"isboolean"));
    }

    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (targetTypeBinding.getKind() == 3) {
            PrimitiveTypeBinding primitiveTypeBinding = (PrimitiveTypeBinding)targetTypeBinding;
            Primitive prim = primitiveTypeBinding.getPrimitive();
            int i = 0;
            while (i < acceptedPrimitives.length) {
                if (prim == acceptedPrimitives[i]) {
                    if (primitiveTypeBinding.getLength() != 0 && primitiveTypeBinding.getDecimals() == primitiveTypeBinding.getLength()) {
                        problemRequestor.acceptProblem(errorNode, 3123, new String[]{"isBoolean", StatementValidator.getTypeString(primitiveTypeBinding)});
                    }
                    return;
                }
                ++i;
            }
            problemRequestor.acceptProblem(errorNode, 3121, new String[]{"isBoolean", this.getCommaList()});
        }
    }

    private String getCommaList() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < acceptedPrimitives.length) {
            sb.append(acceptedPrimitives[i].getName());
            if (i < acceptedPrimitives.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }
}

