/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IFieldAccessAnnotationValidationRule;

public class PropertyFieldAccessValidator
implements IFieldAccessAnnotationValidationRule {
    @Override
    public boolean validateLValue(Expression lValue, IDataBinding fieldBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (this.hasGetterButNotSetter(fieldBinding)) {
            problemRequestor.acceptProblem((Node)lValue, 3423, new String[]{fieldBinding.getCaseSensitiveName()});
            return false;
        }
        return true;
    }

    @Override
    public boolean validateRValue(Expression rValue, IDataBinding fieldBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (this.hasSetterButNotGetter(fieldBinding)) {
            problemRequestor.acceptProblem((Node)rValue, 3424, new String[]{fieldBinding.getCaseSensitiveName()});
            return false;
        }
        return true;
    }

    protected IAnnotationBinding getAnnotation(IDataBinding binding) {
        return binding.getAnnotation(new String[]{"eglx", "lang"}, "Property");
    }

    private boolean hasGetterButNotSetter(IDataBinding binding) {
        IAnnotationBinding aBinding = this.getAnnotation(binding);
        if (aBinding != null) {
            return this.hasGet(aBinding) && !this.hasSet(aBinding);
        }
        return false;
    }

    private boolean hasGet(IAnnotationBinding aBinding) {
        return this.hasValue(aBinding, "getMethod");
    }

    private boolean hasSet(IAnnotationBinding aBinding) {
        return this.hasValue(aBinding, "setMethod");
    }

    private boolean hasValue(IAnnotationBinding aBinding, String fieldName) {
        IDataBinding annField = aBinding.findData(fieldName);
        if (!Binding.isValidBinding(annField)) {
            return false;
        }
        return this.hasValue(((AnnotationFieldBinding)annField).getValue());
    }

    protected boolean hasValue(Object obj) {
        return obj != null && obj.toString().length() > 0;
    }

    private boolean hasSetterButNotGetter(IDataBinding binding) {
        IAnnotationBinding aBinding = this.getAnnotation(binding);
        if (aBinding != null) {
            return this.hasSet(aBinding) && !this.hasGet(aBinding);
        }
        return false;
    }
}

