/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;

public class RUIPropertiesLibraryValidator
implements IAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, final IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(Library library) {
                return true;
            }

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                problemRequestor.acceptProblem(nestedFunction, 2066, 2, new String[0]);
                return false;
            }

            @Override
            public boolean visit(UseStatement useStatement) {
                problemRequestor.acceptProblem(useStatement, 2066, 2, new String[0]);
                return false;
            }

            @Override
            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                if (!RUIPropertiesLibraryValidator.this.isValidInRUIPropertiesLibrary(classDataDeclaration)) {
                    problemRequestor.acceptProblem(classDataDeclaration, 2066, 2, new String[0]);
                }
                return false;
            }
        };
        target.accept(visitor);
    }

    private boolean isValidInRUIPropertiesLibrary(ClassDataDeclaration classDataDeclaration) {
        if (classDataDeclaration.isConstant() || classDataDeclaration.isPrivate()) {
            return false;
        }
        ITypeBinding type = classDataDeclaration.getType().resolveTypeBinding();
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        return type == PrimitiveTypeBinding.getInstance(Primitive.STRING);
    }
}

