/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ValueForNonFormFieldValidator
extends DefaultFieldContentAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"value"));
        if (annotationBinding != null && annotationBinding.getValue() != null) {
            ITypeBinding targetTypeBinding;
            Object value = annotationBinding.getValue();
            if (containerBinding != null && (targetTypeBinding = containerBinding.getType()) != null && 3 == targetTypeBinding.getKind()) {
                PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)targetTypeBinding;
                Primitive prim = primTypeBinding.getPrimitive();
                if (Primitive.isStringType(prim)) {
                    if (value instanceof String) {
                        if (Primitive.STRING != prim) {
                            IAnnotationBinding aBinding = containerBinding.getAnnotation(new String[]{"egl", "ui"}, "FieldLen");
                            int maxLength = aBinding != null ? ((Integer)aBinding.getValue()).intValue() : primTypeBinding.getLength();
                            if (this.lengthWithoutBogusChars((String)value) > maxLength) {
                                problemRequestor.acceptProblem(errorNode, 3182, new String[]{value.toString(), "value", String.valueOf(maxLength)});
                            }
                        }
                    } else if (!(value instanceof Number)) {
                        problemRequestor.acceptProblem(errorNode, 3060, new String[]{"value"});
                    }
                } else if (Primitive.isIntegerType(prim) && !(value instanceof Integer)) {
                    problemRequestor.acceptProblem(errorNode, 3186, new String[]{value instanceof Object[] ? "[...]" : value.toString(), "value", prim.getName()});
                }
            }
        }
    }

    private int lengthWithoutBogusChars(String input) {
        int len = 0;
        char[] chars = input.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != '\u200e' && chars[i] != '\u200f') {
                ++len;
            }
            ++i;
        }
        return len;
    }
}

