/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.HandlerBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.InterfaceBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.SystemFunctionBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ForwardStatement;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemLibrary;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionContainerValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class HandlerValidator
extends FunctionContainerValidator {
    private static final String FUNCTION_BEFOREREPORTINIT = InternUtil.internCaseSensitive((String)"beforeReportInit");
    private static final String FUNCTION_AFTERREPORTINIT = InternUtil.internCaseSensitive((String)"afterReportInit");
    private static final String FUNCTION_BEFOREPAGEINIT = InternUtil.internCaseSensitive((String)"beforePageInit");
    private static final String FUNCTION_AFTERPAGEINIT = InternUtil.internCaseSensitive((String)"afterPageInit");
    private static final String FUNCTION_BEFORECOLUMNINIT = InternUtil.internCaseSensitive((String)"beforeColumnInit");
    private static final String FUNCTION_AFTERCOLUMNINIT = InternUtil.internCaseSensitive((String)"afterColumnInit");
    private static final String FUNCTION_BEFOREGROUPINIT = InternUtil.internCaseSensitive((String)"beforeGroupInit");
    private static final String FUNCTION_AFTERGROUPINIT = InternUtil.internCaseSensitive((String)"afterGroupInit");
    private static final String FUNCTION_BEFOREDETAILEVAL = InternUtil.internCaseSensitive((String)"beforeDetailEval");
    private static final String FUNCTION_AFTERDETAILEVAL = InternUtil.internCaseSensitive((String)"afterDetailEval");
    private static final String STRINGVARIABLE = "stringVariable";
    private static final SystemFunctionBinding AFTERDETAILEVAL = SystemLibrary.createSystemFunction(FUNCTION_AFTERDETAILEVAL, null, new String[0], new ITypeBinding[0], new FunctionParameter.UseType[0], 0);
    private static final SystemFunctionBinding BEFOREDETAILEVAL = SystemLibrary.createSystemFunction(FUNCTION_BEFOREDETAILEVAL, null, new String[0], new ITypeBinding[0], new FunctionParameter.UseType[0], 0);
    private static final SystemFunctionBinding AFTERGROUPINIT = SystemLibrary.createSystemFunction(FUNCTION_AFTERGROUPINIT, null, new String[]{"stringVariable"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
    private static final SystemFunctionBinding BEFOREGROUPINIT = SystemLibrary.createSystemFunction(FUNCTION_BEFOREGROUPINIT, null, new String[]{"stringVariable"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.STRING)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
    private static final SystemFunctionBinding AFTERCOLUMNINIT = SystemLibrary.createSystemFunction(FUNCTION_AFTERCOLUMNINIT, null, new String[0], new ITypeBinding[0], new FunctionParameter.UseType[0], 0);
    private static final SystemFunctionBinding BEFORECOLUMNINIT = SystemLibrary.createSystemFunction(FUNCTION_BEFORECOLUMNINIT, null, new String[0], new ITypeBinding[0], new FunctionParameter.UseType[0], 0);
    private static final SystemFunctionBinding AFTERPAGEINIT = SystemLibrary.createSystemFunction(FUNCTION_AFTERPAGEINIT, null, new String[0], new ITypeBinding[0], new FunctionParameter.UseType[0], 0);
    private static final SystemFunctionBinding BEFOREPAGEINIT = SystemLibrary.createSystemFunction(FUNCTION_BEFOREPAGEINIT, null, new String[0], new ITypeBinding[0], new FunctionParameter.UseType[0], 0);
    private static final SystemFunctionBinding AFTERREPORTINIT = SystemLibrary.createSystemFunction(FUNCTION_AFTERREPORTINIT, null, new String[0], new ITypeBinding[0], new FunctionParameter.UseType[0], 0);
    private static final SystemFunctionBinding BEFOREREPORTINTI = SystemLibrary.createSystemFunction(FUNCTION_BEFOREREPORTINIT, null, new String[0], new ITypeBinding[0], new FunctionParameter.UseType[0], 0);
    public static SystemFunctionBinding[] JasperReportCallbackFunctions = new SystemFunctionBinding[]{BEFOREREPORTINTI, AFTERREPORTINIT, BEFOREPAGEINIT, AFTERPAGEINIT, BEFORECOLUMNINIT, AFTERCOLUMNINIT, BEFOREGROUPINIT, AFTERGROUPINIT, BEFOREDETAILEVAL, AFTERDETAILEVAL};
    private static String[] requireEventType = new String[]{InternUtil.intern((String)"ElementName"), InternUtil.intern((String)"RowType"), InternUtil.intern((String)"RowNumber"), InternUtil.intern((String)"GroupName"), InternUtil.intern((String)"ColumnNumber")};
    private static String[] birtPkg = InternUtil.intern((String[])new String[]{"egl", "report", "birt"});
    private static String[] jsfPkg = InternUtil.intern((String[])new String[]{"egl", "ui", "jsf"});
    private static String[] ruiPkg = InternUtil.intern((String[])new String[]{"egl", "rui"});
    private static String eventTypeString = InternUtil.intern((String)"eventType");
    private static Object[] birtFunctionValidationInfo = new Object[]{new Object[]{new Integer(2), new Object[]{new String[]{"LabelInstance", "TextInstance", "DynamicTextInstance", "DataInstance", "ImageInstance", "GridInstance", "TableInstance", "ListInstance", "RowInstance", "CellInstance"}, new String[]{"ReportContext"}}}, new Object[]{new Integer(2), new Object[]{new String[]{"LabelInstance", "TextInstance", "DynamicTextInstance", "DataInstance", "ImageInstance", "GridInstance", "TableInstance", "ListInstance", "RowInstance", "CellInstance"}, new String[]{"ReportContext"}}}, new Object[]{new Integer(2), new Object[]{new String[]{"DataSourceInstance", "DataSetInstance"}, new String[]{"ReportContext"}}}, new Object[]{new Integer(2), new Object[]{new String[]{"DataSourceInstance", "DataSetInstance"}, new String[]{"ReportContext"}}}, new Object[]{new Integer(2), new Object[]{new String[]{"DataSourceInstance", "DataSetInstance"}, new String[]{"ReportContext"}}}, new Object[]{new Integer(1), new Object[]{new String[]{"ReportContext"}}}, new Object[]{new Integer(1), new Object[]{new String[]{"ReportContext"}}}, new Object[]{new Integer(3), new Object[]{new String[]{"DataSetInstance"}, new String[]{"DataSetRow"}, new String[]{"ReportContext"}}}, new Object[]{new Integer(1), new Object[]{new String[]{"DataSourceInstance", "DataSetInstance"}}}, new Object[]{new Integer(1), new Object[]{new String[]{"DataSourceInstance", "DataSetInstance"}}}, new Object[]{new Integer(2), new Object[]{new String[]{"DataSetInstance"}, new String[]{"UpdatableDataSetRow"}}, "boolean"}};
    HandlerBinding handlerBinding = null;
    Handler handler = null;

    public HandlerValidator(IProblemRequestor problemRequestor, HandlerBinding partBinding, ICompilerOptions compilerOptions) {
        super(problemRequestor, partBinding, compilerOptions);
        this.handlerBinding = partBinding;
    }

    @Override
    public boolean visit(Handler ahandler) {
        this.handler = ahandler;
        this.partNode = ahandler;
        EGLNameValidator.validate(this.handler.getName(), 38, this.problemRequestor, this.compilerOptions);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(ahandler);
        this.validateHandler();
        if (this.handlerBinding.getAnnotation(new String[]{"egl", "ui", "jasper"}, "JasperReport") != null) {
            this.validateJasperReportHandler();
        } else if (this.handlerBinding.getAnnotation(birtPkg, "BirtHandler") != null) {
            this.validateBirtHandler();
        } else if (this.handlerBinding.getAnnotation(jsfPkg, "JSFHandler") != null) {
            this.validateJSFHandler();
        } else if (this.handlerBinding.getAnnotation(ruiPkg, "RUIHandler") != null) {
            this.validateRUIHandler();
        }
        this.checkInterfaceFunctionsOverriden();
        return true;
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        super.visit(classDataDeclaration);
        return false;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        super.visit(nestedFunction);
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        super.visit(settingsBlock);
        return false;
    }

    @Override
    public boolean visit(UseStatement useStatement) {
        super.visit(useStatement);
        return false;
    }

    private void validateJSFHandler() {
        IPartBinding part = (IPartBinding)this.handler.getName().resolveBinding();
        if (part == null) {
            return;
        }
        IAnnotationBinding typeAnn = part.getSubTypeAnnotationBinding();
        if (typeAnn == null) {
            return;
        }
        IAnnotationBinding onConstAnn = (IAnnotationBinding)typeAnn.findData("onConstructionFunction");
        if (!Binding.isValidBinding(onConstAnn)) {
            return;
        }
        IFunctionBinding funcBinding = (IFunctionBinding)onConstAnn.getValue();
        if (funcBinding == null) {
            return;
        }
        this.validateNoForward(funcBinding);
    }

    private void validateHandler() {
        DefaultASTVisitor visitor1 = new DefaultASTVisitor(){

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                final String funcName = nestedFunction.getName().getCanonicalName();
                DefaultASTVisitor visitor2 = new DefaultASTVisitor(){

                    @Override
                    public boolean visit(NestedFunction nestedFunction) {
                        return true;
                    }

                    @Override
                    public boolean visit(FunctionParameter functionParameter) {
                        if (functionParameter.getAttrType() == FunctionParameter.AttrType.FIELD) {
                            (this).HandlerValidator.this.problemRequestor.acceptProblem((Node)functionParameter, 5604, new String[]{functionParameter.getName().getCanonicalName(), funcName, (this).HandlerValidator.this.handler.getName().getCanonicalName(), "field"});
                        }
                        return false;
                    }
                };
                nestedFunction.accept(visitor2);
                return false;
            }

            @Override
            public boolean visit(Handler handler) {
                return true;
            }
        };
        this.handler.accept(visitor1);
    }

    private void validateRUIHandler() {
        DefaultASTVisitor visitor1 = new DefaultASTVisitor(){

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                final String funcName = nestedFunction.getName().getCanonicalName();
                DefaultASTVisitor visitor2 = new DefaultASTVisitor(){

                    @Override
                    public boolean visit(NestedFunction nestedFunction) {
                        return true;
                    }

                    @Override
                    public boolean visit(FunctionParameter functionParameter) {
                        if (functionParameter.getAttrType() == FunctionParameter.AttrType.SQLNULLABLE) {
                            (this).HandlerValidator.this.problemRequestor.acceptProblem((Node)functionParameter, 5604, new String[]{functionParameter.getName().getCanonicalName(), funcName, (this).HandlerValidator.this.handler.getName().getCanonicalName(), "sqlnullable"});
                        }
                        return false;
                    }
                };
                nestedFunction.accept(visitor2);
                return false;
            }

            @Override
            public boolean visit(Handler handler) {
                return true;
            }
        };
        this.handler.accept(visitor1);
    }

    private void validateNoForward(final IFunctionBinding funcBinding) {
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(Handler handler) {
                return true;
            }

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                IDataBinding binding = nestedFunction.getName().resolveDataBinding();
                if (Binding.isValidBinding(binding) && binding.getKind() == 20 && ((NestedFunctionBinding)binding).getType() == funcBinding) {
                    HandlerValidator.this.validateNoForward(nestedFunction);
                }
                return false;
            }
        };
        this.handler.accept(visitor);
    }

    private void validateNoForward(NestedFunction function) {
        AbstractASTVisitor visitor = new AbstractASTVisitor(){

            @Override
            public boolean visit(ForwardStatement stmt) {
                if (!stmt.isForwardToURL()) {
                    HandlerValidator.this.problemRequestor.acceptProblem((Node)stmt, 3245, new String[]{HandlerValidator.this.handler.getName().getCanonicalName()});
                }
                return false;
            }
        };
        function.accept(visitor);
    }

    private void validateBirtHandler() {
        final HashMap annotationNodes = new HashMap();
        this.handler.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                int eventType = this.getEventType(nestedFunction);
                this.validateAnnotations(eventType, nestedFunction);
                if (eventType > 0) {
                    this.validateFunctionAttribs(nestedFunction, eventType, this.getEventTypeString(nestedFunction));
                    this.validateElementName(nestedFunction);
                    this.validateOnCreateOnRender(nestedFunction, eventType);
                }
                return false;
            }

            private void validateOnCreateOnRender(NestedFunction nestedFunction, int eventType) {
                IAnnotationBinding rowNum;
                IAnnotationBinding colNum;
                IAnnotationBinding ann;
                if (eventType != 1 && eventType != 2) {
                    return;
                }
                int rowType = this.getRowType(nestedFunction);
                if ((rowType == 4 || rowType == 5) && (ann = this.getBirtAnnotationBinding("groupName", nestedFunction)) == null) {
                    HandlerValidator.this.problemRequestor.acceptProblem((Node)annotationNodes.get(InternUtil.intern((String)"rowType")), 3237, new String[]{"GroupName", "RowType", this.getRowTypeString(nestedFunction)});
                }
                if (nestedFunction.getFunctionParameters().size() < 1) {
                    return;
                }
                ITypeBinding type = ((FunctionParameter)nestedFunction.getFunctionParameters().get(0)).getType().resolveTypeBinding();
                if (!Binding.isValidBinding(type)) {
                    return;
                }
                if (!(type.getName() != InternUtil.intern((String)"CellInstance") || (colNum = this.getBirtAnnotationBinding("columnNumber", nestedFunction)) == null || colNum.getValue() instanceof Integer && (Integer)colNum.getValue() >= 1)) {
                    HandlerValidator.this.problemRequestor.acceptProblem((Node)annotationNodes.get(InternUtil.intern((String)"columnNumber")), 3238, new String[]{"ColumnNumber"});
                }
                if (!(type.getName() != InternUtil.intern((String)"RowInstance") && type.getName() != InternUtil.intern((String)"CellInstance") || (rowNum = this.getBirtAnnotationBinding("rowNumber", nestedFunction)) == null || rowNum.getValue() instanceof Integer && (Integer)rowNum.getValue() >= 1)) {
                    HandlerValidator.this.problemRequestor.acceptProblem((Node)annotationNodes.get(InternUtil.intern((String)"rowNumber")), 3238, new String[]{"RowNumber"});
                }
            }

            private IAnnotationBinding getBirtAnnotationBinding(String name, NestedFunction nestedFunction) {
                IBinding binding = nestedFunction.getName().resolveBinding();
                return binding.getAnnotation(birtPkg, name);
            }

            private void validateElementName(NestedFunction nestedFunction) {
                IAnnotationBinding ann = this.getBirtAnnotationBinding("elementName", nestedFunction);
                if (ann == null) {
                    HandlerValidator.this.problemRequestor.acceptProblem((Node)annotationNodes.get(eventTypeString), 3237, new String[]{"ElementName", "EventType", this.getEventTypeString(nestedFunction)});
                }
            }

            private void validateFunctionAttribs(NestedFunction nestedFunction, int eventType, String evType) {
                if (eventType > birtFunctionValidationInfo.length) {
                    return;
                }
                String functionName = nestedFunction.getName().getCanonicalName();
                Object[] info = (Object[])birtFunctionValidationInfo[eventType - 1];
                int numParms = (Integer)info[0];
                Object[] parmsInfo = (Object[])info[1];
                String returnInfo = null;
                if (info.length == 3) {
                    returnInfo = (String)info[2];
                }
                if (returnInfo != null) {
                    ITypeBinding type;
                    boolean error = true;
                    if (nestedFunction.hasReturnType() && Binding.isValidBinding(type = nestedFunction.getReturnType().resolveTypeBinding()) && type.getName() == InternUtil.intern((String)returnInfo)) {
                        error = false;
                    }
                    if (error) {
                        HandlerValidator.this.problemRequestor.acceptProblem((Node)nestedFunction.getName(), 3232, new String[]{functionName, evType, returnInfo});
                    }
                } else if (nestedFunction.hasReturnType()) {
                    HandlerValidator.this.problemRequestor.acceptProblem((Node)nestedFunction.getName(), 3233, new String[]{functionName, evType});
                }
                if (nestedFunction.getFunctionParameters().size() != numParms) {
                    HandlerValidator.this.problemRequestor.acceptProblem((Node)nestedFunction.getName(), 3234, new String[]{functionName, evType, Integer.toString(numParms)});
                    return;
                }
                Iterator i = nestedFunction.getFunctionParameters().iterator();
                int index = 0;
                while (i.hasNext()) {
                    FunctionParameter parm = (FunctionParameter)i.next();
                    this.validateParmType(parm, (String[])parmsInfo[index], evType, functionName);
                    ++index;
                }
            }

            private void validateParmType(FunctionParameter parm, String[] validTypes, String evType, String functionName) {
                int i;
                boolean error = true;
                ITypeBinding parmType = parm.getType().resolveTypeBinding();
                if (Binding.isValidBinding(parmType)) {
                    ExternalTypeBinding extType;
                    if (parmType.getKind() == 28 && (extType = (ExternalTypeBinding)parmType).getPackageName() == birtPkg) {
                        i = 0;
                        while (i < validTypes.length && error) {
                            if (extType.getName() == InternUtil.intern((String)validTypes[i])) {
                                error = false;
                            }
                            ++i;
                        }
                    }
                } else {
                    error = false;
                }
                if (error) {
                    if (validTypes.length == 1) {
                        HandlerValidator.this.problemRequestor.acceptProblem((Node)parm.getType(), 3235, new String[]{parm.getName().getCanonicalName(), functionName, evType, validTypes[0]});
                    } else {
                        StringBuffer buffer = new StringBuffer();
                        i = 0;
                        while (i < validTypes.length) {
                            if (i != 0) {
                                buffer.append(", ");
                            }
                            buffer.append(validTypes[i]);
                            ++i;
                        }
                        HandlerValidator.this.problemRequestor.acceptProblem((Node)parm.getType(), 3236, new String[]{parm.getName().getCanonicalName(), functionName, evType, buffer.toString()});
                    }
                }
            }

            private int getRowType(NestedFunction nestedFunction) {
                IAnnotationBinding ann = this.getBirtAnnotationBinding("rowType", nestedFunction);
                if (ann == null) {
                    return -1;
                }
                EnumerationDataBinding enumBinding = (EnumerationDataBinding)ann.getValue();
                return enumBinding.geConstantValue();
            }

            private String getRowTypeString(NestedFunction nestedFunction) {
                IBinding binding = nestedFunction.getName().resolveBinding();
                IAnnotationBinding ann = binding.getAnnotation(birtPkg, "rowType");
                if (ann == null) {
                    return "";
                }
                EnumerationDataBinding enumBinding = (EnumerationDataBinding)ann.getValue();
                return enumBinding.getCaseSensitiveName();
            }

            private int getEventType(NestedFunction nestedFunction) {
                IAnnotationBinding ann = this.getBirtAnnotationBinding(eventTypeString, nestedFunction);
                if (ann == null) {
                    return -1;
                }
                EnumerationDataBinding enumBinding = (EnumerationDataBinding)ann.getValue();
                return enumBinding.geConstantValue();
            }

            private String getEventTypeString(NestedFunction nestedFunction) {
                IBinding binding = nestedFunction.getName().resolveBinding();
                IAnnotationBinding ann = binding.getAnnotation(birtPkg, eventTypeString);
                if (ann == null) {
                    return "";
                }
                EnumerationDataBinding enumBinding = (EnumerationDataBinding)ann.getValue();
                return enumBinding.getCaseSensitiveName();
            }

            private void validateAnnotations(final int eventType, NestedFunction function) {
                function.accept(new AbstractASTVisitor(){

                    @Override
                    public boolean visit(SettingsBlock settingsBlock) {
                        return true;
                    }

                    @Override
                    public boolean visit(Assignment assignment) {
                        IAnnotationTypeBinding type;
                        IAnnotationBinding ann = assignment.resolveBinding();
                        if (ann != null && (type = ann.getAnnotationType()) != null && type.getPackageName() == birtPkg) {
                            annotationNodes.put(ann.getName(), assignment.getRightHandSide());
                            if (eventType == -1) {
                                int i = 0;
                                while (i < requireEventType.length) {
                                    if (ann.getName() == requireEventType[i]) {
                                        (this).HandlerValidator.this.problemRequestor.acceptProblem((Node)assignment.getLeftHandSide(), 3027, new String[]{"EventType", ann.getCaseSensitiveName()});
                                    }
                                    ++i;
                                }
                            }
                        }
                        return false;
                    }
                });
            }
        });
    }

    protected void validateJasperReportHandler() {
        this.handler.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                ITypeBinding binding;
                SystemFunctionBinding sysBinding = HandlerValidator.this.getCallbackFunction(nestedFunction);
                if (sysBinding != null && StatementValidator.isValidBinding(binding = ((NestedFunctionBinding)nestedFunction.getName().resolveBinding()).getType()) && binding.isFunctionBinding()) {
                    FunctionBinding funcBinding = (FunctionBinding)binding;
                    if (sysBinding.getParameters().size() != funcBinding.getParameters().size()) {
                        HandlerValidator.this.problemRequestor.acceptProblem((Node)nestedFunction.getName(), 3015, new String[]{nestedFunction.getName().getCanonicalName(), new Integer(sysBinding.getParameters().size()).toString()});
                    } else {
                        int i = 0;
                        while (i < sysBinding.getParameters().size()) {
                            boolean error;
                            FunctionParameterBinding sysParam = HandlerValidator.this.getFunctionParameterBinding((IBinding)sysBinding.getParameters().get(i));
                            FunctionParameterBinding funcParam = HandlerValidator.this.getFunctionParameterBinding((IBinding)funcBinding.getParameters().get(i));
                            boolean bl = error = funcParam == null;
                            if (!error) {
                                boolean bl2 = error = this.getNonNullable(sysParam.getType()) != this.getNonNullable(funcParam.getType());
                            }
                            if (error) {
                                FunctionParameter p = (FunctionParameter)nestedFunction.getFunctionParameters().get(i);
                                HandlerValidator.this.problemRequestor.acceptProblem((Node)p.getName(), 3016, new String[]{p != null ? p.getName().getCanonicalName() : "", funcBinding.getName(), StatementValidator.getTypeString(sysParam.getType())});
                            }
                            ++i;
                        }
                    }
                }
                return false;
            }

            private ITypeBinding getNonNullable(ITypeBinding type) {
                return type.isNullable() ? type.getNonNullableInstance() : type;
            }
        });
    }

    protected FunctionParameterBinding getFunctionParameterBinding(IBinding binding) {
        if (StatementValidator.isValidBinding(binding) && binding.isDataBinding() && ((IDataBinding)binding).getKind() == 0) {
            return (FunctionParameterBinding)binding;
        }
        return null;
    }

    protected SystemFunctionBinding getCallbackFunction(NestedFunction nestedFunction) {
        String fName = InternUtil.intern((String)nestedFunction.getName().getCanonicalName());
        int i = 0;
        while (i < JasperReportCallbackFunctions.length) {
            if (fName == JasperReportCallbackFunctions[i].getName()) {
                return JasperReportCallbackFunctions[i];
            }
            ++i;
        }
        return null;
    }

    private void checkInterfaceFunctionsOverriden() {
        Iterator iter = this.getInterfaceFunctionList().iterator();
        while (iter.hasNext()) {
            IFunctionBinding interfaceFunc = (IFunctionBinding)((NestedFunctionBinding)iter.next()).getType();
            boolean foundMatchingHandlerFunc = false;
            Iterator iter2 = this.handlerBinding.getDeclaredFunctions().iterator();
            while (!foundMatchingHandlerFunc && iter2.hasNext()) {
                IFunctionBinding handlerFunc = (IFunctionBinding)((NestedFunctionBinding)iter2.next()).getType();
                if (!TypeCompatibilityUtil.functionSignituresAreIdentical(handlerFunc, interfaceFunc, this.compilerOptions)) continue;
                foundMatchingHandlerFunc = true;
            }
            if (foundMatchingHandlerFunc) continue;
            this.problemRequestor.acceptProblem((Node)this.handler.getName(), 3400, new String[]{this.handler.getName().getCanonicalName(), String.valueOf(interfaceFunc.getCaseSensitiveName()) + "(" + HandlerValidator.getTypeNamesList(interfaceFunc.getParameters()) + ")", interfaceFunc.getDeclarer().getCaseSensitiveName()});
        }
    }

    private List getInterfaceFunctionList() {
        ArrayList<NestedFunctionBinding> retVal = new ArrayList<NestedFunctionBinding>();
        List interfaceList = this.handlerBinding.getImplementedInterfaces();
        int i = 0;
        while (i < interfaceList.size()) {
            InterfaceBinding interfaceBinding = (InterfaceBinding)interfaceList.get(i);
            for (NestedFunctionBinding fBinding : interfaceBinding.getDeclaredAndInheritedFunctions()) {
                if (fBinding.isPrivate()) continue;
                retVal.add(fBinding);
            }
            ++i;
        }
        return retVal;
    }

    private static String getTypeNamesList(List types) {
        StringBuffer sb = new StringBuffer();
        if (!types.isEmpty()) {
            sb.append(" ");
        }
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            FunctionParameterBinding nextParm = (FunctionParameterBinding)iter.next();
            ITypeBinding nextType = nextParm.getType();
            if (!StatementValidator.isValidBinding(nextType)) continue;
            sb.append(nextType.getCaseSensitiveName());
            if (nextParm.isInput()) {
                sb.append(" in");
            } else if (nextParm.isOutput()) {
                sb.append(" out");
            } else {
                sb.append(" inOut");
            }
            if (iter.hasNext()) {
                sb.append(", ");
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }
}

