/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.Iterator;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.FieldValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class ClassDataDeclarationValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IPartBinding declaringPart;

    public ClassDataDeclarationValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IPartBinding declaringPart) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
        this.declaringPart = declaringPart;
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        Iterator iter = classDataDeclaration.getNames().iterator();
        while (iter.hasNext()) {
            EGLNameValidator.validate((Name)iter.next(), 1, this.problemRequestor, this.compilerOptions);
        }
        StatementValidator.validateDataDeclarationInitializer(classDataDeclaration, this.problemRequestor, this.compilerOptions);
        if (classDataDeclaration.isConstant()) {
            StatementValidator.validatePrimitiveConstant(classDataDeclaration.getType(), this.problemRequestor);
        }
        StatementValidator.validateDataDeclarationType(classDataDeclaration.getType(), this.problemRequestor, this.declaringPart);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(classDataDeclaration);
        IBinding binding = ((Name)classDataDeclaration.getNames().get(0)).resolveBinding();
        if (binding != null && IBinding.NOT_FOUND_BINDING != binding && binding.isDataBinding()) {
            StatementValidator.validateDeclarationForStereotypeContext((IDataBinding)binding, this.problemRequestor, classDataDeclaration.getType().getBaseType());
        }
        classDataDeclaration.accept(new FieldValidator(this.problemRequestor, this.compilerOptions));
        return false;
    }
}

