/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.ConverseStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class ConverseStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;
    private IPartBinding enclosingPart;

    public ConverseStatementValidator(IProblemRequestor problemRequestor, IPartBinding enclosingPart) {
        this.problemRequestor = problemRequestor;
        this.enclosingPart = enclosingPart;
    }

    static StatementValidator.ITargetsContainerChecker getTargetsContainerChecker() {
        StatementValidator.ITargetsContainerChecker checker = new StatementValidator.ITargetsContainerChecker(){

            @Override
            public boolean isLibraryDataAllowed(IDataBinding dataBinding) {
                if (!Binding.isValidBinding(dataBinding)) {
                    return false;
                }
                ITypeBinding targetBinding = dataBinding.getType();
                if (StatementValidator.isValidBinding(targetBinding)) {
                    return StatementValidator.isFlexibleBasicOrSQL(targetBinding);
                }
                return false;
            }
        };
        return checker;
    }

    private void validateStatementAllowedInContainer(ConverseStatement converseStatement) {
    }

    @Override
    public boolean visit(ConverseStatement converseStatement) {
        StatementValidator.validateIOTargetsContainer(converseStatement.getIOObjects(), this.problemRequestor, ConverseStatementValidator.getTargetsContainerChecker());
        this.validateStatementAllowedInContainer(converseStatement);
        if (this.enclosingPart != null) {
            if (13 == this.enclosingPart.getKind()) {
                if (this.enclosingPart.getAnnotation(EGLCORE, "BasicProgram") != null) {
                    this.problemRequestor.acceptProblem((Node)converseStatement, 6554, new String[]{"converse"});
                } else if (this.enclosingPart.getAnnotation(EGLUITEXT, "TextUIProgram") != null) {
                    Expression expr = converseStatement.getTarget();
                    ITypeBinding targetBinding = expr.resolveTypeBinding();
                    if (StatementValidator.isValidBinding(targetBinding) && targetBinding.getAnnotation(EGLUITEXT, "TextForm") == null) {
                        this.problemRequestor.acceptProblem((Node)expr, 6662, new String[]{expr.getCanonicalString()});
                    }
                } else if (this.enclosingPart.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") != null) {
                    Expression expr = converseStatement.getTarget();
                    ITypeBinding targetBinding = expr.resolveTypeBinding();
                    if (StatementValidator.isValidBinding(targetBinding) && targetBinding.getAnnotation(EGLUIWEBTRANSACTION, "VGUIRecord") == null) {
                        this.problemRequestor.acceptProblem((Node)expr, 6661, new String[]{expr.getCanonicalString()});
                    }
                } else if (this.enclosingPart.getAnnotation(EGLUIGATEWAY, "UIProgram") != null) {
                    this.validateTargetIsFlexibleRecord(converseStatement);
                }
            } else if (11 == this.enclosingPart.getKind()) {
                this.validateTargetIsFlexibleRecord(converseStatement);
            }
        }
        return false;
    }

    private void validateTargetIsFlexibleRecord(ConverseStatement converseStatement) {
        Expression expr = converseStatement.getTarget();
        ITypeBinding targetBinding = expr.resolveTypeBinding();
        if (StatementValidator.isValidBinding(targetBinding) && !StatementValidator.isFlexibleBasicOrSQL(targetBinding)) {
            this.problemRequestor.acceptProblem((Node)expr, 6601, new String[]{expr.getCanonicalString()});
        }
    }
}

