/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IDliIOStatement;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UsingPCBClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.annotation.MustBeDLINameAnnotationValidator;
import org.eclipse.edt.compiler.internal.dli.IBooleanExpression;
import org.eclipse.edt.compiler.internal.dli.IBooleanExpressionSSAConditions;
import org.eclipse.edt.compiler.internal.dli.IBooleanOperatorExpression;
import org.eclipse.edt.compiler.internal.dli.ICommandCodes;
import org.eclipse.edt.compiler.internal.dli.ICondition;
import org.eclipse.edt.compiler.internal.dli.ISSAConditions;
import org.eclipse.edt.compiler.internal.dli.ISegmentSearchArgument;
import org.eclipse.edt.compiler.internal.dli.IStatement;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.DLIDefaultStatementFactory;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IDLISegmentRecord;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IHierarchy;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IHierarchyEntry;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IPCB;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.IRelationship;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class DLIStatementValidator {
    private static HashMap functionCallsToValidCommandCodes = new HashMap();
    private static final int ADD_IO = 1;
    private static final int GET_KEY_IO = 2;
    private static final int GET_POSITION_IO = 3;
    private static final int REPLACE_IO = 4;
    private static final int DELETE_IO = 5;
    private IDliIOStatement dliIOStmt;
    private IProblemRequestor problemRequestor;
    private int dliIOType = 0;
    private int offset = 0;
    private boolean inlineDLIStatement = false;
    private String pcbName;
    private boolean forUpdate = false;
    private boolean getInParent = false;
    private DLIDefaultStatementFactory dliStmtFactory = null;
    private boolean hasValidTarget = false;
    private boolean targetIsArray = false;

    static {
        functionCallsToValidCommandCodes.put("GU", "DLQUVCPMRSWZ");
        functionCallsToValidCommandCodes.put("GHU", "DLQUVCPMRSWZ");
        functionCallsToValidCommandCodes.put("ISRT", "DLFUVCMRSWZ");
        functionCallsToValidCommandCodes.put("REPL", "NMSWZ");
        functionCallsToValidCommandCodes.put("DLET", "Z");
        functionCallsToValidCommandCodes.put("GN", "DLFQUVCPMRSWZ");
        functionCallsToValidCommandCodes.put("GNP", "DLFQUVCPMRSWZ");
        functionCallsToValidCommandCodes.put("GHN", "DLFQUVCPMRSWZ");
        functionCallsToValidCommandCodes.put("GHNP", "DLFQUVCPMRSWZ");
    }

    public DLIStatementValidator(IDliIOStatement statement, IProblemRequestor problemRequestor, int dliIOType) {
        this.dliIOStmt = statement;
        this.problemRequestor = problemRequestor;
        this.dliIOType = dliIOType;
    }

    public void validateGetByPosDLI(UsingPCBClause pcbClause, boolean hasForUpdate, boolean hasGetInParent) {
        this.setForUpdate(hasForUpdate);
        this.setGetInParent(hasGetInParent);
        this.validateDLI(pcbClause);
    }

    public void validateGetByKeyDLI(UsingPCBClause pcbClause, boolean hasForUpdate) {
        this.setForUpdate(hasForUpdate);
        this.validateDLI(pcbClause);
    }

    public void validateDLI(UsingPCBClause pcbClause) {
        this.initialize(pcbClause);
        if (this.isInlineDLIStatement()) {
            this.validateInlineDLI();
        }
        if (this.isInlineDLIStatement() || this.hasValidTarget()) {
            this.validateDLIStatement();
        }
    }

    private void validateInlineDLI() {
        Iterator i = this.dliIOStmt.getDliInfo().getModel().getStatements().iterator();
        boolean first = true;
        int index = 1;
        while (i.hasNext()) {
            IStatement modelStmt = (IStatement)i.next();
            if (first) {
                this.validateFunctionCodes(modelStmt);
                first = false;
            }
            this.validateCommandCodes(modelStmt);
            this.validateOnlyOneSsaAllowed(modelStmt);
            this.validateHasAtLeastOneSSA(modelStmt);
            if (index > 1) {
                if (this.getDliIOType() == 2) {
                    if (index == 2) {
                        if (!"GN".equalsIgnoreCase(modelStmt.getDLIFunction()) && !"GNP".equalsIgnoreCase(modelStmt.getDLIFunction())) {
                            this.problemRequestor.acceptProblem(this.getOffset() + modelStmt.getOffset(), this.getOffset() + modelStmt.getOffset() + modelStmt.getDLIFunction().length(), 2, 7884, new String[]{modelStmt.getDLIFunction()});
                        } else if (modelStmt.getSegmentSearchArguments() != null && modelStmt.getSegmentSearchArguments().size() > 1) {
                            this.problemRequestor.acceptProblem(this.getOffset() + modelStmt.getOffset(), this.getOffset() + modelStmt.getOffset() + modelStmt.getLength(), 2, 7916);
                        }
                    } else {
                        this.problemRequestor.acceptProblem(this.getOffset() + modelStmt.getOffset(), this.getOffset() + modelStmt.getOffset() + modelStmt.getLength(), 2, 7886, new String[]{modelStmt.getDLIFunction()});
                    }
                } else {
                    this.problemRequestor.acceptProblem(this.getOffset() + modelStmt.getOffset(), this.getOffset() + modelStmt.getOffset() + modelStmt.getLength(), 2, 7900, new String[]{modelStmt.getDLIFunction()});
                }
            }
            ++index;
        }
    }

    private void validateHasAtLeastOneSSA(IStatement modelStmt) {
        if (modelStmt == null) {
            return;
        }
        if ("gn".equalsIgnoreCase(modelStmt.getDLIFunction()) || "ghn".equalsIgnoreCase(modelStmt.getDLIFunction()) || "gnp".equalsIgnoreCase(modelStmt.getDLIFunction()) || "ghnp".equalsIgnoreCase(modelStmt.getDLIFunction())) {
            return;
        }
        if (modelStmt.getSegmentSearchArguments() == null || modelStmt.getSegmentSearchArguments().size() == 0) {
            this.problemRequestor.acceptProblem(this.getOffset() + modelStmt.getOffset(), this.getOffset() + modelStmt.getOffset() + modelStmt.getLength(), 2, 7922);
        }
    }

    private void validateOnlyOneSsaAllowed(IStatement modelStmt) {
        if ("dlet".equalsIgnoreCase(modelStmt.getDLIFunction()) && modelStmt.getSegmentSearchArguments() != null && modelStmt.getSegmentSearchArguments().size() > 1) {
            this.problemRequestor.acceptProblem(this.getOffset() + modelStmt.getOffset(), this.getOffset() + modelStmt.getOffset() + modelStmt.getLength(), 2, 7913, new String[]{modelStmt.getDLIFunction()});
        }
    }

    private void validateCommandCodes(IStatement stmt) {
        String dliFunction = stmt.getDLIFunction();
        List ssas = stmt.getSegmentSearchArguments();
        Iterator i = ssas.iterator();
        ArrayList allPreviousCommandCodes = new ArrayList();
        ArrayList allPreviousSSASegmentNames = new ArrayList();
        while (i.hasNext()) {
            ISegmentSearchArgument ssa = (ISegmentSearchArgument)i.next();
            this.validateCommandCodes(ssa, dliFunction, allPreviousCommandCodes, allPreviousSSASegmentNames);
        }
    }

    private void validateCommandCodes(ISegmentSearchArgument ssa, String dliFunction, List allPreviousCommandCodes, List allPreviousSSASegmentNames) {
        ICommandCodes cmdCodes = ssa.getCommandCodes();
        this.checkValuesClause(ssa, cmdCodes);
        this.checkQualificationAllowed(ssa, dliFunction);
        this.checkSSASegmentName(ssa, allPreviousCommandCodes);
        if (cmdCodes == null) {
            this.checkCommandCodeD(allPreviousCommandCodes, ssa, dliFunction);
            return;
        }
        String validCodes = (String)functionCallsToValidCommandCodes.get(dliFunction.toUpperCase());
        if (validCodes == null) {
            return;
        }
        CommandCode[] codes = this.parseCommandCodes(cmdCodes.getCommandCodes().toUpperCase());
        this.checkCommandCodesForOneAllowed(codes, cmdCodes);
        if (cmdCodes.getCommandCodes().length() > 4) {
            int startOffset = this.getOffset() + cmdCodes.getOffset();
            this.problemRequestor.acceptProblem(startOffset, startOffset + codes.length, 2, 7889);
        }
        ArrayList<String> codesAlreadyFound = new ArrayList<String>();
        int i = 0;
        while (i < codes.length) {
            int startOffset;
            CommandCode code = codes[i];
            if (validCodes.indexOf(code.getCode()) == -1) {
                startOffset = this.getOffset() + cmdCodes.getOffset() + code.getOffset();
                this.problemRequestor.acceptProblem(startOffset, startOffset + 1, 2, 7888, new String[]{code.getCode(), dliFunction});
            }
            this.checkMutuallyExclusiveCommandCodes(code, codesAlreadyFound, cmdCodes);
            this.checkCommandCodeC(code, allPreviousCommandCodes, cmdCodes, ssa, dliFunction);
            this.checkNumModifier(code, ssa);
            if (codesAlreadyFound.indexOf(code.getCode()) == -1) {
                codesAlreadyFound.add(code.getCode());
            } else {
                startOffset = this.getOffset() + cmdCodes.getOffset() + code.getOffset();
                this.problemRequestor.acceptProblem(startOffset, startOffset + 1, 2, 7891, new String[]{code.getCode()});
            }
            ++i;
        }
        allPreviousCommandCodes.addAll(codesAlreadyFound);
        this.checkCommandCodeD(allPreviousCommandCodes, ssa, dliFunction);
    }

    private void checkNumModifier(CommandCode code, ISegmentSearchArgument ssa) {
        String codeChar = code.getCode();
        if ("M".equals(codeChar) || "R".equals(codeChar) || "S".equals(codeChar) || "W".equals(codeChar) || "Z".equals(codeChar)) {
            if (code.getModifier().length() == 0) {
                int startOffset = this.getOffset() + ssa.getCommandCodes().getOffset() + code.getOffset();
                int endOffset = startOffset + code.getLength();
                this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7937, new String[]{code.getCode()});
            } else if (code.getModifierAsInt() < 1 || code.getModifierAsInt() > 8) {
                int startOffset = this.getOffset() + ssa.getCommandCodes().getOffset() + code.getOffset();
                int endOffset = startOffset + code.getLength();
                this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7938, new String[]{code.getCode(), code.getModifier()});
            }
        } else if (code.getModifier().length() > 0) {
            int startOffset = this.getOffset() + ssa.getCommandCodes().getOffset() + code.getOffset();
            int endOffset = startOffset + code.getLength();
            this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7936, new String[]{code.getCode(), code.getModifier()});
        }
    }

    private boolean isDigit(String string) {
        return string.equals("0") || string.equals("1") || string.equals("2") || string.equals("3") || string.equals("4") || string.equals("5") || string.equals("6") || string.equals("7") || string.equals("8") || string.equals("9");
    }

    private CommandCode[] parseCommandCodes(String codes) {
        ArrayList<CommandCode> list = new ArrayList<CommandCode>();
        CommandCode prevCode = null;
        int i = 0;
        while (i < codes.length()) {
            String codeChar = codes.substring(i, i + 1);
            if (prevCode != null && this.isDigit(codeChar)) {
                prevCode.appendModifier(codeChar);
            } else {
                prevCode = new CommandCode(codeChar, i);
                list.add(prevCode);
            }
            ++i;
        }
        return list.toArray(new CommandCode[list.size()]);
    }

    private void checkQualificationAllowed(ISegmentSearchArgument ssa, String dliFunction) {
        if ("repl".equalsIgnoreCase(dliFunction) && ssa != null && ssa.getSSAConditions() != null) {
            int startOffset = this.getOffset() + ssa.getSSAConditions().getOffset();
            int endOffset = startOffset + ssa.getSSAConditions().getLength();
            this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7917);
        }
    }

    private void checkSSASegmentName(ISegmentSearchArgument ssa, List allPreviousSSASegmentNames) {
        if (ssa == null || ssa.getSegmentName() == null) {
            return;
        }
        if (allPreviousSSASegmentNames.contains(ssa.getSegmentName().getName().toUpperCase())) {
            int startOffset = this.getOffset() + ssa.getSegmentName().getOffset();
            int endOffset = startOffset + ssa.getSegmentName().getLength();
            this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7907, new String[]{ssa.getSegmentName().getName()});
        }
        allPreviousSSASegmentNames.add(ssa.getSegmentName().getName().toUpperCase());
    }

    private void checkValuesClause(ISegmentSearchArgument ssa, ICommandCodes codes) {
        if (ssa.getSSAConditions() == null || !ssa.getSSAConditions().isValueExpressionSSAConditions()) {
            return;
        }
        if (codes != null && codes.getCommandCodes() != null && codes.getCommandCodes().toUpperCase().indexOf("C") != -1) {
            return;
        }
        int startOffset = this.getOffset() + ssa.getSSAConditions().getOffset();
        int endOffset = startOffset + ssa.getSSAConditions().getLength();
        this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7901);
    }

    private void checkMutuallyExclusiveCommandCodes(CommandCode code, List codesAlreadyFound, ICommandCodes cmdCodes) {
        String incompatCode = null;
        boolean incompatFound = false;
        if ("R".equalsIgnoreCase(code.getCode())) {
            if (codesAlreadyFound.contains("F")) {
                incompatCode = "F";
                incompatFound = true;
            }
            if (codesAlreadyFound.contains("Q")) {
                incompatCode = "Q";
                incompatFound = true;
            }
        }
        if ("L".equalsIgnoreCase(code.getCode()) && codesAlreadyFound.contains("F")) {
            incompatCode = "F";
            incompatFound = true;
        }
        if ("U".equalsIgnoreCase(code.getCode()) && codesAlreadyFound.contains("V")) {
            incompatCode = "V";
            incompatFound = true;
        }
        if ("F".equalsIgnoreCase(code.getCode())) {
            if (codesAlreadyFound.contains("R")) {
                incompatCode = "R";
                incompatFound = true;
            }
            if (codesAlreadyFound.contains("L")) {
                incompatCode = "L";
                incompatFound = true;
            }
        }
        if ("Q".equalsIgnoreCase(code.getCode()) && codesAlreadyFound.contains("R")) {
            incompatCode = "R";
            incompatFound = true;
        }
        if ("V".equalsIgnoreCase(code.getCode()) && codesAlreadyFound.contains("U")) {
            incompatCode = "U";
            incompatFound = true;
        }
        if (incompatFound) {
            int startOffset = this.getOffset() + cmdCodes.getOffset() + code.getOffset();
            this.problemRequestor.acceptProblem(startOffset, startOffset + 1, 2, 7890, new String[]{incompatCode, code.getCode()});
        }
    }

    private void checkCommandCodeC(CommandCode code, List allPreviousCommandCodes, ICommandCodes cmdCodes, ISegmentSearchArgument ssa, String dliFunction) {
        int startOffset;
        if (!"C".equals(code.getCode())) {
            return;
        }
        if (allPreviousCommandCodes.contains("C")) {
            startOffset = this.getOffset() + cmdCodes.getOffset() + code.getOffset();
            this.problemRequestor.acceptProblem(startOffset, startOffset + 1, 2, 7894);
        }
        if (ssa.getSSAConditions() != null && !ssa.getSSAConditions().isValueExpressionSSAConditions()) {
            startOffset = this.getOffset() + ssa.getSSAConditions().getOffset();
            this.problemRequestor.acceptProblem(startOffset, startOffset + ssa.getSSAConditions().getLength(), 2, 7895);
        }
        if ("ISRT".equalsIgnoreCase(dliFunction) && allPreviousCommandCodes.contains("D")) {
            startOffset = this.getOffset() + cmdCodes.getOffset() + code.getOffset();
            this.problemRequestor.acceptProblem(startOffset, startOffset + 1, 2, 7896);
        }
    }

    private void checkCommandCodeD(List allPreviousCommandCodes, ISegmentSearchArgument ssa, String dliFunction) {
        if (allPreviousCommandCodes.contains("D") && "ISRT".equalsIgnoreCase(dliFunction) && ssa.getSSAConditions() != null) {
            int startOffset = this.getOffset() + ssa.getSSAConditions().getOffset();
            this.problemRequestor.acceptProblem(startOffset, startOffset + ssa.getSSAConditions().getLength(), 2, 7897);
        }
    }

    private void checkCommandCodesForOneAllowed(CommandCode[] codes, ICommandCodes cmdCodes) {
        boolean foundM = false;
        boolean foundS = false;
        boolean foundW = false;
        boolean foundZ = false;
        int i = 0;
        while (i < codes.length) {
            if ("M".equalsIgnoreCase(codes[i].code)) {
                foundM = true;
            } else if ("S".equalsIgnoreCase(codes[i].code)) {
                foundS = true;
            } else if ("W".equalsIgnoreCase(codes[i].code)) {
                foundW = true;
            } else if ("Z".equalsIgnoreCase(codes[i].code)) {
                foundZ = true;
            }
            ++i;
        }
        int numFound = 0;
        if (foundM) {
            ++numFound;
        }
        if (foundS) {
            ++numFound;
        }
        if (foundW) {
            ++numFound;
        }
        if (foundZ) {
            ++numFound;
        }
        if (numFound > 1) {
            int startOffset = this.getOffset() + cmdCodes.getOffset();
            this.problemRequestor.acceptProblem(startOffset, startOffset + cmdCodes.getLength(), 2, 7892);
        }
    }

    private void validateDLIStatement() {
        this.checkForPCB();
        this.validateIOTargetsInPCB();
        if (!this.dliIOStmt.getDliInfo().isHasDLICall()) {
            this.validateHaveHierarchy();
            return;
        }
        Iterator i = this.dliIOStmt.getDliInfo().getModel().getStatements().iterator();
        int j = 1;
        while (i.hasNext()) {
            IStatement modelStmt = (IStatement)i.next();
            this.validateSSAs(modelStmt.getSegmentSearchArguments());
            if (this.isInlineDLIStatement()) {
                this.validateFunctionCodesNeedingContext(modelStmt, j, i.hasNext());
                this.validateCommandCodesWithTargetArray(modelStmt);
                this.validateLastSSA(modelStmt);
                this.validateSSAsWithPathCallHaveTarget(modelStmt);
                this.validateSSAHierarchy(modelStmt);
                this.validateSSAsInPCB(modelStmt);
                if (j == 1) {
                    this.validateSSAForEachTarget(modelStmt);
                }
            }
            ++j;
        }
    }

    private void validateHaveHierarchy() {
        if (this.getDliStmtFactory().getPCB() != null && this.getDliStmtFactory().getPCB().getPCB() != null && this.getDliStmtFactory().getPCB().getPCB().getPCBType() != null && this.getDliStmtFactory().getPCB().getPCB().getPCBType().getName() == InternUtil.intern((String)"GSAM")) {
            return;
        }
        if (!(this.getPcbName() == null || this.getDliStmtFactory().getPCB() == null || this.getDliStmtFactory().getPCB().getPCB() != null && this.getDliStmtFactory().getPCB().getPCB().getHierarchy() != null && this.getDliStmtFactory().getPCB().getPCB().getHierarchy().length != 0 || this.getDliIOType() != 1 && this.getDliIOType() != 2)) {
            this.problemRequestor.acceptProblem((Node)((Object)this.dliIOStmt), 7921, 2, new String[]{this.getPcbName()});
        }
    }

    private void validateSSAsWithPathCallHaveTarget(IStatement modelStmt) {
        if (modelStmt == null || modelStmt.getSegmentSearchArguments() == null) {
            return;
        }
        for (ISegmentSearchArgument ssa : modelStmt.getSegmentSearchArguments()) {
            IDLISegmentRecord rec;
            int index;
            ICommandCodes codes = ssa.getCommandCodes();
            if (codes == null || (index = codes.getCommandCodes().toUpperCase().indexOf("D")) == -1 || ssa.getSegmentName() == null || (rec = this.getDliStmtFactory().getSegment(ssa.getSegmentName().getName())) != null) continue;
            int startOffset = this.getOffset() + codes.getOffset() + index;
            int endOffset = startOffset + 1;
            this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7919, new String[]{ssa.getSegmentName().getName()});
        }
    }

    private void validateSSAForEachTarget(IStatement modelStmt) {
        IDLISegmentRecord[] segments = this.getDliStmtFactory().getSegments();
        if (segments.length > 1) {
            int i = 0;
            while (i < segments.length) {
                IDLISegmentRecord segment = segments[i];
                if (segment != null) {
                    ISegmentSearchArgument ssa = this.getSSA(segment.getSegmentName(), modelStmt);
                    if (ssa == null) {
                        int startOffset = this.getOffset();
                        int endOffset = startOffset + modelStmt.getLength();
                        this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7910, new String[]{segment.getSegmentName()});
                    } else if ("isrt".equalsIgnoreCase(modelStmt.getDLIFunction()) && i == 0 || "gu".equalsIgnoreCase(modelStmt.getDLIFunction()) && i < segments.length - 1 || "ghu".equalsIgnoreCase(modelStmt.getDLIFunction()) && i < segments.length - 1 || "gn".equalsIgnoreCase(modelStmt.getDLIFunction()) && i < segments.length - 1 || "ghn".equalsIgnoreCase(modelStmt.getDLIFunction()) && i < segments.length - 1 || "gnp".equalsIgnoreCase(modelStmt.getDLIFunction()) && i < segments.length - 1 || "ghnp".equalsIgnoreCase(modelStmt.getDLIFunction()) && i < segments.length - 1) {
                        String codes = "";
                        if (ssa.getCommandCodes() != null) {
                            codes = ssa.getCommandCodes().getCommandCodes();
                        }
                        if (codes.toUpperCase().indexOf("D") == -1) {
                            int startOffset = this.getOffset() + ssa.getOffset();
                            int endOffset = startOffset + ssa.getLength();
                            this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7911, new String[]{ssa.getSegmentName().getName()});
                        }
                    }
                }
                ++i;
            }
        }
    }

    private ISegmentSearchArgument getSSA(String segmentName, IStatement modelStmt) {
        if (segmentName == null || modelStmt.getSegmentSearchArguments() == null) {
            return null;
        }
        for (ISegmentSearchArgument ssa : modelStmt.getSegmentSearchArguments()) {
            if (!segmentName.equalsIgnoreCase(ssa.getSegmentName().getName())) continue;
            return ssa;
        }
        return null;
    }

    private void validateIOTargetsInPCB() {
        if (this.getDliStmtFactory().getPCB() != null && this.getDliStmtFactory().getPCB().getPCB() != null && this.getDliStmtFactory().getPCB().getPCB().getPCBType() != null && this.getDliStmtFactory().getPCB().getPCB().getPCBType().getName() == InternUtil.intern((String)"GSAM")) {
            this.problemRequestor.acceptProblem((Node)((Object)this.dliIOStmt), 7920, 2, new String[]{this.getPcbName()});
            return;
        }
        IHierarchy hierarchy = this.getDliStmtFactory().getHierarchy();
        if (hierarchy == null || hierarchy.getEntries() == null || hierarchy.getEntries().length == 0) {
            return;
        }
        IDLISegmentRecord[] segments = this.getDliStmtFactory().getSegments();
        int level = -1;
        boolean foundError = false;
        int i = 0;
        while (i < segments.length) {
            IDLISegmentRecord segment = segments[i];
            if (segment != null) {
                IHierarchyEntry entry = hierarchy.getEntry(segment.getSegmentName());
                if (entry == null) {
                    String pcbName = this.getPcbName();
                    if (pcbName == null) {
                        pcbName = String.valueOf(this.getDliStmtFactory().getPsb().getName()) + "." + this.getDliStmtFactory().getPCB().getName();
                    }
                    this.problemRequestor.acceptProblem((Node)((Object)this.dliIOStmt), 7908, 2, new String[]{pcbName, segment.getSegmentName()});
                } else {
                    if (this.getDliIOType() == 1) {
                        if (level != -1 && entry.getLevel() != level + 1) {
                            foundError = true;
                        }
                    } else if (level >= entry.getLevel()) {
                        foundError = true;
                    }
                    level = entry.getLevel();
                }
            }
            ++i;
        }
        if (foundError) {
            int msgNum = this.getDliIOType() == 1 ? 7912 : 7909;
            String pcbName = this.getPcbName();
            if (pcbName == null) {
                pcbName = String.valueOf(this.getDliStmtFactory().getPsb().getName()) + "." + this.getDliStmtFactory().getPCB().getName();
            }
            this.problemRequestor.acceptProblem((Node)((Object)this.dliIOStmt), msgNum, 2, new String[]{pcbName});
        }
    }

    private boolean pcbContainsSegment(String name) {
        if (this.getDliStmtFactory().getPCB().getPCB() == null || name == null) {
            return false;
        }
        IPCB pcb = this.getDliStmtFactory().getPCB().getPCB();
        if (pcb.getHierarchy() == null) {
            return false;
        }
        IRelationship[] relations = pcb.getHierarchy();
        int i = 0;
        while (i < relations.length) {
            if (relations[i].getSegmentRecord() != null && name.equalsIgnoreCase(relations[i].getSegmentRecord().getSegmentName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void validateSSAHierarchy(IStatement modelStmt) {
        if (modelStmt != null && this.getDliStmtFactory().getSegments().length > 0) {
            IDLISegmentRecord[] segments = this.getDliStmtFactory().getSegments();
            IDLISegmentRecord lastSegment = segments[segments.length - 1];
            if (lastSegment == null) {
                return;
            }
            IHierarchy hierarchy = this.getDliStmtFactory().getHierarchy(lastSegment);
            if (hierarchy == null || hierarchy.getEntries() == null || hierarchy.getEntries().length == 0) {
                return;
            }
            this.validateSSAsMatchHierarchy(hierarchy, modelStmt);
        }
    }

    private void validateSSAsMatchHierarchy(IHierarchy hierarchy, IStatement modelStmt) {
        int level = -1;
        Iterator i = modelStmt.getSegmentSearchArguments().iterator();
        ArrayList<IHierarchyEntry> segmentsNotFound = new ArrayList<IHierarchyEntry>();
        int j = 0;
        while (j < hierarchy.getEntries().length) {
            segmentsNotFound.add(hierarchy.getEntries()[j]);
            ++j;
        }
        boolean hierarchyError = false;
        boolean foundCCmdCode = false;
        while (i.hasNext()) {
            ISegmentSearchArgument ssa = (ISegmentSearchArgument)i.next();
            String segmentName = ssa.getSegmentName().getName();
            ICommandCodes codes = ssa.getCommandCodes();
            foundCCmdCode = codes != null && codes.getCommandCodes() != null && codes.getCommandCodes().toUpperCase().indexOf("C") != -1;
            IHierarchyEntry entry = hierarchy.getEntry(segmentName);
            if (entry == null) {
                if (!this.pcbContainsSegment(segmentName)) continue;
                hierarchyError = true;
                continue;
            }
            segmentsNotFound.remove(entry);
            if (entry.getLevel() <= level) {
                hierarchyError = true;
            }
            level = entry.getLevel();
        }
        if (hierarchyError) {
            int startOffset = this.getOffset();
            int endOffset = startOffset + modelStmt.getLength();
            String pcbName = this.getPcbName();
            if (pcbName == null) {
                pcbName = String.valueOf(this.getDliStmtFactory().getPsb().getName()) + "." + this.getDliStmtFactory().getPCB().getName();
            }
            this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7906, new String[]{pcbName});
        }
        if (!foundCCmdCode && ("gu".equalsIgnoreCase(modelStmt.getDLIFunction()) || "ghu".equalsIgnoreCase(modelStmt.getDLIFunction()))) {
            for (IHierarchyEntry entry : segmentsNotFound) {
                int startOffset = this.getOffset();
                int endOffset = startOffset + modelStmt.getLength();
                String pcbName = this.getPcbName();
                if (pcbName == null) {
                    pcbName = String.valueOf(this.getDliStmtFactory().getPsb().getName()) + "." + this.getDliStmtFactory().getPCB().getName();
                }
                this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7914, new String[]{pcbName, entry.getSegmentName()});
            }
        }
    }

    private void validateSSAsInPCB(IStatement modelStmt) {
        if (this.getDliStmtFactory().getPCB() == null || this.getDliStmtFactory().getPCB().getPCB() == null || this.getDliStmtFactory().getPCB().getPCB().getHierarchy() == null || this.getDliStmtFactory().getPCB().getPCB().getHierarchy().length == 0) {
            return;
        }
        if (this.getDliStmtFactory().getPCB().getPCB().getPCBType() != null && this.getDliStmtFactory().getPCB().getPCB().getPCBType().getName() == InternUtil.intern((String)"GSAM")) {
            return;
        }
        for (ISegmentSearchArgument ssa : modelStmt.getSegmentSearchArguments()) {
            String segmentName = ssa.getSegmentName().getName();
            if (this.pcbContainsSegment(segmentName)) continue;
            int startOffset = this.getOffset() + ssa.getSegmentName().getOffset();
            int endOffset = startOffset + ssa.getSegmentName().getLength();
            String pcbName = this.getPcbName();
            if (pcbName == null) {
                pcbName = String.valueOf(this.getDliStmtFactory().getPsb().getName()) + "." + this.getDliStmtFactory().getPCB().getName();
            }
            this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7915, new String[]{segmentName, pcbName});
        }
    }

    private void validateLastSSA(IStatement modelStmt) {
        ISegmentSearchArgument ssa;
        IDLISegmentRecord[] segments;
        String segNameMustBe;
        if (this.getDliStmtFactory().getPCB() != null && this.getDliStmtFactory().getPCB().getPCB() != null && this.getDliStmtFactory().getPCB().getPCB().getPCBType() != null && this.getDliStmtFactory().getPCB().getPCB().getPCBType().getName() == InternUtil.intern((String)"GSAM")) {
            return;
        }
        if (modelStmt != null && this.getDliStmtFactory().getSegments().length > 0 && modelStmt.getSegmentSearchArguments() != null && modelStmt.getSegmentSearchArguments().size() > 0 && this.getDliStmtFactory().getSegments().length > 0 && !(segNameMustBe = (segments = this.getDliStmtFactory().getSegments())[segments.length - 1].getSegmentName()).equalsIgnoreCase((ssa = (ISegmentSearchArgument)modelStmt.getSegmentSearchArguments().get(modelStmt.getSegmentSearchArguments().size() - 1)).getSegmentName().getName())) {
            int startOffset = this.getOffset() + ssa.getSegmentName().getOffset();
            int endOffset = startOffset + ssa.getSegmentName().getLength();
            this.problemRequestor.acceptProblem(startOffset, endOffset, 2, 7905, new String[]{segNameMustBe});
        }
    }

    private void checkForPCB() {
        if (this.getPcbName() == null && this.getDliStmtFactory().getPCB() == null && this.getDliStmtFactory().getSegments().length > 0 && this.getDliStmtFactory().getPsb() != null) {
            IDLISegmentRecord[] segments = this.getDliStmtFactory().getSegments();
            if (segments.length == 1) {
                String segName = segments[0].getSegmentName();
                this.problemRequestor.acceptProblem((Node)((Object)this.dliIOStmt), 7904, 2, new String[]{this.getDliStmtFactory().getPsb().getName(), segName});
            } else {
                String segNames = segments[0].getSegmentName();
                int i = 1;
                while (i < segments.length) {
                    segNames = String.valueOf(segNames) + ", ";
                    segNames = String.valueOf(segNames) + segments[i].getSegmentName();
                    ++i;
                }
                this.problemRequestor.acceptProblem((Node)((Object)this.dliIOStmt), 7918, 2, new String[]{this.getDliStmtFactory().getPsb().getName(), segNames});
            }
        }
    }

    private void validateCommandCodesWithTargetArray(IStatement statement) {
        if (!this.isTargetAnArray() || statement == null) {
            return;
        }
        String dliFunction = statement.getDLIFunction().toUpperCase();
        for (ISegmentSearchArgument ssa : statement.getSegmentSearchArguments()) {
            int start;
            int index;
            if (ssa.getCommandCodes() == null) continue;
            String codes = ssa.getCommandCodes().getCommandCodes().toUpperCase();
            if ("ISRT".equalsIgnoreCase(dliFunction) && (index = codes.indexOf("D")) != -1) {
                start = this.getOffset() + ssa.getCommandCodes().getOffset() + index;
                this.problemRequestor.acceptProblem(start, start + 1, 2, 7893, new String[]{"D", dliFunction});
            }
            if ("GU".equalsIgnoreCase(dliFunction)) {
                index = codes.indexOf("L");
                if (index != -1) {
                    start = this.getOffset() + ssa.getCommandCodes().getOffset() + index;
                    this.problemRequestor.acceptProblem(start, start + 1, 2, 7893, new String[]{"L", dliFunction});
                }
                if ((index = codes.indexOf("D")) != -1) {
                    start = this.getOffset() + ssa.getCommandCodes().getOffset() + index;
                    this.problemRequestor.acceptProblem(start, start + 1, 2, 7893, new String[]{"D", dliFunction});
                }
            }
            if (!"GN".equalsIgnoreCase(dliFunction) && !"GNP".equalsIgnoreCase(dliFunction)) continue;
            index = codes.indexOf("F");
            if (index != -1) {
                start = this.getOffset() + ssa.getCommandCodes().getOffset() + index;
                this.problemRequestor.acceptProblem(start, start + 1, 2, 7893, new String[]{"F", dliFunction});
            }
            if ((index = codes.indexOf("L")) != -1) {
                start = this.getOffset() + ssa.getCommandCodes().getOffset() + index;
                this.problemRequestor.acceptProblem(start, start + 1, 2, 7893, new String[]{"L", dliFunction});
            }
            if ((index = codes.indexOf("D")) == -1) continue;
            start = this.getOffset() + ssa.getCommandCodes().getOffset() + index;
            this.problemRequestor.acceptProblem(start, start + 1, 2, 7893, new String[]{"D", dliFunction});
        }
    }

    private void addMessage(int msgNumber, String[] inserts, int off1, int off2) {
        if (this.isInlineDLIStatement()) {
            this.problemRequestor.acceptProblem(off1, off2, 2, msgNumber, inserts);
        } else {
            this.problemRequestor.acceptProblem((Node)((Object)this.dliIOStmt), msgNumber, 2, inserts);
        }
    }

    private void validateFunctionCodes(IStatement statement) {
        boolean isValid = false;
        String ioType = "";
        String functionType = "";
        String function = statement.getDLIFunction();
        switch (this.getDliIOType()) {
            case 1: {
                ioType = "add";
                functionType = "isrt".toUpperCase();
                break;
            }
            case 2: {
                ioType = "get by key";
                if (this.isForUpdate()) {
                    functionType = "ghu".toUpperCase();
                    break;
                }
                functionType = "gu".toUpperCase();
                break;
            }
            case 3: {
                ioType = "get by position";
                if (this.isForUpdate() && this.isGetInParent()) {
                    functionType = "ghnp".toUpperCase();
                    break;
                }
                if (this.isForUpdate()) {
                    functionType = "ghn".toUpperCase();
                    break;
                }
                if (this.isGetInParent()) {
                    functionType = "gnp".toUpperCase();
                    break;
                }
                functionType = "gn".toUpperCase();
                break;
            }
            case 4: {
                ioType = "replace";
                functionType = "repl".toUpperCase();
                break;
            }
            case 5: {
                ioType = "delete";
                functionType = "dlet".toUpperCase();
            }
        }
        boolean bl = isValid = function.equalsIgnoreCase(functionType);
        if (!isValid && !this.isGetInParent()) {
            this.problemRequestor.acceptProblem(this.getOffset(), this.getOffset() + function.length(), 2, this.isForUpdate() ? 7880 : 7879, new String[]{ioType, functionType, function});
        } else if (!isValid) {
            this.problemRequestor.acceptProblem(this.getOffset(), this.getOffset() + function.length(), 2, this.isForUpdate() ? 7882 : 7881, new String[]{function});
        }
    }

    private void validateFunctionCodesNeedingContext(IStatement statement, int numDliStmts, boolean hasNext) {
        if (this.getDliIOType() == 2 && !this.isForUpdate()) {
            if (numDliStmts == 1 && this.isTargetAnArray() && !hasNext) {
                this.problemRequestor.acceptProblem(this.getOffset(), this.getOffset() + statement.getLength(), 2, 7887);
            } else {
                if (numDliStmts != 2) {
                    return;
                }
                if (this.hasValidTarget() && !this.isTargetAnArray()) {
                    this.problemRequestor.acceptProblem(this.getOffset() + statement.getOffset(), this.getOffset() + statement.getOffset() + statement.getLength(), 2, 7885);
                }
            }
        }
    }

    private void validateSSAs(List ssaList) {
        for (ISegmentSearchArgument modelSSA : ssaList) {
            if (!MustBeDLINameAnnotationValidator.isValidDLIName(modelSSA.getSegmentName().getName())) {
                this.addMessage(7877, new String[]{modelSSA.getSegmentName().getName()}, this.getOffset() + modelSSA.getSegmentName().getOffset(), this.getOffset() + modelSSA.getSegmentName().getOffset() + modelSSA.getSegmentName().getLength());
            }
            this.validateSSAConditions(modelSSA.getSSAConditions());
        }
    }

    private void validateSSAConditions(ISSAConditions conditions) {
        if (conditions != null && conditions.isBooleanExpressionSSAConditions()) {
            IBooleanExpression boolExpr = ((IBooleanExpressionSSAConditions)conditions).getBooleanExpression();
            this.validateBooleanExpression(boolExpr);
        }
    }

    private void validateBooleanExpression(IBooleanExpression boolExpr) {
        if (boolExpr != null && boolExpr.isCondition()) {
            ICondition modelCond = (ICondition)boolExpr;
            if (!MustBeDLINameAnnotationValidator.isValidDLIName(modelCond.getFieldName().getName())) {
                this.addMessage(7878, new String[]{modelCond.getFieldName().getName()}, this.getOffset() + modelCond.getFieldName().getOffset(), this.getOffset() + modelCond.getFieldName().getOffset() + modelCond.getFieldName().getLength());
            }
            return;
        }
        if (boolExpr != null && boolExpr.isBooleanOperatorExpression()) {
            this.validateBooleanExpression(((IBooleanOperatorExpression)boolExpr).getLeftOperand());
            this.validateBooleanExpression(((IBooleanOperatorExpression)boolExpr).getRightOperand());
        }
    }

    private void initialize(UsingPCBClause pcbClause) {
        if (!this.dliIOStmt.getDliInfo().isDefaultStatement()) {
            this.setInlineDLIStatement(true);
            this.setOffset(this.dliIOStmt.getDliInfo().getInlineValueStart());
        }
        this.setDliStmtFactory(this.dliIOStmt.getDliInfo().getStatementFactory());
        if (pcbClause != null) {
            Expression expr = pcbClause.getPCB();
            this.setPcbName(expr.getCanonicalString());
        }
        if (this.dliIOStmt.getDliInfo().getTypeBindings() != null && this.dliIOStmt.getDliInfo().getTypeBindings().length > 0) {
            this.setHasValidTarget(true);
            if (this.dliIOStmt.getDliInfo().getTypeBindings()[0].getKind() == 2) {
                this.setTargetIsArray(true);
            }
        }
    }

    private int getDliIOType() {
        return this.dliIOType;
    }

    private int getOffset() {
        return this.offset;
    }

    private void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public boolean isGetInParent() {
        return this.getInParent;
    }

    public void setGetInParent(boolean getInParent) {
        this.getInParent = getInParent;
    }

    public boolean isInlineDLIStatement() {
        return this.inlineDLIStatement;
    }

    public void setInlineDLIStatement(boolean inlineDLIStatement) {
        this.inlineDLIStatement = inlineDLIStatement;
    }

    public String getPcbName() {
        return this.pcbName;
    }

    public void setPcbName(String pcbName) {
        this.pcbName = pcbName;
    }

    public DLIDefaultStatementFactory getDliStmtFactory() {
        return this.dliStmtFactory;
    }

    public void setDliStmtFactory(DLIDefaultStatementFactory dliStmtFactory) {
        this.dliStmtFactory = dliStmtFactory;
    }

    public boolean hasValidTarget() {
        return this.hasValidTarget;
    }

    public void setHasValidTarget(boolean hasValidTarget) {
        this.hasValidTarget = hasValidTarget;
    }

    public boolean isTargetAnArray() {
        return this.targetIsArray;
    }

    public void setTargetIsArray(boolean targetIsArray) {
        this.targetIsArray = targetIsArray;
    }

    private class CommandCode {
        String code;
        String modifier;
        int offset;

        public CommandCode(String code, int offset) {
            this.code = code;
            this.offset = offset;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getModifier() {
            if (this.modifier == null) {
                this.modifier = "";
            }
            return this.modifier;
        }

        public void appendModifier(String aString) {
            this.modifier = String.valueOf(this.getModifier()) + aString;
        }

        public int getModifierAsInt() {
            if (this.getModifier().length() == 0) {
                return -1;
            }
            return Integer.parseInt(this.getModifier());
        }

        public int getLength() {
            return 1 + this.getModifier().length();
        }

        public void setModifier(String modifier) {
            this.modifier = modifier;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }
    }
}

