/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;

public class FieldValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public FieldValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        this.validateNoEmptySettingsBlockForServiceOrInterface(classDataDeclaration.getType(), classDataDeclaration.getSettingsBlockOpt());
        return false;
    }

    @Override
    public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
        this.validateNoEmptySettingsBlockForServiceOrInterface(functionDataDeclaration.getType(), functionDataDeclaration.getSettingsBlockOpt());
        return false;
    }

    @Override
    public boolean visit(StructureItem structureItem) {
        if (structureItem.hasType()) {
            this.validateNoEmptySettingsBlockForServiceOrInterface(structureItem.getType(), structureItem.getSettingsBlock());
        }
        return false;
    }

    private boolean isServiceOrInterfaceType(Type type) {
        ITypeBinding typeBinding = type.resolveTypeBinding();
        if (Binding.isValidBinding(typeBinding) && Binding.isValidBinding(typeBinding.getBaseType())) {
            return typeBinding.getBaseType().getKind() == 14 || typeBinding.getBaseType().getKind() == 15;
        }
        return false;
    }

    private void validateNoEmptySettingsBlockForServiceOrInterface(Type type, SettingsBlock block) {
        if (block == null || !this.isServiceOrInterfaceType(type)) {
            return;
        }
        if (block.getSettings().size() == 0) {
            this.problemRequestor.acceptProblem((Node)type, 7519, new String[]{type.resolveTypeBinding().getName()});
        }
    }
}

