/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class ForEachStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;

    public ForEachStatementValidator(IProblemRequestor problemRequestor) {
        this.problemRequestor = problemRequestor;
    }

    private void checkTargetIsSQLRecord(Expression expr) {
        ITypeBinding tBinding = expr.resolveTypeBinding();
        if (tBinding != null && tBinding.getAnnotation(EGLIOSQL, "SQLRecord") == null) {
            this.problemRequestor.acceptProblem((Node)expr, 6632, new String[]{expr.getCanonicalString()});
        }
    }

    @Override
    public boolean visit(ForEachStatement forEachStatement) {
        if (forEachStatement.hasSQLRecord()) {
            this.checkTargetIsSQLRecord(forEachStatement.getSQLRecord());
        }
        forEachStatement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(IntoClause intoClause) {
                intoClause.accept(new AbstractASTExpressionVisitor(){

                    @Override
                    public boolean visitExpression(Expression expression) {
                        StatementValidator.validateItemInIntoClause(expression, ForEachStatementValidator.this.problemRequestor);
                        return false;
                    }
                });
                return false;
            }
        });
        return false;
    }
}

