/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.List;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForUpdateClause;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UsingPCBClause;
import org.eclipse.edt.compiler.core.ast.WithInlineDLIClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.DLIStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class GetByPositionStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public GetByPositionStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(GetByPositionStatement agetByPositionStatement) {
        StatementValidator.validateIOTargetsContainer(agetByPositionStatement.getIOObjects(), this.problemRequestor);
        this.validatePosition(agetByPositionStatement);
        this.validateTarget(agetByPositionStatement);
        this.validateMultipleTargets(agetByPositionStatement);
        agetByPositionStatement.accept(new AbstractASTVisitor(){
            WithInlineDLIClause inlinedli = null;
            UsingPCBClause pcbClause = null;
            ForUpdateClause updateClause = null;

            @Override
            public boolean visit(ForUpdateClause forUpdateClause) {
                this.updateClause = forUpdateClause;
                return false;
            }

            @Override
            public boolean visit(UsingPCBClause usingPCBClause) {
                this.pcbClause = usingPCBClause;
                return false;
            }

            @Override
            public boolean visit(WithInlineDLIClause withInlineDLIClause) {
                if (this.inlinedli != null) {
                    GetByPositionStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineDLIClause, 6546, new String[]{"get".toUpperCase()});
                } else {
                    this.inlinedli = withInlineDLIClause;
                }
                return false;
            }

            @Override
            public void endVisit(GetByPositionStatement getByPositionStatement) {
                if (getByPositionStatement.getDliInfo() != null) {
                    DLIStatementValidator validator = new DLIStatementValidator(getByPositionStatement, GetByPositionStatementValidator.this.problemRequestor, 3);
                    validator.validateGetByPosDLI(this.pcbClause, this.updateClause != null, getByPositionStatement.isGetInParent());
                }
            }
        });
        return true;
    }

    private void validateMultipleTargets(GetByPositionStatement getByPositionStatement) {
        int count = 0;
        boolean isdli = false;
        if (getByPositionStatement.hasTargetRecords()) {
            List targetList = getByPositionStatement.getTargetRecords();
            for (Expression expr : targetList) {
                ITypeBinding typeBinding = expr.resolveTypeBinding();
                if (!StatementValidator.isValidBinding(typeBinding)) continue;
                if (++count > 1) {
                    if (isdli && typeBinding.getAnnotation(EGLIODLI, "DLISegment") != null) continue;
                    this.problemRequestor.acceptProblem((Node)expr, 7869, new String[]{"get"});
                    continue;
                }
                boolean bl = isdli = typeBinding.getAnnotation(EGLIODLI, "DLISegment") != null;
            }
        }
    }

    protected String getDirectiveString(GetByPositionStatement getByPositionStatement) {
        String retVal = "";
        if (getByPositionStatement.isAbsoluteDirection()) {
            retVal = "absolute";
        } else if (getByPositionStatement.isCurrentDirection()) {
            retVal = "current";
        } else if (getByPositionStatement.isFirstDirection()) {
            retVal = "first";
        } else if (getByPositionStatement.isLastDirection()) {
            retVal = "last";
        } else if (getByPositionStatement.isNextDirection()) {
            retVal = "next";
        } else if (getByPositionStatement.isPreviousDirection()) {
            retVal = "previous";
        } else if (getByPositionStatement.isRelativeDirection()) {
            retVal = "relative";
        }
        if (getByPositionStatement.hasPosition()) {
            retVal = String.valueOf(retVal) + " (" + getByPositionStatement.getPosition().getCanonicalString() + ")";
        }
        return retVal;
    }

    protected void addINVALID_CLAUSE_FOR_NON_SQL_TARGETError(Node node, String clause) {
    }

    protected void validateRecordOptions(final GetByPositionStatement getByPositionStatement, final ITypeBinding typeBinding) {
        getByPositionStatement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(IntoClause intoClause) {
                if (typeBinding != null && typeBinding.getAnnotation(EGLIOSQL, "SQLRecord") == null) {
                    GetByPositionStatementValidator.this.addINVALID_CLAUSE_FOR_NON_SQL_TARGETError(intoClause, "into");
                }
                intoClause.accept(new AbstractASTExpressionVisitor(){

                    @Override
                    public boolean visitExpression(Expression expression) {
                        StatementValidator.validateItemInIntoClause(expression, GetByPositionStatementValidator.this.problemRequestor);
                        return false;
                    }
                });
                return false;
            }

            @Override
            public boolean visit(ForUpdateClause forUpdateClause) {
                if (getByPositionStatement.hasTargetRecords()) {
                    for (Expression expr : getByPositionStatement.getTargetRecords()) {
                        ITypeBinding arytypeBinding = expr.resolveTypeBinding();
                        if (!StatementValidator.isValidBinding(arytypeBinding) || arytypeBinding.getKind() != 2 || arytypeBinding.getBaseType() != typeBinding) continue;
                        GetByPositionStatementValidator.this.problemRequestor.acceptProblem(expr, 7872);
                    }
                }
                return false;
            }
        });
    }

    protected void validateDirectiveForType(GetByPositionStatement agetByPositionStatement, ITypeBinding typeBinding) {
        if (typeBinding.getAnnotation(EGLIODLI, "DLISegment") != null && !agetByPositionStatement.isNextDirection()) {
            this.problemRequestor.acceptProblem(agetByPositionStatement, 7873);
        }
        if (!(typeBinding.getAnnotation(EGLIOFILE, "RelativeRecord") == null && typeBinding.getAnnotation(EGLIOFILE, "SerialRecord") == null && typeBinding.getAnnotation(EGLIOMQ, "MQRecord") == null || agetByPositionStatement.isNextDirection())) {
            this.problemRequestor.acceptProblem((Node)agetByPositionStatement, 6642, new String[]{this.getDirectiveString(agetByPositionStatement)});
        }
        if (typeBinding.getAnnotation(EGLIOFILE, "IndexedRecord") != null && !agetByPositionStatement.isNextDirection() && !agetByPositionStatement.isPreviousDirection()) {
            this.problemRequestor.acceptProblem((Node)agetByPositionStatement, 6643, new String[]{this.getDirectiveString(agetByPositionStatement)});
        }
        if (typeBinding.getAnnotation(EGLIOFILE, "CSVRecord") != null && !agetByPositionStatement.isNextDirection()) {
            this.problemRequestor.acceptProblem((Node)agetByPositionStatement, 6642, new String[]{this.getDirectiveString(agetByPositionStatement)});
        }
        if (typeBinding.getAnnotation(EGLIODLI, "DLISegment") == null) {
            if (agetByPositionStatement.isGetInParent()) {
                this.problemRequestor.acceptProblem((Node)agetByPositionStatement, 7870, new String[]{"inparent"});
            }
            agetByPositionStatement.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(GetByPositionStatement getByPositionStatement) {
                    return true;
                }

                @Override
                public boolean visit(ForUpdateClause forUpdateClause) {
                    GetByPositionStatementValidator.this.problemRequestor.acceptProblem((Node)forUpdateClause, 7948, new String[]{"forUpdate"});
                    return false;
                }
            });
        }
        this.validateRecordOptions(agetByPositionStatement, typeBinding);
    }

    protected void validateTarget(GetByPositionStatement getByPositionStatement) {
        if (getByPositionStatement.hasTargetRecords()) {
            for (Expression expr : getByPositionStatement.getTargetRecords()) {
                ITypeBinding typeBinding = expr.resolveTypeBinding();
                if (!StatementValidator.isValidBinding(typeBinding)) continue;
                if (typeBinding.getKind() == 2) {
                    ITypeBinding baseBinding = typeBinding.getBaseType();
                    if (!StatementValidator.isValidBinding(baseBinding)) continue;
                    this.validateDirectiveForType(getByPositionStatement, baseBinding);
                    if (baseBinding.getAnnotation(EGLIODLI, "DLISegment") != null) continue;
                    this.problemRequestor.acceptProblem((Node)expr, 6644, new String[]{expr.getCanonicalString()});
                    continue;
                }
                if (typeBinding.getKind() == 7 || typeBinding.getKind() == 6) {
                    this.validateDirectiveForType(getByPositionStatement, typeBinding);
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)expr, 6644, new String[]{expr.getCanonicalString()});
            }
        } else {
            this.validateRecordOptions(getByPositionStatement, null);
        }
    }

    protected void validatePosition(GetByPositionStatement getByPositionStatement) {
        Expression expr;
        ITypeBinding typeBinding;
        if (getByPositionStatement.hasPosition() && !StatementValidator.isIntegerCompatible(typeBinding = (expr = getByPositionStatement.getPosition()).resolveTypeBinding())) {
            this.problemRequestor.acceptProblem(expr, 4025);
        }
    }
}

