/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.NoCursorClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.UsingPCBClause;
import org.eclipse.edt.compiler.core.ast.WithInlineDLIClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.DLIStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.SQLStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class ReplaceStatementValidator
extends IOStatementValidator {
    public ReplaceStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(problemRequestor, compilerOptions);
    }

    @Override
    public boolean visit(final ReplaceStatement areplaceStatement) {
        Expression expr = areplaceStatement.getRecord();
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        if (StatementValidator.isValidBinding(typeBinding)) {
            this.isSQLTarget = typeBinding.getAnnotation(EGLIOSQL, "SQLRecord") != null;
        }
        StatementValidator.validateIOTargetsContainer(areplaceStatement.getIOObjects(), this.problemRequestor);
        final Node[] nocursorNode = new Node[1];
        final Node[] inlineSqlNode = new Node[1];
        areplaceStatement.accept(new AbstractASTVisitor(){
            Node inlinesql = null;
            Node inlinedli = null;
            Node from = null;
            UsingPCBClause pcbClause = null;

            @Override
            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                inlineSqlNode[0] = withInlineSQLClause;
                if (this.inlinesql != null) {
                    ReplaceStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6512, new String[]{"replace".toUpperCase()});
                } else {
                    this.inlinesql = withInlineSQLClause;
                    if (StatementValidator.isClauseEmpty(withInlineSQLClause.getSqlStmt().getValue())) {
                        ReplaceStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6500, new String[]{"replace".toUpperCase()});
                    } else {
                        SQLStatementValidator.checkReplaceClauses(withInlineSQLClause, areplaceStatement.getSqlInfo().getParser(), ReplaceStatementValidator.this.problemRequestor);
                    }
                }
                return false;
            }

            @Override
            public boolean visit(WithInlineDLIClause withInlineDLIClause) {
                if (this.inlinedli != null) {
                    ReplaceStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineDLIClause, 6546, new String[]{"replace".toUpperCase()});
                } else {
                    this.inlinedli = withInlineDLIClause;
                }
                return false;
            }

            @Override
            public boolean visit(UsingPCBClause usingPCBClause) {
                this.pcbClause = usingPCBClause;
                return false;
            }

            @Override
            public boolean visit(NoCursorClause noCursorClause) {
                nocursorNode[0] = noCursorClause;
                ReplaceStatementValidator.this.checkIsSQLTarget("noCursor", noCursorClause);
                ReplaceStatementValidator.this.checkMutuallyExclusiveClauses(NO_CURSOR_USINGKEYS, "noCursor", noCursorClause);
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause usingKeysClause) {
                ReplaceStatementValidator.this.checkIsSQLTarget("usingKeys", usingKeysClause);
                ReplaceStatementValidator.this.checkMutuallyExclusiveClauses(NO_CURSOR_USINGKEYS, "usingKeys", usingKeysClause);
                return false;
            }

            @Override
            public void endVisit(ReplaceStatement replaceStatement) {
                Expression expr = replaceStatement.getRecord();
                ITypeBinding typeBinding = expr.resolveTypeBinding();
                if (StatementValidator.isValidBinding(typeBinding)) {
                    if (!ReplaceStatementValidator.this.isSQLTarget && typeBinding.getAnnotation(EGLIOFILE, "RelativeRecord") == null && typeBinding.getAnnotation(EGLIOFILE, "IndexedRecord") == null) {
                        typeBinding.getAnnotation(EGLIODLI, "DLISegment");
                    }
                    if (typeBinding.getAnnotation(EGLIOFILE, "RelativeRecord") == null && typeBinding.getAnnotation(EGLIOFILE, "IndexedRecord") == null) {
                        typeBinding.getAnnotation(EGLIODLI, "DLISegment");
                    }
                }
                if (replaceStatement.getDliInfo() != null) {
                    DLIStatementValidator validator = new DLIStatementValidator(replaceStatement, ReplaceStatementValidator.this.problemRequestor, 4);
                    validator.validateDLI(this.pcbClause);
                }
            }
        });
        if (this.isSQLTarget && typeBinding.getAnnotation(((IPartBinding)typeBinding).getSubType()).findData("keyItems") == IBinding.NOT_FOUND_BINDING && nocursorNode[0] != null && inlineSqlNode[0] == null) {
            this.problemRequestor.acceptProblem(nocursorNode[0], 6690, new String[]{typeBinding.getCaseSensitiveName()});
        }
        return false;
    }
}

