/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.ProgramBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.TransferStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class TransferStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IPartBinding enclosingPart;

    public TransferStatementValidator(IProblemRequestor problemRequestor, IPartBinding enclosingPart, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.enclosingPart = enclosingPart;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(TransferStatement transferStatement) {
        ITypeBinding typeBinding;
        this.problemRequestor.acceptProblem((Node)transferStatement, 3458, new String[]{"TRANSFER"});
        StatementValidator.validateIOTargetsContainer(transferStatement.getIOObjects(), this.problemRequestor);
        this.validateContainer(transferStatement);
        Expression passing = null;
        Expression target = null;
        ProgramBinding targetProgram = null;
        ITypeBinding recordBinding = null;
        if (transferStatement.hasPassingRecord() && StatementValidator.isValidBinding(typeBinding = (passing = transferStatement.getPassingRecord()).resolveTypeBinding())) {
            if (typeBinding.getKind() != 7 && typeBinding.getKind() != 6) {
                this.problemRequestor.acceptProblem((Node)passing, 6541, new String[]{passing.getCanonicalString()});
            } else {
                recordBinding = typeBinding;
                if (typeBinding.getAnnotation(EGLIODLI, "PSBRecord") != null) {
                    this.problemRequestor.acceptProblem((Node)passing, 7933, new String[]{passing.getCanonicalString()});
                }
            }
        }
        target = transferStatement.getInvocationTarget();
        targetProgram = this.getProgram(target);
        if (transferStatement.isToTransaction() && targetProgram != null && this.isValidTarget(targetProgram) && (targetProgram.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") != null || targetProgram.getAnnotation(EGLUIGATEWAY, "UIProgram") != null)) {
            this.problemRequestor.acceptProblem(target, 7775);
        }
        if (targetProgram != null && recordBinding != null && this.isValidTarget(targetProgram)) {
            IDataBinding classFieldBinding;
            ITypeBinding type;
            if (recordBinding.getAnnotation(EGLUIWEBTRANSACTION, "VGUIRecord") == null) {
                boolean error = false;
                type = null;
                IDataBinding inputRecordDBinding = targetProgram.getAnnotation(targetProgram.getSubType()).findData(InternUtil.intern((String)"inputRecord"));
                if (IBinding.NOT_FOUND_BINDING != inputRecordDBinding) {
                    classFieldBinding = (IDataBinding)((IAnnotationBinding)inputRecordDBinding).getValue();
                    if (StatementValidator.isValidBinding(classFieldBinding) && StatementValidator.isValidBinding(classFieldBinding.getType()) && !TypeCompatibilityUtil.isMoveCompatible(classFieldBinding.getType(), recordBinding, null, this.compilerOptions)) {
                        error = true;
                        type = classFieldBinding.getType();
                    }
                } else {
                    error = true;
                }
                if (error) {
                    this.problemRequestor.acceptProblem((Node)passing, 6711, new String[]{targetProgram.getName(), type != null ? StatementValidator.getQualifiedName(type) : "", StatementValidator.getQualifiedName(recordBinding)});
                }
            }
            if (recordBinding.getAnnotation(EGLUIWEBTRANSACTION, "VGUIRecord") != null) {
                boolean error = false;
                type = null;
                if (targetProgram.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") != null) {
                    IDataBinding inputUIRecordDBinding = targetProgram.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction").findData(InternUtil.intern((String)"inputUIRecord"));
                    if (IBinding.NOT_FOUND_BINDING != inputUIRecordDBinding) {
                        classFieldBinding = (IDataBinding)((IAnnotationBinding)inputUIRecordDBinding).getValue();
                        if (StatementValidator.isValidBinding(classFieldBinding)) {
                            if (StatementValidator.isValidBinding(classFieldBinding.getType()) && classFieldBinding.getType() != recordBinding) {
                                error = true;
                                type = classFieldBinding.getType();
                            }
                        } else {
                            error = true;
                        }
                    } else {
                        error = true;
                    }
                    if (error) {
                        this.problemRequestor.acceptProblem((Node)passing, 6723, new String[]{targetProgram.getName(), type != null ? StatementValidator.getQualifiedName(type) : "", StatementValidator.getQualifiedName(recordBinding)});
                    }
                }
            }
        }
        return false;
    }

    private ProgramBinding getProgram(Expression expr) {
        ProgramBinding program = null;
        ITypeBinding tBinding = expr.resolveTypeBinding();
        if (tBinding != null && tBinding != IBinding.NOT_FOUND_BINDING && tBinding.getKind() == 13) {
            program = (ProgramBinding)tBinding;
        }
        return program;
    }

    private void validateContainer(TransferStatement transferStatement) {
        if (!Binding.isValidBinding(this.enclosingPart)) {
            return;
        }
        if (this.enclosingPart.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") != null || this.enclosingPart.getAnnotation(EGLUIGATEWAY, "UIProgram") != null) {
            ProgramBinding targetProgram = this.getProgram(transferStatement.getInvocationTarget());
            if (StatementValidator.isValidBinding(targetProgram) && transferStatement.isToProgram() && !this.isValidTarget(targetProgram)) {
                this.problemRequestor.acceptProblem(transferStatement.getInvocationTarget(), 7776);
            }
            if (transferStatement.isToTransaction()) {
                this.problemRequestor.acceptProblem(transferStatement, 7506);
            }
        }
        if ((this.enclosingPart.getAnnotation(EGLUITEXT, "TextUIProgram") != null || this.enclosingPart.getAnnotation(EGLCORE, "BasicProgram") != null) && ((ProgramBinding)this.enclosingPart).getParameters().size() > 0) {
            this.problemRequestor.acceptProblem((Node)transferStatement, 6556, new String[]{"transfer"});
        }
    }

    private boolean isValidTarget(ProgramBinding targetProgram) {
        if (this.enclosingPart != null) {
            if (this.enclosingPart.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") != null) {
                if (targetProgram.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") == null) {
                    return targetProgram.getAnnotation(EGLCORE, "BasicProgram") != null && targetProgram.getParameters().size() == 0;
                }
                return true;
            }
            if (this.enclosingPart.getAnnotation(EGLUIGATEWAY, "UIProgram") != null) {
                if (targetProgram.getAnnotation(EGLUIGATEWAY, "UIProgram") == null) {
                    return targetProgram.getAnnotation(EGLCORE, "BasicProgram") != null && targetProgram.getParameters().size() == 0;
                }
                return true;
            }
        }
        if (targetProgram.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") == null && targetProgram.getAnnotation(EGLUIGATEWAY, "UIProgram") == null) {
            return targetProgram.getAnnotation(EGLCORE, "BasicProgram") != null && targetProgram.getParameters().size() == 0;
        }
        return true;
    }
}

