/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.DelegateBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.TopLevelFunctionBinding;
import org.eclipse.edt.compiler.binding.VariableBinding;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Parameter;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2MofBase;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EMember;
import org.eclipse.edt.mof.EMemberContainer;
import org.eclipse.edt.mof.EMetadataObject;
import org.eclipse.edt.mof.EMetadataType;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Form;
import org.eclipse.edt.mof.egl.FormField;
import org.eclipse.edt.mof.egl.FormGroup;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.FunctionPart;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.Stereotype;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.StructuredRecord;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ProxyEClass;

abstract class Egl2MofPart
extends Egl2MofBase {
    public MofSerializable currentPart;
    protected FunctionMember currentFunction;
    public List<Node> functionsToProcess = new ArrayList<Node>();

    Egl2MofPart(IEnvironment env) {
        super(env);
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Record node) {
        MofSerializable part = this.defaultHandleVisitPart(node);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(Enumeration node) {
        MofSerializable part = this.defaultHandleVisitPart(node);
        this.setElementInformation(node, (EObject)part);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(ExternalType node) {
        IPartBinding partBinding = (IPartBinding)node.getName().resolveBinding();
        this.inMofProxyContext = this.isMofProxy(partBinding);
        this.inEMetadataTypeContext = this.isEMetadataType(partBinding);
        this.inAnnotationTypeContext = this.isAnnotationType(partBinding) || this.isStereotypeType(partBinding);
        this.inMofContext = this.isMofReflectType(partBinding) || this.inEMetadataTypeContext;
        MofSerializable part = this.handleVisitPart(node);
        this.handleContents(node, (EObject)part);
        if (part instanceof EClass) {
            ArrayList<EClass> superTypes = new ArrayList<EClass>();
            for (Object name : node.getExtendedTypes()) {
                IPartBinding superType = (IPartBinding)((Name)name).resolveBinding();
                if (!Binding.isValidBinding(superType)) continue;
                EClass superTypeClass = (EClass)this.mofTypeFor(superType);
                this.fixSuperTypes(superTypeClass);
                superTypes.add((EClass)this.mofTypeFor(superType));
            }
            ((EClass)part).addSuperTypes(superTypes);
        } else {
            for (Object name : node.getExtendedTypes()) {
                IPartBinding superType = (IPartBinding)((Name)name).resolveBinding();
                if (!Binding.isValidBinding(superType) || superType.getKind() != 28) continue;
                ((EGLClass)part).getSuperTypes().add((EGLClass)this.mofTypeFor(superType));
            }
        }
        this.handleEndVisitPart(node, part);
        this.stack.push(part);
        return false;
    }

    private void fixSuperTypes(EClass eclass) {
        List superTypes = eclass.getSuperTypes();
        int i = 0;
        while (i < superTypes.size()) {
            EObject obj = this.getMofSerializable(((EClass)superTypes.get(i)).getMofSerializationKey());
            if (obj instanceof EClass) {
                if (obj == superTypes.get(i)) {
                    this.fixSuperTypes((EClass)obj);
                } else {
                    superTypes.set(i, (EClass)obj);
                }
            }
            ++i;
        }
    }

    @Override
    public boolean visit(Program node) {
        MofSerializable part = this.defaultHandleVisitPart(node);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(Interface interfaceNode) {
        MofSerializable part = this.handleVisitPart(interfaceNode);
        this.handleContents(interfaceNode, (EObject)part);
        for (Node node : interfaceNode.getExtendedTypes()) {
            EObject obj;
            ITypeBinding tb = (ITypeBinding)((Name)node).resolveBinding();
            if (!Binding.isValidBinding(tb) || tb.getKind() != 15 || !((obj = this.mofTypeFor(tb)) instanceof StructPart)) continue;
            ((EGLClass)part).getSuperTypes().add((StructPart)obj);
        }
        this.handleEndVisitPart(interfaceNode, part);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Handler handler) {
        Handler part = (Handler)this.defaultHandleVisitPart(handler);
        for (Node node : handler.getImplementedInterfaces()) {
            EObject obj;
            ITypeBinding tb = (ITypeBinding)((Name)node).resolveBinding();
            if (!Binding.isValidBinding(tb) || tb.getKind() != 15 || !((obj = this.mofTypeFor(tb)) instanceof StructPart)) continue;
            part.getSuperTypes().add((StructPart)obj);
        }
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(Library node) {
        MofSerializable part = this.defaultHandleVisitPart(node);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(DataItem dataItem) {
        org.eclipse.edt.mof.egl.DataItem part = this.factory.createDataItem();
        part.setName(dataItem.getName().getCaseSensitiveIdentifier());
        DataItemBinding type = (DataItemBinding)dataItem.getName().resolveBinding();
        part.setBaseType((Type)this.mofTypeFor(type.getPrimitiveTypeBinding()));
        part.setPackageName(this.concatWithSeparator(type.getPackageName(), ".").toUpperCase().toLowerCase());
        this.createAnnotations((IPartBinding)type, (Part)part);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(DataTable node) {
        MofSerializable part = this.defaultHandleVisitPart(node);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(Delegate delegate) {
        org.eclipse.edt.mof.egl.Delegate part = this.factory.createDelegate();
        DelegateBinding binding = (DelegateBinding)delegate.getName().resolveBinding();
        part.setName(binding.getCaseSensitiveName());
        part.setPackageName(this.concatWithSeparator(binding.getPackageName(), ".").toUpperCase().toLowerCase());
        if (binding.getReturnType() != null) {
            part.setReturnType((Type)this.mofTypeFor(binding.getReturnType()));
            part.setIsNullable(Boolean.valueOf(binding.getReturnType().isNullable()));
        } else {
            part.setIsNullable(Boolean.valueOf(false));
        }
        this.partProcessingStack.push(part);
        for (Parameter parm : delegate.getParameters()) {
            parm.accept(this);
            part.addMember((Member)((FunctionParameter)this.stack.pop()));
        }
        this.setElementInformation(delegate, (EObject)part);
        this.partProcessingStack.pop();
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.FormGroup formGroup) {
        FormGroup group = this.factory.createFormGroup();
        group.setName(formGroup.getName().getCaseSensitiveIdentifier());
        FormGroupBinding groupBinding = (FormGroupBinding)formGroup.getName().resolveBinding();
        group.setPackageName(this.concatWithSeparator(groupBinding.getPackageName(), ".").toUpperCase().toLowerCase());
        this.stack.push(group);
        for (Node node : formGroup.getContents()) {
            if (!(node instanceof NestedForm)) continue;
            NestedForm form = (NestedForm)node;
            form.accept(this);
            Form eForm = (Form)this.stack.pop();
            eForm.setContainer(group);
            group.getForms().add(eForm);
        }
        this.createAnnotations((IPartBinding)groupBinding, (Part)group);
        this.setElementInformation(formGroup, (EObject)group);
        return false;
    }

    @Override
    public boolean visit(NestedForm nestedForm) {
        Form part = this.factory.createForm();
        part.setName(nestedForm.getName().getCaseSensitiveIdentifier());
        FormBinding binding = (FormBinding)nestedForm.getName().resolveBinding();
        this.stack.push(part);
        for (Node field : nestedForm.getContents()) {
            field.accept(this);
            FormField f = (FormField)this.stack.pop();
            if (f == null) continue;
            part.addMember((Member)f);
        }
        this.createAnnotations((IPartBinding)binding, (Part)part);
        this.setElementInformation(nestedForm, (EObject)part);
        return false;
    }

    @Override
    public boolean visit(TopLevelForm topLevelForm) {
        MofSerializable part = this.defaultHandleVisitPart(topLevelForm);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Service service) {
        Service part = (Service)this.defaultHandleVisitPart(service);
        for (Node node : service.getImplementedInterfaces()) {
            EObject obj;
            ITypeBinding tb = (ITypeBinding)((Name)node).resolveBinding();
            if (!Binding.isValidBinding(tb) || tb.getKind() != 15 || !((obj = this.mofTypeFor(tb)) instanceof StructPart)) continue;
            part.getSuperTypes().add((StructPart)obj);
        }
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(TopLevelFunction node) {
        TopLevelFunctionBinding cfr_ignored_0 = (TopLevelFunctionBinding)node.getName().resolveBinding();
        FunctionPart part = (FunctionPart)this.handleVisitPart(node);
        Function function = this.factory.createFunction();
        this.setElementInformation(node, (EObject)function);
        part.setFunction(function);
        function.setName(part.getName());
        for (Node parm : node.getFunctionParameters()) {
            parm.accept(this);
            function.addMember((Member)((FunctionParameter)this.stack.pop()));
        }
        if (node.getReturnDeclaration() != null) {
            function.setType((Type)this.mofTypeFor(node.getReturnType().resolveTypeBinding()));
        }
        StatementBlock block = this.factory.createStatementBlock();
        block.setContainer((Container)function);
        function.setStatementBlock(block);
        this.setCurrentFunctionMember((FunctionMember)function);
        for (Node stmt : node.getStmts()) {
            stmt.accept(this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        this.setCurrentFunctionMember(null);
        this.setElementInformation(node, (EObject)part);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(UseStatement stmt) {
        for (Name name : stmt.getNames()) {
            ITypeBinding partBinding = (ITypeBinding)name.resolveBinding();
            if (IBinding.NOT_FOUND_BINDING.equals(partBinding)) continue;
            Part part = (Part)this.mofTypeFor(partBinding);
            ((LogicAndDataPart)this.currentPart).getUsedParts().add(part);
            if (!(partBinding instanceof FormBinding)) continue;
            Field formField = this.factory.createField();
            formField.setName(partBinding.getCaseSensitiveName());
            formField.setType((Type)part);
            ((LogicAndDataPart)this.currentPart).addMember((Member)formField);
            this.eObjects.put(partBinding, formField);
        }
        this.stack.push(null);
        return false;
    }

    protected MofSerializable defaultHandleVisitPart(org.eclipse.edt.compiler.core.ast.Part node) {
        node.getName().resolveBinding();
        MofSerializable part = this.handleVisitPart(node);
        this.handleContents(node, (EObject)part);
        this.handleParms(node, (EObject)part);
        this.handleEndVisitPart(node, part);
        return part;
    }

    private void handleParms(org.eclipse.edt.compiler.core.ast.Part part, EObject container) {
        if (part instanceof Program) {
            Program pgmAst = (Program)part;
            org.eclipse.edt.mof.egl.Program program = (org.eclipse.edt.mof.egl.Program)container;
            for (ProgramParameter parmAst : pgmAst.getParameters()) {
                parmAst.accept(this);
                org.eclipse.edt.mof.egl.ProgramParameter parm = (org.eclipse.edt.mof.egl.ProgramParameter)this.stack.pop();
                parm.setContainer((Container)program);
                program.getParameters().add(parm);
            }
            program.setIsCallable(Boolean.valueOf(pgmAst.isCallable()));
        }
    }

    protected MofSerializable handleVisitPart(org.eclipse.edt.compiler.core.ast.Part part) {
        IPartBinding partBinding = (IPartBinding)part.getName().resolveBinding();
        this.inMofProxyContext = this.isMofProxy(partBinding);
        this.inEMetadataTypeContext = this.isEMetadataType(partBinding);
        this.inAnnotationTypeContext = this.isAnnotationType(partBinding) || this.isStereotypeType(partBinding);
        this.inMofContext = this.isMofReflectType(partBinding) || this.inEMetadataTypeContext;
        EClass typeClass = (EClass)this.getMofSerializable(this.mofPartTypeSignatureFor(part));
        MofSerializable eObj = (MofSerializable)typeClass.newInstance();
        this.partProcessingStack.push(eObj);
        eObj.eSet("name", (Object)partBinding.getCaseSensitiveName());
        eObj.eSet("packageName", (Object)this.concatWithSeparator(partBinding.getPackageName(), ".").toUpperCase().toLowerCase());
        IAnnotationBinding subtype = partBinding.getSubTypeAnnotationBinding();
        if (!this.inMofProxyContext) {
            this.setReflectTypeValues((EObject)eObj, subtype);
        }
        this.env.save(this.mofSerializationKeyFor(partBinding), (EObject)eObj, false);
        if (!this.mofSerializationKeyFor(partBinding).equals(eObj.getMofSerializationKey())) {
            this.env.save(eObj.getMofSerializationKey(), (EObject)eObj, false);
        }
        if (!this.inMofContext) {
            this.eObjects.put(partBinding, eObj);
            this.currentPart = eObj;
        }
        return eObj;
    }

    private void createInitializerStatements(org.eclipse.edt.compiler.core.ast.Part astPart, StructPart structPart) {
        final Egl2MofPart converter = this;
        final ArrayList statements = new ArrayList();
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                for (Node node : settingsBlock.getSettings()) {
                    node.accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(org.eclipse.edt.compiler.core.ast.Assignment assignment) {
                if (assignment.resolveBinding() == null && Binding.isValidBinding(assignment.getLeftHandSide().resolveDataBinding())) {
                    assignment.accept(converter);
                    Assignment assign = (Assignment)Egl2MofPart.this.stack.pop();
                    AssignmentStatement stmt = Egl2MofPart.this.factory.createAssignmentStatement();
                    stmt.setExpr((Expression)assign);
                    Egl2MofPart.this.setElementInformation(assignment, (EObject)stmt);
                    statements.add(stmt);
                }
                return false;
            }
        };
        for (Node node : astPart.getContents()) {
            node.accept(visitor);
        }
        if (!statements.isEmpty()) {
            StatementBlock block = this.factory.createStatementBlock();
            structPart.setInitializerStatements(block);
            for (Statement stmt : statements) {
                block.getStatements().add(stmt);
            }
        }
    }

    protected void handleEndVisitPart(org.eclipse.edt.compiler.core.ast.Part astPart, MofSerializable mofPart) {
        MofSerializable part = (MofSerializable)this.partProcessingStack.pop();
        IPartBinding partBinding = (IPartBinding)astPart.getName().resolveBinding();
        IAnnotationBinding subtype = partBinding.getSubTypeAnnotationBinding();
        if (mofPart instanceof EClass) {
            this.createAnnotations(partBinding, (EClass)mofPart);
        } else if (mofPart instanceof Part) {
            this.createAnnotations(partBinding, (Part)mofPart);
            if (mofPart instanceof StructPart) {
                this.setDefaultSuperType((StructPart)mofPart);
            }
            this.setElementInformation(astPart, (EObject)((Part)mofPart));
            if (mofPart instanceof StructPart) {
                this.createInitializerStatements(astPart, (StructPart)mofPart);
            }
        }
        for (Node node : this.functionsToProcess) {
            List stmts;
            ITypeBinding binding;
            if (node instanceof NestedFunction) {
                binding = ((NestedFunction)node).getName().resolveDataBinding().getType();
                stmts = ((NestedFunction)node).getStmts();
            } else {
                binding = ((Constructor)node).getBinding().getType();
                stmts = ((Constructor)node).getStmts();
            }
            FunctionMember irFunc = (FunctionMember)this.getEObjectFor(binding);
            this.setCurrentFunctionMember(irFunc);
            for (Node node2 : stmts) {
                if (!(node2 instanceof org.eclipse.edt.compiler.core.ast.Statement)) continue;
                node2.accept(this);
                Statement irStmt = (Statement)this.stack.pop();
                irFunc.getStatements().add(irStmt);
            }
            this.setCurrentFunctionMember(null);
        }
        if (part instanceof LogicAndDataPart) {
            IRUtils.markOverloadedFunctions((LogicAndDataPart)((LogicAndDataPart)part));
        }
        if (this.inMofProxyContext) {
            EMetadataObject eMetadataObject = (EMetadataObject)this.mofValueFrom(subtype);
            ((EClass)mofPart).getMetadataList().add(eMetadataObject);
        }
        for (Map.Entry entry : this.proxies.entrySet()) {
            EObject real = (EObject)this.eObjects.get(entry.getKey());
            this.updateProxyReferences((IBinding)entry.getKey(), real);
        }
    }

    private void handleImplicits(org.eclipse.edt.compiler.core.ast.Part part, EObject container) {
        NestedFunctionBinding[] implFunctions;
        IDataBinding[] impFields = this.getImplicitFields(part.getName().resolveBinding());
        if (impFields != null) {
            int i = 0;
            while (i < impFields.length) {
                ((Container)container).addMember(this.createImplicitField(impFields[i]));
                ++i;
            }
        }
        if ((implFunctions = this.getImplicitFunctions(part.getName().resolveBinding())) != null) {
            int i = 0;
            while (i < implFunctions.length) {
                ((Container)container).addMember(this.createImplicitFunction(implFunctions[i]));
                ++i;
            }
        }
    }

    private Member createImplicitField(IDataBinding data) {
        EClass fieldClass = this.mofMemberTypeFor(data);
        Field f = (Field)fieldClass.newInstance();
        this.setUpEglTypedElement((TypedElement)f, data);
        if (data instanceof ClassFieldBinding) {
            ClassFieldBinding cfb = (ClassFieldBinding)data;
            f.setIsStatic(Boolean.valueOf(cfb.isStatic()));
            if (cfb.isPrivate()) {
                f.setAccessKind(AccessKind.ACC_PRIVATE);
            }
        }
        for (IAnnotationBinding ann : data.getAnnotations()) {
            Annotation value = (Annotation)this.mofValueFrom(ann);
            f.getAnnotations().add(value);
        }
        this.eObjects.put(data, f);
        return f;
    }

    private Member createImplicitFunction(NestedFunctionBinding function) {
        FunctionBinding functionBinding = (FunctionBinding)function.getType();
        EClass funcClass = this.mofMemberTypeFor(function);
        Function func = (Function)funcClass.newInstance();
        this.setUpEglTypedElement((TypedElement)func, function);
        StatementBlock stmts = this.factory.createStatementBlock();
        stmts.setContainer((Container)func);
        func.setStatementBlock(stmts);
        for (FunctionParameterBinding parmBinding : functionBinding.getParameters()) {
            FunctionParameter parm = this.factory.createFunctionParameter();
            ParameterKind parmKind = parmBinding.isInput() ? ParameterKind.PARM_IN : (parmBinding.isInputOutput() ? ParameterKind.PARM_INOUT : (parmBinding.isOutput() ? ParameterKind.PARM_OUT : ParameterKind.PARM_INOUT));
            parm.setParameterKind(parmKind);
            this.setUpEglTypedElement((TypedElement)parm, parmBinding);
            this.eObjects.put(parmBinding, parm);
            func.addMember((Member)parm);
        }
        if (functionBinding.isPrivate()) {
            func.setAccessKind(AccessKind.ACC_PRIVATE);
        }
        if (functionBinding.isStatic()) {
            func.setIsStatic(Boolean.valueOf(true));
        }
        this.eObjects.put(function.getType(), func);
        return func;
    }

    private IDataBinding[] getImplicitFields(IBinding binding) {
        ArrayList<VariableBinding> list;
        if (binding instanceof FunctionContainerBinding) {
            list = new ArrayList<VariableBinding>();
            FunctionContainerBinding fc = (FunctionContainerBinding)binding;
            for (VariableBinding field : fc.getClassFields()) {
                if (!((ClassFieldBinding)field).isImplicit()) continue;
                list.add(field);
            }
            if (list.size() > 0) {
                return list.toArray(new IDataBinding[list.size()]);
            }
        }
        if (binding instanceof FlexibleRecordBinding) {
            list = new ArrayList();
            FlexibleRecordBinding rec = (FlexibleRecordBinding)binding;
            for (VariableBinding field : rec.getDeclaredFields()) {
                if (!((FlexibleRecordFieldBinding)field).isImplicit()) continue;
                list.add(field);
            }
            if (list.size() > 0) {
                return list.toArray(new IDataBinding[list.size()]);
            }
        }
        return null;
    }

    private NestedFunctionBinding[] getImplicitFunctions(IBinding binding) {
        if (binding instanceof FunctionContainerBinding) {
            ArrayList<NestedFunctionBinding> list = new ArrayList<NestedFunctionBinding>();
            FunctionContainerBinding fc = (FunctionContainerBinding)binding;
            for (NestedFunctionBinding function : fc.getDeclaredFunctions()) {
                if (!((FunctionBinding)function.getType()).isImplicit()) continue;
                list.add(function);
            }
            if (list.size() > 0) {
                return list.toArray(new NestedFunctionBinding[list.size()]);
            }
        }
        return null;
    }

    private void handleContents(org.eclipse.edt.compiler.core.ast.Part part, EObject container) {
        if (!this.inMofContext) {
            this.handleImplicits(part, container);
        }
        for (Node n : part.getContents()) {
            n.accept(this);
            Object obj = this.stack.pop();
            if (obj instanceof List) {
                for (EObject eobj : (List)obj) {
                    this.handleMember(eobj, container);
                }
                continue;
            }
            this.handleMember((EObject)obj, container);
        }
    }

    private void handleMember(EObject mofObj, EObject container) {
        if (mofObj != null) {
            if (this.inMofContext) {
                ((EMemberContainer)container).addMember((EMember)mofObj);
                if (mofObj instanceof EField && (container instanceof AnnotationType || container instanceof EMetadataType)) {
                    ((EField)mofObj).setContainment(true);
                }
            } else {
                ((Container)container).addMember((Member)mofObj);
            }
        }
    }

    private MofSerializable resolveProxy(ProxyEClass proxy) {
        String key = proxy.getMofSerializationKey();
        EObject result = this.getMofSerializable(key);
        if (result instanceof MofSerializable) {
            return (MofSerializable)result;
        }
        if (!this.inMofContext && key.indexOf(":") < 0 && (result = this.getMofSerializable(key = "egl:" + key)) instanceof MofSerializable) {
            return (MofSerializable)result;
        }
        return null;
    }

    private void setDefaultSuperType(StructPart part) {
        if (part.getSuperTypes().isEmpty()) {
            Stereotype stereotype = part.getStereotype();
            StructPart superType = null;
            if (stereotype != null) {
                MofSerializable mofST = ((StereotypeType)stereotype.getEClass()).getDefaultSuperType();
                if (mofST instanceof ProxyEClass) {
                    mofST = this.resolveProxy((ProxyEClass)mofST);
                }
                if (mofST instanceof StructPart && !mofST.getMofSerializationKey().equalsIgnoreCase(part.getMofSerializationKey())) {
                    superType = (StructPart)mofST;
                }
            }
            if (superType == null) {
                String typeSignature = "egl:eglx.lang.EAny";
                if (part instanceof Record) {
                    typeSignature = "egl:eglx.lang.AnyRecord";
                } else if (part instanceof StructuredRecord) {
                    typeSignature = "egl:eglx.lang.AnyStruct";
                } else if (part instanceof AnnotationType) {
                    typeSignature = "org.eclipse.edt.mof.egl.Annotation";
                } else if (part instanceof StereotypeType) {
                    typeSignature = "org.eclipse.edt.mof.egl.Stereotype";
                }
                superType = (StructPart)this.getMofSerializable(typeSignature);
            }
            if (superType != null && !superType.getMofSerializationKey().equalsIgnoreCase(part.getMofSerializationKey())) {
                part.getSuperTypes().add(superType);
            }
        }
    }

    protected void setCurrentFunctionMember(FunctionMember function) {
        this.currentFunction = function;
    }

    protected FunctionMember getCurrentFunctionMember() {
        return this.currentFunction;
    }

    @Override
    protected void setElementInformation(Node node, EObject obj) {
        Statement stmt;
        if (obj instanceof Statement && (stmt = (Statement)obj).getContainer() == null && this.currentPart instanceof Container) {
            stmt.setContainer((Container)this.currentPart);
        }
        super.setElementInformation(node, obj);
    }
}

