/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.validation;

import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class ForEachStatementValidator
extends AbstractSqlStatementValidator {
    ForEachStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    FromOrToExpressionClause from;
    IntoClause into;

    public ForEachStatementValidator(ForEachStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateTarget();
        this.validateFrom();
        this.validateInto();
    }

    private void validateTarget() {
        Expression expr;
        ITypeBinding type;
        Object o;
        List exprs = this.statement.getTargets();
        boolean isEntity = false;
        if (exprs.size() == 1 && (o = exprs.get(0)) instanceof Expression && this.isEntity(type = (expr = (Expression)o).resolveTypeBinding())) {
            if (this.isAssociationExpression(expr)) {
                this.problemRequestor.acceptProblem((Node)expr, 8508, new String[0]);
                return;
            }
            isEntity = true;
        }
        if (!isEntity && !this.mapsToColumns(exprs)) {
            int[] offsets = this.getOffsets(exprs);
            this.problemRequestor.acceptProblem(offsets[0], offsets[1], 8506, new String[0]);
            return;
        }
    }

    private void validateFrom() {
        ITypeBinding type;
        if (this.from != null && Binding.isValidBinding(type = this.from.getExpression().resolveTypeBinding()) && !this.isResultSet(type)) {
            this.problemRequestor.acceptProblem((Node)this.from.getExpression(), 8500, new String[]{this.from.getExpression().getCanonicalString(), "eglx.persistence.sql.SQLResultSet"});
            return;
        }
    }

    private void validateInto() {
        if (this.into != null) {
            this.problemRequestor.acceptProblem((Node)this.into, 8504, new String[0]);
        }
    }

    private void initialize() {
        this.statement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(ForEachStatement forEachStatement) {
                this.visit(forEachStatement.getTargets());
                forEachStatement.getResultSet().accept(this);
                this.visit(forEachStatement.getForeachOptions());
                return false;
            }

            private void visit(List<Node> list) {
                for (Node node : list) {
                    node.accept(this);
                }
            }

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                if (ForEachStatementValidator.this.from == null) {
                    ForEachStatementValidator.this.from = clause;
                } else {
                    ForEachStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"forEach".toUpperCase(), "from".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(IntoClause intoClause) {
                if (ForEachStatementValidator.this.into == null) {
                    ForEachStatementValidator.this.into = intoClause;
                } else {
                    ForEachStatementValidator.this.problemRequestor.acceptProblem((Node)intoClause, 6510, new String[]{"forEach".toUpperCase(), "into".toUpperCase()});
                }
                return false;
            }
        });
    }
}

