/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.validation;

import java.util.List;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ConstructorBinding;
import org.eclipse.edt.compiler.binding.DictionaryBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.HandlerBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class GetByKeyStatementValidator
extends AbstractSqlStatementValidator {
    GetByKeyStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    UsingClause using;
    UsingKeysClause usingKeys;
    FromOrToExpressionClause from;
    WithInlineSQLClause withInline;
    WithExpressionClause withExpression;
    IntoClause into;

    public GetByKeyStatementValidator(GetByKeyStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateTargets();
        this.validateFrom();
        this.validateInto();
    }

    private void validateTargets() {
        ITypeBinding targetType;
        int[] offsets;
        Expression expr;
        Object o;
        boolean isDataExpr = false;
        List targets = this.statement.getTargets();
        if (targets.size() == 1 && (o = targets.get(0)) instanceof Expression && this.isDataExpr(expr = (Expression)o)) {
            if (this.isAssociationExpression(expr)) {
                this.problemRequestor.acceptProblem((Node)expr, 8508, new String[0]);
                return;
            }
            if (expr.resolveTypeBinding().isNullable() && this.isEntity(expr.resolveTypeBinding()) && !this.hasDefaultConstructor(expr.resolveTypeBinding())) {
                this.problemRequestor.acceptProblem((Node)expr, 8519, new String[]{expr.getCanonicalString(), expr.resolveTypeBinding().getPackageQualifiedName()});
                return;
            }
            isDataExpr = true;
        }
        if (!isDataExpr && !this.mapsToColumns(targets)) {
            offsets = this.getOffsets(targets);
            this.problemRequestor.acceptProblem(offsets[0], offsets[1], 8505, new String[0]);
            return;
        }
        if (!(isDataExpr || this.withExpression != null || this.withInline != null || this.mapsToSingleTable(targets) || this.isFromResultSet())) {
            offsets = this.getOffsets(targets);
            this.problemRequestor.acceptProblem(offsets[0], offsets[1], 8518, new String[]{"with"});
            return;
        }
        if (this.using == null && this.withExpression == null && this.withInline == null && Binding.isValidBinding(targetType = this.getTargetType(isDataExpr)) && !this.hasID(targetType)) {
            int[] offsets2 = this.getOffsets(targets);
            this.problemRequestor.acceptProblem(offsets2[0], offsets2[1], 8509, new String[]{targetType.getPackageQualifiedName()});
            return;
        }
    }

    private boolean hasDefaultConstructor(ITypeBinding binding) {
        List constructors = null;
        switch (binding.getKind()) {
            case 28: {
                constructors = ((ExternalTypeBinding)binding).getConstructors();
                break;
            }
            case 10: {
                constructors = ((HandlerBinding)binding).getConstructors();
                break;
            }
            case 21: {
                constructors = ((DictionaryBinding)binding).getConstructors();
                break;
            }
            default: {
                return true;
            }
        }
        if (constructors != null) {
            for (ConstructorBinding con : constructors) {
                if (con.isPrivate() || con.getParameters().size() != 0) continue;
                return true;
            }
        }
        return false;
    }

    private ITypeBinding getTargetType(boolean isDataExpr) {
        IDataBinding data;
        Expression e;
        ITypeBinding type = null;
        List targets = this.statement.getTargets();
        if ((isDataExpr || this.mapsToSingleTable(targets)) && Binding.isValidBinding(type = (e = (Expression)targets.get(0)).resolveTypeBinding()) && type.getKind() == 3 && Binding.isValidBinding(data = e.resolveDataBinding())) {
            type = data.getDeclaringPart();
        }
        if (Binding.isValidBinding(type) && type.getKind() == 2) {
            type = ((ArrayTypeBinding)type).getElementType();
        }
        return type;
    }

    private boolean isFromResultSet() {
        if (this.from != null) {
            ITypeBinding type = this.from.getExpression().resolveTypeBinding();
            return Binding.isValidBinding(type) && this.isResultSet(type);
        }
        return false;
    }

    private void validateFrom() {
        ITypeBinding type;
        if (this.from != null && (this.withExpression != null || this.withInline != null) && Binding.isValidBinding(type = this.from.getExpression().resolveTypeBinding()) && !this.isDataSource(type)) {
            this.problemRequestor.acceptProblem((Node)this.from.getExpression(), 8500, new String[]{this.from.getExpression().getCanonicalString(), "eglx.persistence.sql.SQLDataSource"});
            return;
        }
    }

    private void validateInto() {
        if (this.into != null) {
            this.problemRequestor.acceptProblem((Node)this.into, 8504, new String[0]);
        }
    }

    private void initialize() {
        this.statement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                if (GetByKeyStatementValidator.this.withInline == null && GetByKeyStatementValidator.this.withExpression == null) {
                    GetByKeyStatementValidator.this.withInline = withInlineSQLClause;
                } else {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6510, new String[]{"get".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(WithExpressionClause withExpressionClause) {
                if (GetByKeyStatementValidator.this.withInline == null && GetByKeyStatementValidator.this.withExpression == null) {
                    GetByKeyStatementValidator.this.withExpression = withExpressionClause;
                } else {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)withExpressionClause, 6510, new String[]{"get".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(UsingClause usingClause) {
                if (GetByKeyStatementValidator.this.using == null) {
                    GetByKeyStatementValidator.this.using = usingClause;
                } else {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)usingClause, 6510, new String[]{"get".toUpperCase(), "using".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause usingKeysClause) {
                if (GetByKeyStatementValidator.this.usingKeys == null) {
                    GetByKeyStatementValidator.this.usingKeys = usingKeysClause;
                } else {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)usingKeysClause, 6510, new String[]{"get".toUpperCase(), "usingKeys".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                if (GetByKeyStatementValidator.this.from == null) {
                    GetByKeyStatementValidator.this.from = clause;
                } else {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"get".toUpperCase(), "from".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(IntoClause intoClause) {
                if (GetByKeyStatementValidator.this.into == null) {
                    GetByKeyStatementValidator.this.into = intoClause;
                } else {
                    GetByKeyStatementValidator.this.problemRequestor.acceptProblem((Node)intoClause, 6510, new String[]{"get".toUpperCase(), "into".toUpperCase()});
                }
                return false;
            }
        });
    }
}

