/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.EGLSQLKeywordHandler;
import org.eclipse.edt.compiler.internal.sql.SelectNameToken;
import org.eclipse.edt.compiler.internal.sql.StringToken;
import org.eclipse.edt.compiler.internal.sql.Token;
import org.eclipse.edt.compiler.internal.sql.WhereCurrentOfToken;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLPrimeToken;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLSQLClauseTree;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLSQLParser;

public class EGLSQLGenerationTokens
implements Serializable {
    private List tokens = null;
    private boolean concatenateStringTokens = true;
    private boolean convertNameTokenToTableNameToken = false;
    private IDataBinding sqlIOObject;
    private transient EGLSQLParser parser;
    String[] tableVariableNames;
    private boolean convertTableNameVariables = false;
    public static final int TYPE_INPUT = 1;
    public static final int TYPE_OUTPUT = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_TABLE = 4;
    public static final int TYPE_QUOTED_STRING = 5;
    public static final int TYPE_WHERE_CURRENT_OF = 6;
    public static final int TYPE_SELECT_NAME = 7;
    public static final int STATE_CLEAR = 0;
    public static final int STATE_ABOUTTOREADMULTIPLEOUTPUT = 1;
    public static final int STATE_ABOUTTOREADMULTIPLETABLE = 2;
    public static final int STATE_ABOUTTOREADSINGLETABLE = 3;
    public static final int STATE_DELETE = 4;
    public static final int STATE_INSERT = 5;
    public static final int STATE_MULTIPLEINPUT = 6;
    public static final int STATE_MULTIPLEOUTPUT = 7;
    public static final int STATE_MULTIPLETABLE = 8;
    public static final int STATE_SINGLETABLE = 9;
    public int state = 0;
    private Set tableHostVarSet;

    public EGLSQLGenerationTokens() {
    }

    public EGLSQLGenerationTokens(EGLSQLParser parser) {
        this(parser, null, false);
    }

    public EGLSQLGenerationTokens(EGLSQLParser parser, IDataBinding sqlIOObject) {
        this(parser, sqlIOObject, false);
    }

    public EGLSQLGenerationTokens(EGLSQLParser parser, String[] tableVariableNames) {
        this(parser, null, false);
        this.tableVariableNames = tableVariableNames;
    }

    public EGLSQLGenerationTokens(EGLSQLParser parser, IDataBinding sqlIOObject, boolean convertNames) {
        this();
        this.parser = parser;
        this.sqlIOObject = sqlIOObject;
        this.convertNameTokenToTableNameToken = convertNames;
    }

    public Token[] getAllTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getAllTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getSelectTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getSelectTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getIntoTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getIntoTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getCallTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getCallTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getColumnsTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getColumnsTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getFromTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getFromTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getValuesTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getValuesTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getUpdateTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getUpdateTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getDeleteTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getDeleteTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getSetTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getSetTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getHavingTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getHavingTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getWhereTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getWhereTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getWhereCurrentOfTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getWhereCurrentOfTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getOrderByTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getOrderByTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getGroupByTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getGroupByTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getInsertIntoTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getInsertIntoTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getForUpdateOfTokens() {
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getForUpdateOfTokens();
        this.state = 0;
        return this.getTokens(primeTokens);
    }

    public Token[] getSelectNameTokens() {
        int start;
        this.tokens = new ArrayList();
        if (this.parser.hasErrors()) {
            return null;
        }
        EGLSQLClauseTree primeTokens = this.parser.getSelectTokens();
        if (primeTokens == null) {
            return null;
        }
        this.state = 0;
        int ii = start = 0;
        while (ii < primeTokens.size()) {
            if (primeTokens.getToken(ii).getType() == 1) {
                this.checkState(primeTokens.getToken(ii).getText());
                this.addToken(Token.createToken(primeTokens.getToken(ii), 3, this, null));
            } else if (primeTokens.getToken(ii).getType() == 45) {
                this.addToken(Token.createToken(primeTokens.getToken(ii), 3, this, null));
            } else if (ii > 0 && primeTokens.getToken(ii - 1).getType() == 1 && (primeTokens.getToken(ii).getText().equalsIgnoreCase("distinct") || primeTokens.getToken(ii).getText().equalsIgnoreCase("all"))) {
                this.addToken(Token.createToken(primeTokens.getToken(ii), 3, this, null));
            } else {
                this.checkState(primeTokens.getToken(ii).getText());
                Token newToken = Token.createToken(primeTokens.getToken(ii), 7, this, null);
                this.addSelectNameToken(newToken);
            }
            ++ii;
        }
        return this.tokens.toArray(new Token[this.tokens.size()]);
    }

    private Token[] getTokens(EGLSQLClauseTree primeTokens) {
        int start;
        IAnnotationBinding annotationBinding;
        EGLPrimeToken prevToken = null;
        EGLPrimeToken prevKeywordToken = null;
        this.tokens = new ArrayList();
        this.tableHostVarSet = null;
        Set sqlKeywords = EGLSQLKeywordHandler.getSQLKeywordNamesToLowerCaseAsSet();
        if (this.tableVariableNames == null && this.sqlIOObject != null && this.sqlIOObject != IBinding.NOT_FOUND_BINDING && (annotationBinding = this.getField(this.sqlIOObject.getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord"), "tableNameVariables")) != null && annotationBinding.getValue() != null) {
            String[][] value = (String[][])annotationBinding.getValue();
            this.tableVariableNames = new String[value.length];
            int i = 0;
            while (i < value.length) {
                this.tableVariableNames[i] = value[i][0];
                ++i;
            }
        }
        if (primeTokens == null) {
            return null;
        }
        int ii = start = 0;
        while (ii < primeTokens.size()) {
            if (primeTokens.getToken(ii).getType() != Integer.MAX_VALUE) {
                int endOffset;
                int startOffset;
                if (primeTokens.getToken(ii).getType() == 28) {
                    this.checkState(primeTokens.getToken(ii).getText());
                    StringBuffer hostVar = new StringBuffer(primeTokens.getToken(ii).getText());
                    startOffset = primeTokens.getToken(ii).getOffset();
                    endOffset = 0;
                    ++ii;
                    while (ii < primeTokens.size() && primeTokens.getToken(ii).isHostVar()) {
                        if ("-".equals(primeTokens.getToken(ii).getText())) {
                            hostVar.append(" - ");
                            endOffset = primeTokens.getToken(ii).getOffset() + 2;
                        } else {
                            hostVar.append(primeTokens.getToken(ii).getText());
                            endOffset = primeTokens.getToken(ii).getOffset() + primeTokens.getToken(ii).getText().length() - 1;
                        }
                        ++ii;
                    }
                    --ii;
                    this.addToken(Token.createToken(hostVar.toString(), this.getType(), this, prevToken, startOffset, endOffset));
                } else if (primeTokens.getToken(ii).isDelimiter()) {
                    this.addToken(Token.createToken(primeTokens.getToken(ii), 3, this, prevToken, primeTokens.getToken(ii).getOffset(), primeTokens.getToken(ii).getOffset() + primeTokens.getToken(ii).getText().length() - 1));
                } else if (primeTokens.getToken(ii).isWhereCurrentOf()) {
                    this.checkState(primeTokens.getToken(ii).getText());
                    Token whereCurrentOf = Token.createToken(primeTokens.getToken(ii).getText(), 6, this, prevToken);
                    whereCurrentOf.setStartOffset(primeTokens.getToken(ii).getOffset());
                    ++ii;
                    while (ii < primeTokens.size() && primeTokens.getToken(ii).isWhereCurrentOf()) {
                        ((WhereCurrentOfToken)whereCurrentOf).append(new StringToken(primeTokens.getToken(ii)));
                        ++ii;
                    }
                    whereCurrentOf.setEndOffset(primeTokens.getToken(--ii).getOffset() + primeTokens.getToken(ii).getText().length() - 1);
                    this.addToken(whereCurrentOf);
                } else {
                    this.checkState(primeTokens.getToken(ii).getText());
                    if (prevKeywordToken != null && (prevKeywordToken.getText().equalsIgnoreCase("update") || prevKeywordToken.getText().equalsIgnoreCase("into") || prevKeywordToken.getText().equalsIgnoreCase("join") || prevKeywordToken.getText().equalsIgnoreCase("from"))) {
                        this.convertTableNameVariables = true;
                    }
                    if (this.convertTableNameVariables && this.tableVariableNames != null) {
                        if (this.identifierMatchesTableNameVariable(primeTokens, ii)) {
                            StringBuffer hostVar = new StringBuffer(primeTokens.getToken(ii).getText());
                            startOffset = primeTokens.getToken(ii).getOffset();
                            endOffset = 0;
                            ++ii;
                            while (ii < primeTokens.size() && primeTokens.getToken(ii).isHostVar()) {
                                hostVar.append(primeTokens.getToken(ii).getText());
                                endOffset = primeTokens.getToken(ii).getOffset() + primeTokens.getToken(ii).getText().length() - 1;
                                ++ii;
                            }
                            --ii;
                            this.addToken(Token.createToken(hostVar.toString(), 4, this, prevToken, startOffset, endOffset));
                        } else {
                            this.addToken(Token.createToken(primeTokens.getToken(ii), this.getType(), this, prevToken, primeTokens.getToken(ii).getOffset(), primeTokens.getToken(ii).getOffset() + primeTokens.getToken(ii).getText().length() - 1));
                        }
                    } else {
                        this.addToken(Token.createToken(primeTokens.getToken(ii), this.getType(), this, prevToken, primeTokens.getToken(ii).getOffset(), primeTokens.getToken(ii).getOffset() + primeTokens.getToken(ii).getText().length() - 1));
                    }
                    this.convertTableNameVariables = false;
                }
            }
            prevToken = primeTokens.getToken(ii);
            if (sqlKeywords.contains(primeTokens.getToken(ii).getText().toLowerCase())) {
                prevKeywordToken = primeTokens.getToken(ii);
            }
            ++ii;
        }
        return this.tokens.toArray(new Token[this.tokens.size()]);
    }

    public boolean identifierMatchesTableNameVariable(EGLSQLClauseTree primeTokens, int index) {
        int startIndex = index;
        EGLPrimeToken currentToken = null;
        EGLSQLClauseTree tempTokens = new EGLSQLClauseTree();
        tempTokens.addToken(primeTokens.getToken(index));
        currentToken = ++index < primeTokens.size() ? primeTokens.getToken(index) : null;
        while (!(currentToken == null || currentToken.getType() == 23 || currentToken.getType() == 45 || currentToken.getType() == 30 || currentToken.getType() == 40 || currentToken.getType() == 36 || currentToken.getType() == 37 || currentToken.getType() == 38 || currentToken.getType() == 39 || currentToken.getType() == 29 || currentToken.getType() == 31 || currentToken.getType() == 33 || currentToken.getType() == 32 || currentToken.getType() == 35 || currentToken.getType() == 43 || currentToken.getType() == 41 || currentToken.getType() == 44 || currentToken.getType() == 42 || currentToken.getText().equals("/") || currentToken.getType() != 24 && tempTokens.getLastToken().getOffset() + tempTokens.getLastToken().getText().length() != currentToken.getOffset())) {
            if (currentToken.getType() == 24) {
                while (currentToken != null && currentToken.getType() != 25) {
                    tempTokens.addToken(currentToken);
                    currentToken = ++index < primeTokens.size() ? primeTokens.getToken(index) : null;
                }
                if (currentToken.getType() != 25) continue;
                tempTokens.addToken(currentToken);
                continue;
            }
            tempTokens.addToken(currentToken);
            currentToken = ++index < primeTokens.size() ? primeTokens.getToken(index) : null;
        }
        String variable = tempTokens.toStringNoWhiteSpace();
        if (this.tableVariableNames == null) {
            return false;
        }
        String currentVariable = null;
        int jj = 0;
        while (jj < this.tableVariableNames.length) {
            currentVariable = this.tableVariableNames[jj];
            if (variable.equalsIgnoreCase(currentVariable)) {
                int kk = 0;
                while (kk < tempTokens.size()) {
                    primeTokens.getToken(kk + startIndex).setHostVar();
                    ++kk;
                }
                return true;
            }
            ++jj;
        }
        return false;
    }

    public IDataBinding getSQLIOObject() {
        return this.sqlIOObject;
    }

    public boolean isConvertNameTokenToTableNameToken() {
        return this.convertNameTokenToTableNameToken;
    }

    public void setConvertNameTokenToTableNameToken(boolean newConvertNameTokenToTableNameToken) {
        this.convertNameTokenToTableNameToken = newConvertNameTokenToTableNameToken;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addToken(Token token) {
        if (this.concatenateStringTokens) {
            if (this.shouldConcatenateToken(token)) {
                StringToken prevToken = (StringToken)this.tokens.get(this.tokens.size() - 1);
                prevToken.append((StringToken)token);
                return;
            }
            this.tokens.add(token);
            return;
        }
        if (this.tokens.size() == 0 && token.isStringToken()) {
            if (token.string.trim().length() == 0) return;
        }
        this.tokens.add(token);
    }

    public void addSelectNameToken(Token token) {
        if (!this.shouldConcatenateSelectNameToken(token)) {
            this.tokens.add(token);
            return;
        }
        SelectNameToken prevToken = (SelectNameToken)this.tokens.get(this.tokens.size() - 1);
        prevToken.append((SelectNameToken)token);
    }

    private void checkState(String string) {
        switch (this.state) {
            case 1: {
                this.stateAboutToReadMultipleOutput(string);
                break;
            }
            case 7: {
                this.stateMultipleOutput(string);
                break;
            }
            case 6: {
                this.stateMultipleInput(string);
                break;
            }
            case 9: {
                this.stateSingleTable(string);
                break;
            }
            case 8: {
                this.stateMultipleTable(string);
                break;
            }
            case 5: {
                this.stateInsert(string);
                break;
            }
            case 4: {
                this.stateDelete(string);
                break;
            }
            case 3: {
                this.stateAboutToReadSingleTable(string);
                break;
            }
            case 2: {
                this.stateAboutToReadMultipleTable(string);
                break;
            }
            case 0: {
                this.stateClear(string);
            }
        }
    }

    private static String getHostVariableIdentifier() {
        return ":";
    }

    private int getType() {
        switch (this.state) {
            case 7: {
                return 2;
            }
            case 6: {
                return 1;
            }
            case 9: {
                return 4;
            }
            case 8: {
                return 1;
            }
        }
        return 3;
    }

    private void stateAboutToReadMultipleOutput(String string) {
        if (string.startsWith(EGLSQLGenerationTokens.getHostVariableIdentifier())) {
            this.state = 7;
            return;
        }
        this.state = 0;
        this.stateClear(string);
    }

    private void stateAboutToReadMultipleTable(String string) {
        if (string.startsWith(EGLSQLGenerationTokens.getHostVariableIdentifier())) {
            this.state = 8;
            return;
        }
        if (string.equalsIgnoreCase("where") || string.equalsIgnoreCase("having") || string.equalsIgnoreCase("group")) {
            this.state = 0;
            return;
        }
    }

    private void stateAboutToReadSingleTable(String string) {
        if (string.startsWith(EGLSQLGenerationTokens.getHostVariableIdentifier())) {
            this.state = 9;
            return;
        }
        this.state = 0;
        this.stateClear(string);
    }

    private void stateClear(String string) {
        if (string.equalsIgnoreCase("from")) {
            this.state = 2;
            return;
        }
        if (string.equalsIgnoreCase("update")) {
            this.state = 3;
            return;
        }
        if (string.equalsIgnoreCase("into")) {
            this.state = 1;
            return;
        }
        if (string.equalsIgnoreCase("insert")) {
            this.state = 5;
            return;
        }
        if (string.equalsIgnoreCase("call")) {
            this.state = 1;
            return;
        }
        if (string.startsWith(EGLSQLGenerationTokens.getHostVariableIdentifier())) {
            this.state = 6;
            return;
        }
    }

    private void stateDelete(String string) {
        if (string.equalsIgnoreCase("from")) {
            this.state = 3;
            return;
        }
        this.state = 0;
        this.stateClear(string);
    }

    private void stateInsert(String string) {
        if (string.equalsIgnoreCase("into")) {
            this.state = 3;
            return;
        }
        this.state = 0;
        this.stateClear(string);
    }

    private void stateMultipleInput(String string) {
        if (string.startsWith(EGLSQLGenerationTokens.getHostVariableIdentifier())) {
            return;
        }
        this.state = 0;
        this.stateClear(string);
    }

    private void stateMultipleOutput(String string) {
        if (string.startsWith(EGLSQLGenerationTokens.getHostVariableIdentifier())) {
            return;
        }
        this.state = 0;
        this.stateClear(string);
    }

    private void stateMultipleTable(String string) {
        if (string.startsWith(EGLSQLGenerationTokens.getHostVariableIdentifier())) {
            return;
        }
        if (string.equalsIgnoreCase("where") || string.equalsIgnoreCase("having") || string.equalsIgnoreCase("group")) {
            this.state = 0;
            return;
        }
        this.state = 2;
    }

    private void stateSingleTable(String string) {
        this.state = 0;
        this.stateClear(string);
    }

    private boolean shouldConcatenateToken(Token token) {
        if (this.tokens.size() < 1) {
            return false;
        }
        if (!token.isStringToken()) {
            return false;
        }
        return ((Token)this.tokens.get(this.tokens.size() - 1)).isStringToken();
    }

    private boolean shouldConcatenateSelectNameToken(Token token) {
        if (this.tokens.size() < 1) {
            return false;
        }
        if (!token.isSelectNameToken()) {
            return false;
        }
        return ((Token)this.tokens.get(this.tokens.size() - 1)).isSelectNameToken();
    }

    private IAnnotationBinding getField(IAnnotationBinding aBinding, String fieldName) {
        IDataBinding fieldBinding = aBinding.findData(fieldName);
        return IBinding.NOT_FOUND_BINDING == fieldBinding ? null : (IAnnotationBinding)fieldBinding;
    }
}

