/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql.statements;

import java.util.List;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLClauseFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLDeclareStatementFactory;
import org.eclipse.edt.compiler.internal.sql.util.SQLUtility;

public class EGLSQLGetByKeyForUpdateStatementFactory
extends EGLSQLDeclareStatementFactory {
    String forUpdateOfClause = null;
    String[] columnsExcludingReadOnlyAndKeys = null;

    public EGLSQLGetByKeyForUpdateStatementFactory(IDataBinding recordBinding, String ioObjectName, List userDefinedIntoItemNames, String[][] keyItemAndColumnNames, boolean isDynamicArrayRecord, ICompilerOptions compilerOptions) {
        super(recordBinding, ioObjectName, userDefinedIntoItemNames, keyItemAndColumnNames, isDynamicArrayRecord, compilerOptions);
    }

    public EGLSQLGetByKeyForUpdateStatementFactory(IDataBinding recordBinding, String ioObjectName, ICompilerOptions compilerOptions) {
        super(recordBinding, ioObjectName, null, null, false, compilerOptions);
    }

    @Override
    public String buildDefaultSQLStatement() {
        super.buildDefaultSQLStatement();
        if (this.sqlStatement != null) {
            this.columnsExcludingReadOnlyAndKeys = this.getColumnsExcludingReadOnlyAndKeys();
            if (this.columnsExcludingReadOnlyAndKeys != null) {
                this.forUpdateOfClause = EGLSQLClauseFactory.createDefaultForUpdateOfClause(this.columnsExcludingReadOnlyAndKeys);
                if (this.forUpdateOfClause != null) {
                    this.sqlStatement = String.valueOf(this.sqlStatement) + this.forUpdateOfClause;
                }
            }
        }
        return this.sqlStatement;
    }

    private String[] getColumnsExcludingReadOnlyAndKeys() {
        String[] columns = new String[this.numSQLDataItems];
        int numNonReadOnlyAndKeys = 0;
        if (this.structureItemBindings != null) {
            int i = 0;
            while (i < this.numSQLDataItems) {
                IDataBinding itemBinding = this.structureItemBindings[i];
                String columnName = this.getColumnName(itemBinding);
                boolean isReadOnly = this.getIsReadOnly(itemBinding);
                if (!isReadOnly && !this.isKey(itemBinding)) {
                    columns[numNonReadOnlyAndKeys] = columnName;
                    ++numNonReadOnlyAndKeys;
                }
                ++i;
            }
        }
        if (numNonReadOnlyAndKeys != 0) {
            String[] readWriteColumns = new String[numNonReadOnlyAndKeys];
            int i = 0;
            while (i < numNonReadOnlyAndKeys) {
                readWriteColumns[i] = columns[i];
                ++i;
            }
            return readWriteColumns;
        }
        return null;
    }

    public String getForUpdateOfClause() {
        return this.forUpdateOfClause;
    }

    @Override
    public String getIOType() {
        return "get forUpdate".toUpperCase();
    }

    @Override
    protected boolean isIoObjectValid() {
        boolean isValid = super.isIoObjectValid();
        if (!this.validateSQLRecordNotJoinAndContainsOneNonReadOnlyOrNonKeyColumn()) {
            isValid = false;
        }
        return isValid;
    }

    private boolean isKey(IDataBinding itemBinding) {
        if (this.useRecordKeys) {
            return this.isRecordKeyItem(itemBinding);
        }
        return this.isUsingKeyColumn(itemBinding);
    }

    private boolean isUsingKeyColumn(IDataBinding itemBinding) {
        return SQLUtility.isUsingKeyColumn(itemBinding, this.keyItemAndColumnNames, this.sqlRecordData);
    }

    @Override
    protected boolean containsOnlyKeyOrReadOnlyColumns() {
        if (!this.useRecordKeys) {
            return SQLUtility.containsOnlyKeyOrReadOnlyColumns(this.sqlRecordData, this.keyItemAndColumnNames);
        }
        return false;
    }
}

