/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql.statements;

import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLClauseFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLStatementFactory;

public class EGLSQLReplaceStatementFactory
extends EGLSQLStatementFactory {
    String updateClause = null;
    String setClause = null;
    String whereClause = null;
    boolean noCursor = false;

    public EGLSQLReplaceStatementFactory(IDataBinding recordBinding, String ioObjectName, String[][] keyItemAndColumnNames, boolean noCursor, ICompilerOptions compilerOptions) {
        super(recordBinding, ioObjectName, compilerOptions);
        this.keyItemAndColumnNames = keyItemAndColumnNames;
        this.noCursor = noCursor;
    }

    @Override
    public String buildDefaultSQLStatement() {
        if (!this.setupSQLInfo()) {
            return null;
        }
        this.updateClause = EGLSQLClauseFactory.createDefaultUpdateClause(this.tableNames, this.tableLabels);
        this.sqlStatement = this.updateClause != null ? this.updateClause : "";
        this.setClause = EGLSQLClauseFactory.createDefaultSetClause(this.columnNames, this.itemNames, this.ioObjectName);
        if (this.setClause != null) {
            this.sqlStatement = this.sqlStatement.concat(this.setClause);
        }
        this.whereClause = EGLSQLClauseFactory.createDefaultWhereClause(this.getDefaultSelectConditions(), this.keyItemAndColumnNames, this.getIOType(), this.ioObjectName, false, this.useRecordKeys);
        if (this.whereClause != null) {
            this.sqlStatement = String.valueOf(this.sqlStatement) + this.whereClause;
        }
        return this.sqlStatement;
    }

    @Override
    public String getIOType() {
        return "replace".toUpperCase();
    }

    public String getSetClause() {
        return this.setClause;
    }

    public String getUpdateClause() {
        return this.updateClause;
    }

    @Override
    protected boolean isIoObjectValid() {
        boolean isValid = super.isIoObjectValid();
        isValid = this.hasPersistentItems();
        if (!this.validateSQLRecordNotJoinAndContainsOneNonReadOnlyOrNonKeyColumn()) {
            isValid = false;
        }
        return isValid;
    }

    protected boolean hasPersistentItems() {
        boolean isValid = true;
        if (this.numSQLDataItems == 0) {
            this.errorMessages.add(this.getContainsNoItemsMessage());
            isValid = false;
        }
        return isValid;
    }

    @Override
    protected void setupItemColumnAndKeyInfo() {
        this.setupForSQLUpdateStatement();
    }

    @Override
    public String getSQLStatementType() {
        return "update".toUpperCase();
    }

    protected Problem getContainsNoItemsMessage() {
        return new Problem(0, 0, 2, 4530, new String[]{this.ioObjectName});
    }
}

