/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sqltokenizer;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLCharInfo;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLPrimeToken;

public class EGLSQLLexer {
    protected PushbackReader reader;
    protected int leftSquare;
    protected int offset;
    protected int line;
    protected int column;
    protected boolean sawCR;
    protected ArrayList problems;
    protected ArrayList comments;
    public EGLPrimeToken lookAhead1;
    public EGLPrimeToken lookAhead2;
    public EGLPrimeToken lookAhead3;
    public static final HashMap clauseKeywords = new HashMap(18);
    private ICompilerOptions compilerOptions;

    static {
        clauseKeywords.put("select", new Integer(1));
        clauseKeywords.put("into", new Integer(2));
        clauseKeywords.put("from", new Integer(3));
        clauseKeywords.put("values", new Integer(4));
        clauseKeywords.put("update", new Integer(5));
        clauseKeywords.put("set", new Integer(6));
        clauseKeywords.put("having", new Integer(7));
        clauseKeywords.put("where", new Integer(8));
        clauseKeywords.put("order", new Integer(9));
        clauseKeywords.put("group", new Integer(10));
        clauseKeywords.put("insert", new Integer(11));
        clauseKeywords.put("for", new Integer(12));
        clauseKeywords.put("by", new Integer(13));
        clauseKeywords.put("of", new Integer(14));
        clauseKeywords.put("union", new Integer(15));
        clauseKeywords.put("current", new Integer(16));
        clauseKeywords.put("call", new Integer(17));
        clauseKeywords.put("delete", new Integer(18));
    }

    public EGLSQLLexer(Reader reader, ICompilerOptions compilerOptions) {
        this(reader, 0, compilerOptions);
    }

    public EGLSQLLexer(Reader reader, int currentOffset, ICompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
        this.init(reader);
        this.leftSquare = 0;
        this.offset = currentOffset - 1;
        this.line = 1;
        this.column = 0;
        this.lookAhead1 = null;
        this.lookAhead2 = null;
        this.lookAhead3 = null;
    }

    public void init(Reader reader) {
        this.reader = new PushbackReader(reader, 2);
        this.line = 1;
        this.column = 0;
        this.offset = -1;
        this.lookAhead1 = null;
        this.lookAhead2 = null;
        this.lookAhead3 = null;
        this.sawCR = false;
        if (this.problems == null) {
            this.problems = new ArrayList();
        } else {
            this.problems.clear();
        }
        if (this.comments == null) {
            this.comments = new ArrayList();
        } else {
            this.comments.clear();
        }
    }

    public List getComments() {
        return this.comments;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public ArrayList getProblems() {
        return this.problems;
    }

    public EGLPrimeToken getNextToken() throws IOException {
        EGLPrimeToken token = null;
        if (this.lookAhead1 == null) {
            token = this.nextToken();
            if (token != null) {
                this.lookAhead1 = this.nextToken();
                if (this.lookAhead1 != null) {
                    this.lookAhead2 = this.nextToken();
                }
                if (this.lookAhead2 != null) {
                    this.lookAhead3 = this.nextToken();
                }
            }
        } else if (this.lookAhead2 == null) {
            token = this.lookAhead1;
            this.lookAhead1 = this.lookAhead2;
            if (this.lookAhead1 != null) {
                this.lookAhead2 = this.nextToken();
            }
            if (this.lookAhead2 != null) {
                this.lookAhead3 = this.nextToken();
            }
        } else {
            token = this.lookAhead1;
            this.lookAhead1 = this.lookAhead2;
            this.lookAhead2 = this.lookAhead3;
            if (this.lookAhead2 != null) {
                this.lookAhead3 = this.nextToken();
            }
        }
        return token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EGLPrimeToken nextToken() throws IOException {
        int c = this.scanNonBlank();
        if (c == -1) {
            return null;
        }
        block5: while (c == 45) {
            switch (this.scanAheadOneChar()) {
                case 45: {
                    this.readSQLLineComment(c, this.offset, this.line, this.column);
                    break;
                }
                default: {
                    break block5;
                }
            }
            c = this.scanNonBlank();
            if (c != -1) continue;
            return null;
        }
        if (EGLCharInfo.isIdentifier1(c, this.compilerOptions)) {
            return this.readIdentifier(c, this.offset, this.line, this.column);
        }
        if (EGLCharInfo.isDigit(c)) {
            return this.readNumber(c, this.offset, this.line, this.column);
        }
        if (c == 46 && EGLCharInfo.isDigit(this.scanAheadOneChar())) {
            return this.readFraction(c, this.offset, this.line, this.column);
        }
        if (EGLCharInfo.isSymbol1(c)) {
            return this.readSymbol(c, this.offset, this.line, this.column);
        }
        if (c == 39) {
            return this.readSQLString(c, this.offset, this.line, this.column);
        }
        if (c != 34) return new EGLPrimeToken(61, String.valueOf((char)c), this.offset, this.line, this.column);
        return this.readDelimitedName(c, this.offset, this.line, this.column);
    }

    protected EGLPrimeToken readFraction(int c, int startOffset, int startLine, int startColumn) throws IOException {
        int maxSize;
        int kind;
        StringBuffer s = new StringBuffer().append((char)c);
        while (EGLCharInfo.isDigit(c)) {
            s.append((char)this.scanChar());
            c = this.scanAheadOneChar();
        }
        if (c == 101 || c == 69) {
            kind = 54;
            maxSize = 36;
            s.append((char)this.scanChar());
            c = this.scanAheadOneChar();
            if (c == 43 || c == 45) {
                s.append((char)this.scanChar());
                c = this.scanAheadOneChar();
            }
            while (EGLCharInfo.isDigit(c)) {
                s.append((char)this.scanChar());
                c = this.scanAheadOneChar();
            }
        } else {
            kind = 53;
            maxSize = 33;
        }
        if (s.length() > maxSize) {
            this.problems.add(new Problem(startOffset, startOffset + s.length(), 2, 5203, new String[0]));
        }
        return new EGLPrimeToken(kind, s.toString(), startOffset, startLine, startColumn);
    }

    protected EGLPrimeToken readIdentifier(int c, int startOffset, int startLine, int startColumn) throws IOException {
        StringBuffer s = new StringBuffer().append((char)c);
        while (EGLCharInfo.isIdentifier(this.scanAheadOneChar(), this.compilerOptions)) {
            s.append((char)this.scanChar());
        }
        String ident = s.toString();
        int kind = EGLSQLLexer.keywordKind(ident);
        if (kind == -1) {
            kind = 51;
        }
        return new EGLPrimeToken(kind, ident, startOffset, startLine, startColumn);
    }

    protected EGLPrimeToken readSQLLineComment(int c, int startOffset, int startLine, int startColumn) throws IOException {
        StringBuffer s = new StringBuffer().append((char)c);
        s.append((char)this.scanChar());
        c = this.scanChar();
        while (c != -1 && c != 13 && c != 10) {
            s.append((char)c);
            c = this.scanChar();
        }
        this.comments.add(new EGLPrimeToken(Integer.MAX_VALUE, s.toString(), startOffset, startLine, startColumn));
        return (EGLPrimeToken)this.comments.get(this.comments.size() - 1);
    }

    protected EGLPrimeToken readNumber(int c, int startOffset, int startLine, int startColumn) throws IOException {
        int maxSize;
        int kind;
        StringBuffer s = new StringBuffer().append((char)c);
        c = this.scanAheadOneChar();
        while (EGLCharInfo.isDigit(c)) {
            s.append((char)this.scanChar());
            c = this.scanAheadOneChar();
        }
        if (c != 46 && c != 101 && c != 69) {
            kind = 55;
            maxSize = 18;
        } else {
            if (c == 46) {
                s.append((char)this.scanChar());
                c = this.scanAheadOneChar();
                while (EGLCharInfo.isDigit(c)) {
                    s.append((char)this.scanChar());
                    c = this.scanAheadOneChar();
                }
            }
            if (c == 101 || c == 69) {
                kind = 54;
                maxSize = 36;
                s.append((char)this.scanChar());
                c = this.scanAheadOneChar();
                if (c == 43 || c == 45) {
                    s.append((char)this.scanChar());
                    c = this.scanAheadOneChar();
                }
                while (EGLCharInfo.isDigit(c)) {
                    s.append((char)this.scanChar());
                    c = this.scanAheadOneChar();
                }
            } else {
                kind = 53;
                maxSize = 33;
            }
        }
        if (s.length() > maxSize) {
            this.problems.add(new Problem(startOffset, startOffset + s.length(), 2, 5203, new String[0]));
        }
        return new EGLPrimeToken(kind, s.toString(), startOffset, startLine, startColumn);
    }

    protected EGLPrimeToken readSQLString(int firstChar, int startOffset, int startLine, int startColumn) throws IOException {
        StringBuffer s = new StringBuffer().append((char)firstChar);
        while (true) {
            int nextChar = this.scanAheadOneChar();
            switch (nextChar) {
                case 39: {
                    s.append((char)this.scanChar());
                    return new EGLPrimeToken(52, s.toString(), startOffset, startLine, startColumn);
                }
                case -1: 
                case 10: 
                case 13: {
                    this.problems.add(new Problem(startOffset, startOffset + s.length(), 2, 5202, new String[0]));
                    return new EGLPrimeToken(52, s.toString(), startOffset, startLine, startColumn);
                }
            }
            s.append((char)this.scanChar());
        }
    }

    protected EGLPrimeToken readEGLString(int firstChar, int startOffset, int startLine, int startColumn) throws IOException {
        StringBuffer s = new StringBuffer().append((char)firstChar);
        while (true) {
            int nextChar = this.scanAheadOneChar();
            switch (nextChar) {
                case 34: {
                    s.append((char)this.scanChar());
                    return new EGLPrimeToken(52, s.toString(), startOffset, startLine, startColumn);
                }
                case -1: 
                case 10: 
                case 13: {
                    return new EGLPrimeToken(52, s.toString(), startOffset, startLine, startColumn);
                }
            }
            s.append((char)this.scanChar());
        }
    }

    protected EGLPrimeToken readDelimitedName(int firstChar, int startOffset, int startLine, int startColumn) throws IOException {
        StringBuffer s = new StringBuffer().append((char)firstChar);
        block4: while (true) {
            int nextChar = this.scanAheadOneChar();
            switch (nextChar) {
                case 34: {
                    s.append((char)this.scanChar());
                    int lookAheadChar = this.scanAheadOneChar();
                    if (lookAheadChar == 34) {
                        s.append((char)this.scanChar());
                        continue block4;
                    }
                    return new EGLPrimeToken(59, s.toString(), startOffset, startLine, startColumn);
                }
                case -1: 
                case 10: 
                case 13: {
                    this.problems.add(new Problem(startOffset, startOffset + s.length(), 2, 5202, new String[0]));
                    return new EGLPrimeToken(52, s.toString(), startOffset, startLine, startColumn);
                }
            }
            s.append((char)this.scanChar());
        }
    }

    protected EGLPrimeToken readSymbol(int c, int startOffset, int startLine, int startColumn) throws IOException {
        switch (c) {
            case 59: {
                return new EGLPrimeToken(21, ";", startOffset, startLine, startColumn);
            }
            case 40: {
                return new EGLPrimeToken(22, "(", startOffset, startLine, startColumn);
            }
            case 41: {
                return new EGLPrimeToken(23, ")", startOffset, startLine, startColumn);
            }
            case 91: {
                ++this.leftSquare;
                return new EGLPrimeToken(24, "[", startOffset, startLine, startColumn);
            }
            case 93: {
                if (this.leftSquare > 0) {
                    --this.leftSquare;
                }
                return new EGLPrimeToken(25, "]", startOffset, startLine, startColumn);
            }
            case 44: {
                return new EGLPrimeToken(45, ",", startOffset, startLine, startColumn);
            }
            case 46: {
                return new EGLPrimeToken(26, ".", startOffset, startLine, startColumn);
            }
            case 58: {
                if (this.leftSquare > 0) {
                    return new EGLPrimeToken(27, ":", startOffset, startLine, startColumn);
                }
                return new EGLPrimeToken(28, ":", startOffset, startLine, startColumn);
            }
            case 61: {
                return new EGLPrimeToken(30, "=", startOffset, startLine, startColumn);
            }
            case 43: {
                return new EGLPrimeToken(31, "+", startOffset, startLine, startColumn);
            }
            case 45: {
                return new EGLPrimeToken(32, "-", startOffset, startLine, startColumn);
            }
            case 42: {
                return new EGLPrimeToken(33, "*", startOffset, startLine, startColumn);
            }
            case 47: {
                return new EGLPrimeToken(34, "/", startOffset, startLine, startColumn);
            }
            case 37: {
                return new EGLPrimeToken(35, "%", startOffset, startLine, startColumn);
            }
            case 62: {
                if (this.scanAheadOneChar() == 61) {
                    this.scanChar();
                    return new EGLPrimeToken(37, ">=", startOffset, startLine, startColumn);
                }
                return new EGLPrimeToken(36, ">", startOffset, startLine, startColumn);
            }
            case 60: {
                if (this.scanAheadOneChar() == 61) {
                    this.scanChar();
                    return new EGLPrimeToken(39, "<=", startOffset, startLine, startColumn);
                }
                return new EGLPrimeToken(38, "<", startOffset, startLine, startColumn);
            }
            case 33: {
                if (this.scanAheadOneChar() == 61) {
                    this.scanChar();
                    return new EGLPrimeToken(40, "!=", startOffset, startLine, startColumn);
                }
                return new EGLPrimeToken(29, "!", startOffset, startLine, startColumn);
            }
            case 124: {
                if (this.scanAheadOneChar() == 124) {
                    this.scanChar();
                    return new EGLPrimeToken(41, "||", startOffset, startLine, startColumn);
                }
                return new EGLPrimeToken(42, "|", startOffset, startLine, startColumn);
            }
            case 38: {
                if (this.scanAheadOneChar() == 38) {
                    this.scanChar();
                    return new EGLPrimeToken(43, "&&", startOffset, startLine, startColumn);
                }
                return new EGLPrimeToken(44, "&", startOffset, startLine, startColumn);
            }
        }
        return null;
    }

    protected String getHostVariableName() throws IOException {
        StringBuffer s = new StringBuffer().append(':');
        while (true) {
            int nextChar = this.scanAheadOneChar();
            switch (nextChar) {
                case 91: {
                    s.append(this.getSubscripts());
                }
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    return s.toString();
                }
            }
            s.append((char)this.scanChar());
        }
    }

    protected String getSubscripts() throws IOException {
        StringBuffer s = new StringBuffer().append((char)this.scanChar());
        int leftBrackets = 1;
        block10: while (leftBrackets > 0) {
            int nextChar = this.scanAheadOneChar();
            switch (nextChar) {
                case 91: {
                    s.append((char)this.scanChar());
                    ++leftBrackets;
                    break;
                }
                case 93: {
                    s.append((char)this.scanChar());
                    if (leftBrackets <= 0) continue block10;
                    --leftBrackets;
                    break;
                }
                case -1: {
                    leftBrackets = 0;
                }
                case 45: {
                    block11: while (nextChar == 45) {
                        switch (this.scanAheadOneChar()) {
                            case 45: {
                                EGLPrimeToken commentToken = this.readSQLLineComment(nextChar, this.offset, this.line, this.column);
                                int commentLength = commentToken.getText().length();
                                int ii = 0;
                                while (ii < commentLength) {
                                    s.append(' ');
                                    ++ii;
                                }
                                continue block11;
                            }
                            default: {
                                s.append((char)this.scanChar());
                                break block11;
                            }
                        }
                    }
                }
                case 39: {
                    EGLPrimeToken quotedString = this.readEGLString(nextChar, this.offset, this.line, this.column);
                    s.append(quotedString.getText().toString());
                }
                default: {
                    s.append((char)this.scanChar());
                }
            }
        }
        return s.toString();
    }

    protected int scanAheadOneChar() throws IOException {
        int c = this.reader.read();
        if (c == -1) {
            return -1;
        }
        this.reader.unread(c);
        return c;
    }

    protected int scanAheadTwoChars() throws IOException {
        int c1 = this.reader.read();
        if (c1 == -1) {
            return -1;
        }
        int c2 = this.reader.read();
        if (c2 == -1) {
            this.reader.unread(c1);
            return -1;
        }
        this.reader.unread(c2);
        this.reader.unread(c1);
        return c2;
    }

    protected int scanChar() throws IOException {
        int c = this.reader.read();
        switch (c) {
            case -1: {
                return -1;
            }
            case 10: {
                if (!this.sawCR) {
                    ++this.line;
                    this.column = 0;
                }
                ++this.offset;
                this.sawCR = false;
                break;
            }
            case 13: {
                ++this.line;
                this.column = 0;
                ++this.offset;
                this.sawCR = true;
                break;
            }
            case 9: {
                ++this.column;
                ++this.offset;
                this.sawCR = false;
                break;
            }
            default: {
                ++this.column;
                ++this.offset;
                this.sawCR = false;
            }
        }
        return c;
    }

    protected int scanNonBlank() throws IOException {
        int c = this.scanChar();
        while (c <= 32 && c != -1) {
            c = this.scanChar();
        }
        return c;
    }

    public static final int keywordKind(String s) {
        Integer kind = (Integer)clauseKeywords.get(s.toLowerCase(Locale.ENGLISH));
        return kind == null ? -1 : kind;
    }
}

