/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.edt.compiler.internal.interfaces.IEGLMessageContributor;
import org.eclipse.edt.compiler.internal.interfaces.IEGLNestedMessageContributor;
import org.eclipse.edt.compiler.internal.interfaces.IEGLStatementNode;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;

public class EGLMessage
implements IGenerationResultsMessage {
    protected int severity = 0;
    private String id = null;
    private String[] params = null;
    private String groupName = null;
    private int startLineNumber = 0;
    private int endLineNumber = 0;
    private int endOffset = 0;
    private int startOffset = 0;
    private IEGLMessageContributor messageContributor;
    private int startColumnNumber = 0;
    private int endColumnNumber = 0;
    private String builtMessage;
    private static ResourceBundle messageBundle;
    private String partName;
    private static final MessageFormat formatter;
    public static final int EGL_ERROR_MESSAGE = 1;
    public static final int EGL_WARNING_MESSAGE = 2;
    public static final int EGL_INFORMATIONAL_MESSAGE = 3;
    public static final String EGLMESSAGE_GROUP_VALIDATION = "Validation";
    public static final String EGLMESSAGE_GROUP_DEPLOYMENT = "Deployment";
    public static final String EGLMESSAGE_GROUP_EDITOR = "Editor";
    public static final String EGLMESSAGE_GROUP_XML_VALIDATION = "XML Validation";
    public static final String EGLMESSAGE_GROUP_INPUT = "Batch Input";
    public static final String EGLMESSAGE_GROUP_STATEMENT_PARSER = "StatementParser";
    public static final String EGLMESSAGE_GROUP_DEBUGGER = "Debugger";
    public static final String EGLMESSAGE_VAG_MIGRATION = "VAGMigration";
    public static final String EGLMESSAGE_GROUP_SYNTAX = "Syntax";
    public static final String EGLMESSAGE_INVALID_NAME_LENGTH = "3001";
    public static final String EGLMESSAGE_INVALID_CHARACTER_IN_NAME = "3002";
    public static final String EGLMESSAGE_EZE_NOT_ALLOWED = "3003";
    public static final String EGLMESSAGE_DUPLICATE_PART_NAME = "3009";
    public static final String EGLMESSAGE_INVALID_IMPORT_STATEMENT = "3013";
    public static final String EGLMESSAGE_DUPLICATE_IMPORT_STATEMENT = "3014";
    public static final String EGLMESSAGE_RESERVED_WORD_NOT_ALLOWED = "3019";
    public static final String EGLMESSAGE_IMPORT_FILE_NOT_FOUND = "3020";
    public static final String EGLMESSAGE_IMPORT_FOLDER_NOT_FOUND = "3021";
    public static final String EGLMESSAGE_FILE_NAME_REQUIRED = "3023";
    public static final String EGLMESSAGE_PROGRAM_NAME_REQUIRED = "3024";
    public static final String EGLMESSAGE_SYMPARM_NAME_REQUIRED = "3025";
    public static final String EGLMESSAGE_INVALID_REMOTECOMTYPE_PARMFORM = "3026";
    public static final String EGLMESSAGE_DATABASE_NAME_REQUIRED = "3029";
    public static final String EGLMESSAGE_SERVER_NAME_REQUIRED = "3030";
    public static final String EGLMESSAGE_REMOTEPGMTYPE_NOTALLOWED = "3380";
    public static final String EGLMESSAGE_REMOTEPGMTYPE_REQUIRES_REMOTECOMTYPE = "3381";
    public static final String EGLMESSAGE_REMOTEPGMTYPE_REQUIRES_WEB_PROJ = "3382";
    public static final String EGLMESSAGE_TOO_MANY_PARMS = "3383";
    public static final String EGLMESSAGE_INPUT_INVALID_EXTENSION = "3896";
    public static final String EGLMESSAGE_INPUT_INVALID_ARGUMENT_COMBINATION = "3897";
    public static final String EGLMESSAGE_PROPERTY_FILE_LOAD_FAILED = "3898";
    public static final String EGLMESSAGE_ACTION_FACTORY_LOAD_FAILED = "3899";
    public static final String EGLMESSAGE_INPUT_UNKNOWN_OPTION = "3990";
    public static final String EGLMESSAGE_INPUT_FILE_WRONG_EXTENSION = "3991";
    public static final String EGLMESSAGE_ERROR_RETRIEVING_FILE_CONTENTS = "3992";
    public static final String EGLMESSAGE_INPUT_USAGE = "3993";
    public static final String EGLMESSAGE_INPUT_DUPLICATE_ARGUMENT = "3995";
    public static final String EGLMESSAGE_INPUT_NO_FILE_SPECIFIED = "3996";
    public static final String EGLMESSAGE_INPUT_FILE_NOT_FOUND = "3997";
    public static final String EGLMESSAGE_XML_VALIDATION_ERROR = "3998";
    public static final String EGLMESSAGE_XML_VALIDATION_ERROR_IN_FILE = "3999";
    public static final String EGLMESSAGE_EZEDEST_NOT_SUPPORTED_FOR_NON_IO_LOGICALFILE = "4103";
    public static final String EGLMESSAGE_VARIABLE_LENGTH_RECORD_NOT_SUPPORTED = "4104";
    public static final String EGLMESSAGE_FILE_NAME_INVALID = "4105";
    public static final String EGLMESSAGE_RECORDS_HAVE_DIFFERENT_TYPES = "4106";
    public static final String EGLMESSAGE_RECORDS_HAVE_DIFFERENT_KEYS = "4107";
    public static final String EGLMESSAGE_TEXT_AND_FLOAT_NOT_COMPAT = "4108";
    public static final String EGLMESSAGE_TRANSFER_TO_TRANSACTION_NOT_SUPPORTED_FOR_BATCH = "4109";
    public static final String EGLMESSAGE_FILE_RECORD_HAS_INVALID_LENGTH = "4110";
    public static final String EGLMESSAGE_TRANSFER_TO_EXTERNAL_PROGRAM_NOT_SUPPORTED = "4111";
    public static final String EGLMESSAGE_TRANSFER_TO_TRANSACTION_NOT_SUPPORTED = "4112";
    public static final String EGLMESSAGE_ANNOTATION_NOT_SUPPORTED = "4113";
    public static final String EGLMESSAGE_EZECONCT_CONNECT_RESET_NOT_SUPPORTED = "4114";
    public static final String EGLMESSAGE_EZECONCT_UOW_NOT_SUPPORTED = "4115";
    public static final String EGLMESSAGE_EZEDEST_NOT_SUPPORTED = "4116";
    public static final String EGLMESSAGE_EZEDESTP_NOT_SUPPORTED = "4117";
    public static final String EGLMESSAGE_EXPRESSION_AS_RETURN_NOT_SUPPORTED = "4119";
    public static final String EGLMESSAGE_SUBSTRING_TARGET_NOT_SUPPORTED = "4120";
    public static final String EGLMESSAGE_SUBSTRING_ARG_NOT_SUPPORTED = "4121";
    public static final String EGLMESSAGE_EXPRESSION_ARG_NOT_SUPPORTED = "4122";
    public static final String EGLMESSAGE_HEX_CONCATENATION_NOT_SUPPORTED = "4124";
    public static final String EGLMESSAGE_FUNCTION_IN_ARITHEMETIC_NOT_SUPPORTED = "4125";
    public static final String EGLMESSAGE_TIMESTAMP_FORMATS_MUST_MATCH = "4126";
    public static final String EGLMESSAGE_SECOND_ARG_MUST_BE_LITERAL = "4127";
    public static final String EGLMESSAGE_TYPE_NOT_SUPPORTED_FOR_WEBSERVICE = "4128";
    public static final String EGLMESSAGE_WEBSERVICE_PROTOCOL_REQUIRED = "4129";
    public static final String EGLMESSAGE_CONVERT_ARGUMENT_NOT_VALID = "4130";
    public static final String EGLMESSAGE_IN_OPERATOR_NOT_VALID = "4131";
    public static final String EGLMESSAGE_EGLSERVICE_PROGRAMCONTROLLED_NOT_ALLOWED = "4132";
    public static final String EGLMESSAGE_EGLSERVICE_INVOCATION_NOT_ALLOWED = "4133";
    public static final String EGLMESSAGE_LITERAL_NOT_SUPPORTED = "4134";
    public static final String EGLMESSAGE_DD_STATEFUL_JAVA400J2C_NOT_SUPPORTED = "4135";
    public static final String EGLMESSAGE_CALL_STATEFUL_JAVA400J2C_NOT_SUPPORTED = "4136";
    public static final String EGLMESSAGE_VARIABLE_LENGTH_SERIAL_RECORD_NOT_SUPPORTED = "4137";
    public static final String EGLMESSAGE_TYPE_NOT_SUPPORTED_FOR_RESTSERVICE = "4142";
    public static final String EGLMESSAGE_SET_STATEMENT_OPTION_NOT_VALID_FOR_TARGET = "4206";
    public static final String EGLMESSAGE_SET_NULL_NOT_ALLOWED = "4207";
    public static final String EGLMESSAGE_SET_STATEMENT_EXTENDEDHIGHLIGHTS_MUTUALLY_EXCLUSIVE = "4208";
    public static final String EGLMESSAGE_NULL_NOT_ALLOWED = "4209";
    public static final String EGLMESSAGE_LABEL_NOT_FOUND = "4210";
    public static final String EGLMESSAGE_GET_STATEMENT_DIRECTIVE_FILETYPE_RECORDTYPE_NOT_SUPPORTED_FOR_TARGETSYSTEM = "4215";
    public static final String EGLMESSAGE_GET_STATEMENT_REQUIRES_INTO = "4216";
    public static final String EGLMESSAGE_CONVERSE_IN_RECURSIVE_NOT_SUPPORTED = "4219";
    public static final String EGLMESSAGE_NO_INTO_ITEMS = "4220";
    public static final String EGLMESSAGE_FORUPDATE_INVALID_WITH_TERADATA = "4221";
    public static final String EGLMESSAGE_TOO_MANY_ARGS = "4222";
    public static final String EGLMESSAGE_STMT_NOT_VALID_IN_TYPEAHEADFUNCTION = "4223";
    public static final String EGLMESSAGE_DUPLICATE_RESULT_SET_ID_NOT_SUPPORTED_FOR_OPEN = "4224";
    public static final String EGLMESSAGE_INVALID_SCREENSIZE = "4225";
    public static final String EGLMESSAGE_ARG_MUST_BE_FIXED_LEN = "4226";
    public static final String EGLMESSAGE_STMT_NOT_VALID_IN_VALIDATOR = "4227";
    public static final String EGLMESSAGE_INVALID_HELPFORM_NAME = "4228";
    public static final String EGLMESSAGE_DLIIO_COMMANDCODE_NOT_SUPPORTED = "4229";
    public static final String EGLMESSAGE_PASSING_RECORD_CANNOT_BE_FLEXIBLE = "4231";
    public static final String EGLMESSAGE_SYSTEM_DATA_NOT_VALID_AS_ARG = "4232";
    public static final String EGLMESSAGE_SUBSCRIPT_MUST_BE_DATAREF_OR_LITERAL = "4233";
    public static final String EGLMESSAGE_REMOTE_PROGRAM_NOT_SUPPORTED = "4234";
    public static final String EGLMESSAGE_SYSTEM_FUNCTION_NOT_VALID_AS_ARG = "4235";
    public static final String EGLMESSAGE_MSG_TABLE_REFERENCE_NOT_SUPPORTED_ON_TARGET = "4236";
    public static final String EGLMESSAGE_SPECIAL_FUNCTION_NOT_SUPPORTED_ON_TARGET = "4237";
    public static final String EGLMESSAGE_GET_STATEMENT_DIRECTIVE_NOT_SUPPORTED_FOR_TARGETSYSTEM = "4238";
    public static final String EGLMESSAGE_CALL_STATEMENT_RECURSIVE_CALL = "4241";
    public static final String EGLMESSAGE_CALL_STATEMENT_INVALID_REMOTE_VARIABLE_LENGTH_RECORD_ARG = "4242";
    public static final String EGLMESSAGE_CALL_STATEMENT_PARMFORM_MUST_BE_COMMPTR = "4243";
    public static final String EGLMESSAGE_CALL_STATEMENT_INVALID_REMOTE_ARG_SIZE = "4244";
    public static final String EGLMESSAGE_CALL_STATEMENT_INVALID_COMMDATA_ARG_SIZE = "4245";
    public static final String EGLMESSAGE_CALL_STATEMENT_REMOTE_DUPLICATE_ARG = "4246";
    public static final String EGLMESSAGE_CALL_STATEMENT_COMMDATA_DUPLICATE_ARG = "4247";
    public static final String EGLMESSAGE_CALL_STATEMENT_REMOTE_DUPLICATE_REDEFINED_ARG = "4248";
    public static final String EGLMESSAGE_CALL_STATEMENT_COMMDATA_DUPLICATE_REDEFINED_ARG = "4249";
    public static final String EGLMESSAGE_DUPLICATE_RESULT_SET_ID_NOT_SUPPORTED = "4250";
    public static final String EGLMESSAGE_DUPLICATE_PREPARE_STATEMENT_ID_NOT_SUPPORTED = "4251";
    public static final String EGLMESSAGE_AUDIT_ARG_MUST_BE_ITEM = "4252";
    public static final String EGLMESSAGE_OPENUI_NOT_SUPPORTED = "4253";
    public static final String EGLMESSAGE_DLIIO_NOT_SUPPORTED = "4254";
    public static final String EGLMESSAGE_PSB_INVALID = "4255";
    public static final String EGLMESSAGE_AUDIT_REQUIRES_PSB = "4256";
    public static final String EGLMESSAGE_PASSING_RECORD_TOO_BIG = "4257";
    public static final String EGLMESSAGE_SHOW_FORM_XFER_EXTERNAL_NOT_SUPPORTED = "4258";
    public static final String EGLMESSAGE_SHOW_FORM_PASSING_REC_NOT_SUPPORTED = "4259";
    public static final String EGLMESSAGE_TABLE_TOO_BIG = "4260";
    public static final String EGLMESSAGE_DLI_ANNOTATION_REQUIRED = "4261";
    public static final String EGLMESSAGE_INPUTFORM_NOT_SUPPORTED = "4262";
    public static final String EGLMESSAGE_VGWEBTRANSPROGRAM_NOT_SUPPORTED = "4263";
    public static final String EGLMESSAGE_INVALID_DATA_IN_ROW1_COL1 = "4264";
    public static final String EGLMESSAGE_VAR_FIELD_IN_ROW1_COL1 = "4265";
    public static final String EGLMESSAGE_NO_SPACE_FOR_REQUIRED_FIELDS = "4266";
    public static final String EGLMESSAGE_STARTTRANS_ARG_TOO_BIG = "4267";
    public static final String EGLMESSAGE_CONVERSE_FLOAT_FORM_NOT_SUPPORTED = "4268";
    public static final String EGLMESSAGE_DISPLAY_TEXT_FORM_NOT_SUPPORTED = "4269";
    public static final String EGLMESSAGE_PSB_OR_PCB_PARM_REQUIRED = "4270";
    public static final String EGLMESSAGE_RECORD_TYPE_NOT_SUPPORTED = "4271";
    public static final String EGLMESSAGE_CALLED_TEXT_NOT_SUPPORTED = "4273";
    public static final String EGLMESSAGE_GET_NEXT_SERIAL_NOT_SUPPORTED = "4274";
    public static final String EGLMESSAGE_IO_VGUIREC_NOT_SUPPORTED = "4275";
    public static final String EGLMESSAGE_NUM_LEN_TOO_BIG = "4276";
    public static final String EGLMESSAGE_ARG_CANNOT_BE_NIUM_FOR_STRING_FUNCTION = "4277";
    public static final String EGLMESSAGE_NON_SEGMENTED_NOT_SUPPORTED = "4278";
    public static final String EGLMESSAGE_PARMS_NOT_SUPPORTED = "4279";
    public static final String EGLMESSAGE_LOCAL_STORAGE_NOT_SUPPORTED = "4280";
    public static final String EGLMESSAGE_NULLABLE_TYPE_NOT_SUPPORTED = "4281";
    public static final String EGLMESSAGE_STMT_NOT_SUPPORTED = "4282";
    public static final String EGLMESSAGE_NUMERIC_LEN_TOO_BIG = "4283";
    public static final String EGLMESSAGE_OPERATOR_NOT_SUPPORTED = "4284";
    public static final String EGLMESSAGE_DYNAMICACCESS_NOT_SUPPORTED = "4285";
    public static final String EGLMESSAGE_ELAWORK_PCB_REQUIRED = "4286";
    public static final String EGLMESSAGE_CANNOT_REFERENCE_TP_PCB = "4287";
    public static final String EGLMESSAGE_FOREACH_NOT_SUPPORTED = "4288";
    public static final String EGLMESSAGE_CALL_NOT_SUPPORTED = "4289";
    public static final String EGLMESSAGE_IS_NOT_INVALID = "4290";
    public static final String EGLMESSAGE_GSAM_PCB_REQUIRED = "4291";
    public static final String EGLMESSAGE_GET_PREVIOUS_INVALUD_FOR_SEQ_VASAM = "4292";
    public static final String EGLMESSAGE_UNDEFINED_PART = "4300";
    public static final String EGLMESSAGE_UNDEFINED_PART_FOR_TYPEDEF = "4301";
    public static final String EGLMESSAGE_SQLDATACODE_NOT_SUPPORTED = "4412";
    public static final String EGLMESSAGE_DEPLOYMENT_DESCRIPTOR_NOT_FOUND = "4413";
    public static final String EGLMESSAGE_DEPLOYMENT_DESCRIPTOR_REQUIRED = "4414";
    public static final String EGLMESSAGE_INVALID_MAXARRAYSIZE = "4415";
    public static final String EGLMESSAGE_FLEXIBLE_RECORD_NOT_SUPPORTED = "4416";
    public static final String EGLMESSAGE_SET_VALUE_BLOCKS_NOT_SUPPORTED = "4417";
    public static final String EGLMESSAGE_TYPE_NOT_SUPPORTED = "4418";
    public static final String EGLMESSAGE_MULTI_DIMENSION_ARRAY_NOT_SUPPORTED = "4419";
    public static final String EGLMESSAGE_NON_LOCAL_SQL_SCOPE_NOT_SUPPORTED = "4420";
    public static final String EGLMESSAGE_FORM_FIELD_TYPE_NOT_SUPPORTED = "4421";
    public static final String EGLMESSAGE_NATIVELIBRARY_NOT_SUPPORTED = "4422";
    public static final String EGLMESSAGE_ANY_COMPARISON_NOT_SUPPORTED = "4423";
    public static final String EGLMESSAGE_LITERAL_LEN_TOO_BIG = "4424";
    public static final String EGLMESSAGE_FUNCTION_PARM_CANNOT_DO_IO = "4425";
    public static final String EGLMESSAGE_FUNCTION_RETURN_TYPE_NOT_SUPPORTED = "4425";
    public static final String EGLMESSAGE_PARENS_FOR_SIGN_NOT_SUPPORTED = "4426";
    public static final String EGLMESSAGE_FORMATTING_PROPERTIES_FOR_CURRENCY_NOT_SUPPORTED = "4427";
    public static final String EGLMESSAGE_FUNCTION_OVERLOADING_NOT_SUPPORTED = "4429";
    public static final String EGLMESSAGE_NO_LABELS_IN_BLOCK = "4430";
    public static final String EGLMESSAGE_TOO_MANY_BYPASS_KEYS = "4431";
    public static final String EGLMESSAGE_FUNCTION_OVERLOADING_NOT_SUPPORTED_IN_WEB_SERVICE = "4432";
    public static final String EGLMESSAGE_STATEMENT_VALIDATION_FAILED = "4513";
    public static final String EGLMESSAGE_CLASS_LOCATION_REQUIRED = "4514";
    public static final String EGLMESSAGE_COULD_NOT_BUILD_DEFAULT_STATEMENT = "4515";
    public static final String EGLMESSAGE_CONNECT_TO_DATABASE_FAILED = "4526";
    public static final String EGLMESSAGE_CANNOT_DERIVE_INTO = "4527";
    public static final String EGLMESSAGE_COLUMN_NAME_NOT_FOUND = "4528";
    public static final String EGLMESSAGE_DUPLICATE_COLUMN_NAME_FOUND = "4529";
    public static final String EGLMESSAGE_IO_OBJECT_CONTAINS_NO_STRUCTURE_ITEMS = "4530";
    public static final String EGLMESSAGE_IO_OBJECT_CONTAINS_NO_READ_WRITE_COLUMNS = "4531";
    public static final String EGLMESSAGE_IO_OBJECT_IS_SQL_JOIN = "4532";
    public static final String EGLMESSAGE_IO_OBJECT_CONTAINS_ONLY_KEY_OR_READONLY_COLUMNS = "4533";
    public static final String EGLMESSAGE_IO_OBJECT_NOT_SQL_RECORD = "4534";
    public static final String EGLMESSAGE_CONNECTION_ERROR_ON_VALIDATE = "4537";
    public static final String EGLMESSAGE_IO_OBJECT_REQUIRED_FOR_SQLEXEC = "4538";
    public static final String EGLMESSAGE_COULD_NOT_BUILD_DEFAULT_STATEMENT_FOR_SQL_RECORD = "4540";
    public static final String EGLMESSAGE_SQL_RECORD_CONTAINS_NO_STRUCTURE_ITEMS = "4542";
    public static final String EGLMESSAGE_ERROR_CLASS_LOCATION_REQUIRED = "4580";
    public static final String EGLMESSAGE_ERROR_CONNECT_ERROR_ON_RETRIEVE = "4581";
    public static final String EGLMESSAGE_ERROR_TABLE_NOT_FOUND_ON_RETRIEVE = "4582";
    public static final String EGLMESSAGE_ERROR_TABLES_NOT_FOUND_ON_RETRIEVE = "4583";
    public static final String EGLMESSAGE_INFO_UNSUPPORTED_SQL_TYPE_ON_RETRIEVE = "4584";
    public static final String EGLMESSAGE_INFO_DECIMAL_LENGTH_SHORTENED_FROM_ON_RETRIEVE = "4585";
    public static final String EGLMESSAGE_INFO_DECIMAL_DECIMALS_SHORTENED_FROM_ON_RETRIEVE = "4586";
    public static final String EGLMESSAGE_INFO_HEX_LENGTH_SHORTENED_FROM_ON_RETRIEVE = "4587";
    public static final String EGLMESSAGE_INFO_HEX_LENGTH_SHORTENED_ON_RETRIEVE = "4588";
    public static final String EGLMESSAGE_INFO_INVALID_LENGTH_SET_TO_ZERO_ON_RETRIEVE = "4589";
    public static final String EGLMESSAGE_INFO_CHAR_LENGTH_SHORTENED_FROM_ON_RETRIEVE = "4590";
    public static final String EGLMESSAGE_INFO_DBCHAR_LENGTH_SHORTENED_FROM_ON_RETRIEVE = "4591";
    public static final String EGLMESSAGE_INFO_UNICODE_LENGTH_SHORTENED_FROM_ON_RETRIEVE = "4592";
    public static final String EGLMESSAGE_INFO_INVALID_DECIMALS_SET_TO_ZERO_ON_RETRIEVE = "4593";
    public static final String EGLMESSAGE_ERROR_NO_CONNECTION_OBJECT_SELECTED = "4594";
    public static final String EGLMESSAGE_INFO_UNSUPPORTED_TYPE_FOR_COBOL_ON_RETRIEVE = "4595";
    public static final String EGLMESSAGE_BD_PROJECTID_TOO_LONG = "4600";
    public static final String EGLMESSAGE_BD_INVALID_TWAOFFSET = "4601";
    public static final String EGLMESSAGE_BD_INVALID_PACKAGE = "4602";
    public static final String EGLMESSAGE_BD_DUPLICATE_SYMPARM = "4603";
    public static final String EGLMESSAGE_BD_INVALID_DESTPORT = "4604";
    public static final String EGLMESSAGE_BD_SELF_REFERENCING = "4605";
    public static final String EGLMESSAGE_BD_INTEGER_VALUE_INVALID = "4606";
    public static final String EGLMESSAGE_BD_DECIMAL_SYMBOL_TOO_BIG = "4607";
    public static final String EGLMESSAGE_BD_GENDIR_MUST_BE_ABSOLUTE = "4608";
    public static final String EGLMESSAGE_BD_DBMS_NOT_VALID = "4609";
    public static final String EGLMESSAGE_BD_REQUIRED_VALUE_MISSING = "4610";
    public static final String EGLMESSAGE_BD_RESERVEDWORD_FILE_ERROR = "4611";
    public static final String EGLMESSAGE_SYMPARM_KEY_MISSING = "4612";
    public static final String EGLMESSAGE_BD_GENPROJECT_NOT_ALLOWED = "4613";
    public static final String EGLMESSAGE_BD_NOT_FOUND = "4614";
    public static final String EGLMESSAGE_PROJECT_NOT_FOUND = "4615";
    public static final String EGLMESSAGE_TERADATA_NOT_ACTIVE = "4616";
    public static final String EGLMESSAGE_BD_GENPROJECT_INVALID = "4617";
    public static final String EGLMESSAGE_BD_SYSTEM_NOT_ENABLED = "4618";
    public static final String EGLMESSAGE_BD_GENDIRECTORY_OR_GENPROJECT_NEEDED = "4619";
    public static final String EGLMESSAGE_BD_BOTH_GENDIRECTORY_AND_GENPROJECT_NOT_ALLOWED = "4620";
    public static final String EGLMESSAGE_BD_LONG_GREGORIAN_MASK_INVALID = "4621";
    public static final String EGLMESSAGE_BD_LONG_JULIAN_MASK_INVALID = "4622";
    public static final String EGLMESSAGE_BD_SHORT_GREGORIAN_MASK_INVALID = "4623";
    public static final String EGLMESSAGE_BD_SHORT_JULIAN_MASK_INVALID = "4624";
    public static final String EGLMESSAGE_BD_GEN_PROJECT_MUST_BE_EGLWEB = "4625";
    public static final String EGLMESSAGE_BD_GEN_PROJECT_MUST_BE_JAVA = "4626";
    public static final String EGLMESSAGE_GEN_PROJECT_OVERRIDDEN = "4627";
    public static final String EGLMESSAGE_WORKSPACE_REQUIRED = "4628";
    public static final String EGLMESSAGE_GEN_PROJECT_OVERRIDDEN_FOR_TARGETSYSETM = "4629";
    public static final String EGLMESSAGE_RA_DUPLICATE_SYSTEM = "4700";
    public static final String EGLMESSAGE_RA_DUPLICATE_ASSOCIATION = "4701";
    public static final String EGLMESSAGE_FILE_TYPE_NOT_SUPPORTED = "4702";
    public static final String EGLMESSAGE_INCORRECT_FILE_TYPE_FOR_RECORD_ORGANIZATION = "4704";
    public static final String EGLMESSAGE_INVALID_BLOCKSIZE = "4705";
    public static final String EGLMESSAGE_INVALID_BLOCKSIZE_OPTION = "4706";
    public static final String EGLMESSAGE_INVALID_BLOCKSIZE_INT = "4707";
    public static final String EGLMESSAGE_INVALID_BLOCKSIZE_INT1_GT_INT2 = "4708";
    public static final String EGLMESSAGE_INVALID_SYSTEMNUMBER = "4709";
    public static final String EGLMESSAGE_LO_DUPLICATE_CALLLINK = "4800";
    public static final String EGLMESSAGE_LO_DUPLICATE_FILELINK = "4801";
    public static final String EGLMESSAGE_LO_INVALID_PACKAGE = "4802";
    public static final String EGLMESSAGE_LO_INVALID_PROVIDERURL = "4803";
    public static final String EGLMESSAGE_LO_REDUNDANT_SERVERID = "4804";
    public static final String EGLMESSAGE_LO_CALLLINK_MUST_BE_REMOTE_OR_EJB = "4805";
    public static final String EGLMESSAGE_LO_INVALID_PARMFORM = "4806";
    public static final String EGLMESSAGE_LO_INVALID_LINKTYPE = "4807";
    public static final String EGLMESSAGE_LO_DUPLICATE_ASYNCHLINK = "4808";
    public static final String EGLMESSAGE_LO_INVALID_WRAPPERPACKAGENAME = "4809";
    public static final String EGLMESSAGE_PARMFORM_INVALID_FOR_PROCEDURE = "4810";
    public static final String EGLMESSAGE_LO_INVALID_REMOTECOMTYPE = "4811";
    public static final String EGLMESSAGE_PART_GENERATION_NOT_SUPPORTED = "4900";
    public static final String EGLMESSAGE_PAGEHANDLERS_NOT_SUPPORTED = "4903";
    public static final String EGLMESSAGE_J2EELEVEL_NOT_VALID = "4905";
    public static final String EGLMESSAGE_PART_NAME_RESERVED = "4906";
    public static final String EGLMESSAGE_MSGTABLE_NOT_FOUND = "4907";
    public static final String EGLMESSAGE_LIBRARIES_NOT_SUPPORTED = "4908";
    public static final String EGLMESSAGE_TEXTUIPROGRAM_NOT_SUPPORTED = "4909";
    public static final String EGLMESSAGE_HANDLERS_NOT_SUPPORTED = "4910";
    public static final String EGLMESSAGE_PART_NOT_SUPPORTED = "4911";
    public static final String EGLMESSAGE_ACTION_PART_NAME_NOT_VALID = "4918";
    public static final String EGLMESSAGE_ACTION_PART_ALIAS_NOT_VALID = "4919";
    public static final String EGLMESSAGE_WEBTRANS_MSGTABLE_INVALID = "5005";
    public static final String EGLMESSAGE_TUI_MSGTABLE_INVALID = "5006";
    public static final String EGLMESSAGE_VARIABLE_FIELD_ATTRIB_NOT_SUPPORTED = "5250";
    public static final String EGLMESSAGE_CONSTANT_FIELD_ATTRIB_NOT_SUPPORTED = "5251";
    public static final String EGLMESSAGE_VALID_VALUES_NOT_SUPPORTED_FOR_NO_NUMERIC = "5253";
    public static final String EGLMESSAGE_FORM_FORMAT_MODULE_OVERFLOW = "5257";
    public static final String EGLMESSAGE_FORMGROUP_FORMAT_MODULE_OVERFLOW = "5258";
    public static final String EGLMESSAGE_FORM_NAME_IS_DUPLICATE = "5550";
    public static final String EGLMESSAGE_BIN18_NOT_SUPPORTED = "5555";
    public static final String EGLMESSAGE_INDEX_TOO_SMALL = "5800";
    public static final String EGLMESSAGE_INDEX_TOO_LARGE = "5801";
    public static final String EGLMESSAGE_START_MUST_BE_SMALLER_THAN_END = "5802";
    public static final String EGL_WEB_SERVICES_INVALID_OPERATION_NAME = "6000";
    public static final String EGL_WEB_SERVICES_INVALID_PROGRAM_PATH = "6001";
    public static final String EGL_WEB_SERVICES_DUPLICATE_OPERATION_NAME = "6002";
    public static final String EGL_WEB_SERVICES_NO_OPERATION = "6003";
    public static final String EGL_WEB_SERVICES_INVALID_WEB_SERVICE_NAME = "6004";
    public static final String EGL_WEB_SERVICES_NAME_MUST_EQUAL_FILE_NAME = "6005";
    public static final String EGL_WEB_SERVICES_OPERATION_AND_PROGRAM_PATH_REQUIRED = "6006";
    public static final String EGL_WEB_SERVICES_OPERATION_NAME_MUST_NOT_EQUAL_FILE_NAME = "6007";
    public static final String EGL_WEB_SERVICES_NAME_CANNOT_BE_JAVA_KEYWORD = "6008";
    public static final String EGL_WEB_SERVICES_OPERATION_NAME_CANNOT_BE_JAVA_KEYWORD = "6009";
    public static final String EGL_WEB_SERVICES_PARAMTER_MISSING_FROM_PROGRAM = "6010";
    public static final String EGL_WEB_SERVICES_PARAMTER_MISSING_FROM_OPERATION = "6011";
    public static final String EGL_WEB_SERVICES_PROGRAM_MUST_BE_CALLED_BATCH = "6012";
    public static final String EGL_WEB_SERVICES_PARAMTER_NAME_MISMATCH = "6013";
    public static final String EGL_WEB_SERVICES_OPERATION_NAME_MISSING_FROM_WSDL = "6014";
    public static final String EGL_WEB_SERVICES_PORT_NAME_MISSING_FROM_WSDL = "6015";
    public static final String EGL_WEB_SERVICES_PARAMETER_TYPE_MISMATCH = "6016";
    public static final String EGL_WEB_SERVICES_WSDL_EGL_RECORD_MISMATCH = "6017";
    public static final String OPENUI_TARGETTYPE = "7700";
    public static final String OPENUI_MUST_BE_CONSOLEFIELD = "7701";
    public static final String OPENUI_BIND_NOT_ALLOWED = "7702";
    public static final String OPENUI_BIND_EXACTLY_ONE = "7703";
    public static final String OPENUI_BIND_TOO_MANY = "7704";
    public static final String OPENUI_BIND_MUST_BE_TEXT = "7705";
    public static final String OPENUI_BIND_READ_ONLY = "7706";
    public static final String OPENUI_EVENTTYPE_INVALID = "7707";
    public static final String OPENUI_EVENTARG_NOT_ALLOWED = "7708";
    public static final String OPENUI_EVENTARG_REQUIRED = "7709";
    public static final String PARMS_NOT_VALID_FOR_WEBTRANS = "7771";
    public static final String EGLMESSAGE_BIDI_CONVERSION_TABLE_ERROR = "8000";
    public static final String EGLMESSAGE_OUTPUT_DIRECTORY_ERROR = "8001";
    public static final String EGLMESSAGE_WRAPPER_NAME_CONFLICT_ERROR = "8002";
    public static final String EGLMESSAGE_RESOURCE_UPDATE_ERROR = "8003";
    public static final String EGLMESSAGE_FILE_NAME_CONFLICT_ERROR = "8004";
    public static final String EGLMESSAGE_UNSUPPORTED_ELEMENT = "8005";
    public static final String EGLMESSAGE_UNSUPPORTED_DATA_TYPE = "8006";
    public static final String EGLMESSAGE_UNSUPPORTED_SERVICE_BINDING_TYPE = "8007";
    public static final String EGLMESSAGE_UNSUPPORTED_DEPLOYMENT_DESCRIPTOR_TARGET = "8008";
    public static final String EGLMESSAGE_TEMPLATE_DIRECTORY_NOT_SPECIFIED = "8010";
    public static final String EGLMESSAGE_TEMPLATE_DIRECTORY_NOT_FOUND = "8011";
    public static final String EGLMESSAGE_BUILD_SUCCEEDED = "8150";
    public static final String EGLMESSAGE_BUILDPLAN_CREATED = "8151";
    public static final String EGL_DEPLOYMENT_FAILED_DOT_LOCATE_EXCEPTION = "8300";
    public static final String EGL_DEPLOYMENT_DEPLOYING_WITH_BUILDDESCRIPTOR = "8302";
    public static final String EGL_DEPLOYMENT_DEPLOYING_RUIHANDLER = "8303";
    public static final String EGL_DEPLOYMENT_COMPLETE = "8304";
    public static final String EGL_DEPLOYMENT_FAILED = "8305";
    public static final String EGL_DEPLOYMENT_EXCEPTION = "8306";
    public static final String EGL_DEPLOYMENT_FAILED_CREATE_NLS_FILE = "8307";
    public static final String EGL_DEPLOYMENT_FAILED_LOCATE_NLS_FILE = "8308";
    public static final String EGL_DEPLOYMENT_FAILED_CREATE_BIND_FILE = "8309";
    public static final String EGL_DEPLOYMENT_FAILED_LOCATE_EGLDD_FILE = "8310";
    public static final String EGL_DEPLOYMENT_FAILED_LOCATE_CHILD_DOT_DEPLOY_FILES = "8311";
    public static final String EGL_DEPLOYMENT_FAILED_CREATE_HTML_FILE = "8312";
    public static final String EGL_DEPLOYMENT_FAILED_CREATE_RT_PROPS_FILE = "8313";
    public static final String EGL_DEPLOYMENT_DEPLOYED_PROPERTY_FILE = "8314";
    public static final String EGL_DEPLOYMENT_FAILED_DEPLOY_PROPERTY_FILE = "8315";
    public static final String EGL_DEPLOYMENT_DEPLOYED_BIND_FILE = "8316";
    public static final String EGL_DEPLOYMENT_FAILED_DEPLOY_BIND_FILE = "8317";
    public static final String EGL_DEPLOYMENT_FAILED_DEPLOY_RT_PROPERTY_FILE = "8318";
    public static final String EGL_DEPLOYMENT_DEPLOYED_RT_PROPERTY_FILE = "8319";
    public static final String EGL_DEPLOYMENT_DEPLOYED_HTML_FILE = "8320";
    public static final String EGL_DEPLOYMENT_FAILED_DEPLOY_HTML_FILE = "8321";
    public static final String EGL_DEPLOYMENT_DEPLOYED_RT_MSG_BUNDLE = "8322";
    public static final String EGL_DEPLOYMENT_FAILED_DEPLOY_RT_MSG_BUNDLE = "8323";
    public static final String EGL_DEPLOYMENT_FAILED_CREATE_RT_MSG_BUNDLE_FOLDER = "8324";
    public static final String EGL_DEPLOYMENT_FAILED_CREATE_PROPERTIES_FOLDER = "8325";
    public static final String EGL_DEPLOYMENT_LOCALE_PROCESSING_FAILED = "8326";
    public static final String EGL_DEPLOYMENT_MISSING_IMPORT_EXCEPTION = "8327";
    public static final String EGL_DEPLOYMENT_FAILED_FIND_NLS_FILES = "8328";
    public static final String EGL_DEPLOYMENT_CREATED_RESOURCE_REFS = "8329";
    public static final String EGL_DEPLOYMENT_FAILED_DEFINE_DATASOURCE = "8330";
    public static final String EGL_DEPLOYMENT_FAILED_WRITE_CONTEXTDOTXML = "8331";
    public static final String EGL_DEPLOYMENT_DEFINED_DATASOURCES = "8332";
    public static final String EGL_DEPLOYMENT_SERVER_NOT_TOMCAT = "8333";
    public static final String EGLMESSAGE_GENERATABLE_NOT_FOUND = "9000";
    public static final String EGLMESSAGE_PARTNOTFOUND = "9001";
    public static final String EGLMESSAGE_INVALIDPARTTYPE = "9002";
    public static final String EGLMESSAGE_NOSUCHMEMBER = "9003";
    public static final String EGLMESSAGE_CONSTANT_POOL_TOO_BIG = "9980";
    public static final String EGLMESSAGE_NOT_AN_IR = "9981";
    public static final String EGLMESSAGE_INCOMPATIBLE_VERSION = "9982";
    public static final String EGLMESSAGE_UNKNOWN_OBJECT = "9983";
    public static final String EGLMESSAGE_UNKNOWN_OBJECT_IN_POOL = "9984";
    public static final String EGLMESSAGE_CONSTANT_POOL_INDEX_OUT_OF_RANGE = "9985";
    public static final String EGLMESSAGE_SYSTEM_PART_NOT_GENABLE = "9987";
    public static final String EGLMESSAGE_GENERATION_CANCELED = "9988";
    public static final String EGLMESSAGE_EMPTY_MESSAGE = "9989";
    public static final String EGLMESSAGE_VALIDATION_COMPLETE = "9990";
    public static final String EGLMESSAGE_COMPILE_ERRORS = "9991";
    public static final String EGLMESSAGE_COMPILE_ERRORS_IN_SUBPART = "9992";
    public static final String EGLMESSAGE_GENERATION_ALREADY_OCCURRED = "9993";
    public static final String EGLMESSAGE_GENERATION_PROGRAM_RESULTS_VIEW_MESSAGE = "9994";
    public static final String EGLMESSAGE_BUILD_ERROR = "9995";
    public static final String EGLMESSAGE_GENERATION_COMPLETE = "9996";
    public static final String EGLMESSAGE_GENERATION_FAILED = "9997";
    public static final String EGLMESSAGE_EXCEPTION_MESSAGE = "9998";
    public static final String EGLMESSAGE_EXCEPTION_STACKTRACE = "9999";

    static {
        formatter = new MessageFormat("");
    }

    public String getPartName() {
        return this.partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public EGLMessage(String aBundleName, int aSeverity, String anId, String groupName, Object messageContributor, String[] aParams, int aStartOffset, int anEndOffset) {
        this(ResourceBundle.getBundle(aBundleName, Locale.getDefault()), aSeverity, anId, groupName, messageContributor, aParams, aStartOffset, anEndOffset);
    }

    public EGLMessage(String aBundleName, int aSeverity, String anId, String groupName, Object messageContributor, String[] aParams, int aStartLine, int aStartColumn, int anEndLine, int anEndColumn) {
        this(ResourceBundle.getBundle(aBundleName, Locale.getDefault()), aSeverity, anId, groupName, messageContributor, aParams, aStartLine, aStartColumn, anEndLine, anEndColumn);
    }

    public EGLMessage() {
    }

    public EGLMessage(ResourceBundle bundle, int aSeverity, String anId, String groupName, String[] aParams) {
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.setGroupName(groupName);
        messageBundle = bundle;
        this.builtMessage = EGLMessage.buildMessageText(anId, aParams);
    }

    public EGLMessage(ResourceBundle aBundle, int aSeverity, String anId, String groupName, Object aMessageContributor, String[] aParams, int aStartOffset, int anEndOffset) {
        messageBundle = aBundle;
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.setGroupName(groupName);
        this.setStartOffset(aStartOffset);
        this.setEndOffset(anEndOffset);
        this.builtMessage = EGLMessage.buildMessageText(anId, aParams);
        if (aMessageContributor != null && aMessageContributor instanceof IEGLMessageContributor) {
            IEGLMessageContributor mc = (IEGLMessageContributor)aMessageContributor;
            this.setMessageContributor(mc);
            if (aStartOffset == -1 && mc.getStart() != null) {
                this.setStartLine(mc.getStart().getLine());
                this.setStartColumn(mc.getStart().getColumn());
                this.setStartOffset(mc.getStart().getOffset());
            }
            if (anEndOffset == -1 && mc.getEnd() != null) {
                this.setEndLine(mc.getEnd().getLine());
                this.setEndColumn(mc.getEnd().getColumn());
                this.setEndOffset(mc.getEnd().getOffset() + 1);
            }
        }
    }

    public EGLMessage(ResourceBundle aBundle, int aSeverity, String anId, String groupName, Object aMessageContributor, String[] aParams, int aStartLine, int aStartColumn, int anEndLine, int anEndColumn) {
        int aStartOffset = 0;
        int anEndOffset = 0;
        messageBundle = aBundle;
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.setGroupName(groupName);
        this.builtMessage = EGLMessage.buildMessageText(anId, aParams);
        if (aMessageContributor != null && aMessageContributor instanceof IEGLMessageContributor) {
            IEGLMessageContributor mc = (IEGLMessageContributor)aMessageContributor;
            this.setMessageContributor(mc);
            if (aStartLine == -1 && mc.getStart() != null) {
                aStartLine = mc.getStart().getLine();
                aStartColumn = mc.getStart().getColumn();
                aStartOffset = mc.getStart().getOffset();
            }
            if (anEndLine == -1 && mc.getEnd() != null) {
                anEndLine = mc.getEnd().getLine();
                anEndColumn = mc.getEnd().getColumn();
                anEndOffset = mc.getEnd().getOffset() + 1;
            }
        }
        this.setStartLine(aStartLine);
        this.setStartColumn(aStartColumn);
        this.setEndLine(anEndLine);
        this.setEndColumn(anEndColumn);
        this.setStartOffset(aStartOffset);
        this.setEndOffset(anEndOffset);
    }

    public EGLMessage(String aBundle, int aSeverity, String anId, String groupName, Object aMessageContributor, String[] aParams, int aStartLine, int aStartColumn, int aStartOffset, int anEndLine, int anEndColumn, int anEndOffset) {
        messageBundle = ResourceBundle.getBundle(aBundle, Locale.getDefault());
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.setGroupName(groupName);
        this.builtMessage = EGLMessage.buildMessageText(anId, aParams);
        if (aMessageContributor != null && aMessageContributor instanceof IEGLMessageContributor) {
            IEGLMessageContributor mc = (IEGLMessageContributor)aMessageContributor;
            this.setMessageContributor(mc);
            if (aStartLine == -1 && mc.getStart() != null) {
                aStartLine = mc.getStart().getLine();
                aStartColumn = mc.getStart().getColumn();
                aStartOffset = mc.getStart().getOffset();
            }
            if (anEndLine == -1 && mc.getEnd() != null) {
                anEndLine = mc.getEnd().getLine();
                anEndColumn = mc.getEnd().getColumn();
                anEndOffset = mc.getEnd().getOffset() + 1;
            }
        }
        this.setStartLine(aStartLine);
        this.setStartColumn(aStartColumn);
        this.setEndLine(anEndLine);
        this.setEndColumn(anEndColumn);
        this.setStartOffset(aStartOffset);
        this.setEndOffset(anEndOffset);
    }

    public static String buildMessageText(String key, Object[] inserts) {
        try {
            String message = messageBundle.getString(key);
            if (message == null || inserts == null || inserts.length == 0) {
                return message;
            }
            formatter.applyPattern(message);
            return formatter.format(EGLMessage.insertsWithoutNulls(inserts));
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static Object[] insertsWithoutNulls(Object[] originalInserts) {
        int numberInserts = originalInserts.length;
        Object[] newInserts = new Object[numberInserts];
        int i = 0;
        while (i < numberInserts) {
            newInserts[i] = originalInserts[i] != null ? originalInserts[i] : "";
            ++i;
        }
        return newInserts;
    }

    public static EGLMessage createEGLEditorErrorMessage(ResourceBundle resource, String messageID) {
        return new EGLMessage(resource, 1, messageID, EGLMESSAGE_GROUP_EDITOR, new String[1]);
    }

    public static EGLMessage createEGLEditorErrorMessage(ResourceBundle resource, String messageID, String[] inserts) {
        return new EGLMessage(resource, 1, messageID, EGLMESSAGE_GROUP_EDITOR, inserts);
    }

    public static EGLMessage createEGLEditorErrorMessage(ResourceBundle resource, String messageID, String insert) {
        return new EGLMessage(resource, 1, messageID, EGLMESSAGE_GROUP_EDITOR, new String[]{insert});
    }

    public static EGLMessage createEGLEditorInformationalMessage(ResourceBundle resource, String messageID) {
        return new EGLMessage(resource, 3, messageID, EGLMESSAGE_GROUP_EDITOR, new String[1]);
    }

    public static EGLMessage createEGLEditorInformationalMessage(ResourceBundle resource, String messageID, String insert) {
        return new EGLMessage(resource, 3, messageID, EGLMESSAGE_GROUP_EDITOR, new String[]{insert});
    }

    public static EGLMessage createEGLEditorInformationalMessage(ResourceBundle resource, String messageID, String[] inserts) {
        return new EGLMessage(resource, 3, messageID, EGLMESSAGE_GROUP_EDITOR, inserts);
    }

    public static EGLMessage createEGLEditorWarningMessage(ResourceBundle resource, String messageID) {
        return new EGLMessage(resource, 2, messageID, EGLMESSAGE_GROUP_EDITOR, new String[1]);
    }

    public static EGLMessage createEGLEditorWarningMessage(ResourceBundle resource, String messageID, String[] inserts) {
        return new EGLMessage(resource, 2, messageID, EGLMESSAGE_GROUP_EDITOR, inserts);
    }

    public static EGLMessage createEGLInputErrorMessage(String messageID, String[] inserts) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_INPUT, null, inserts, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLInputErrorMessage(String messageID, String insert) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_INPUT, null, new String[]{insert}, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLDebuggerErrorMessage(ResourceBundle resource, String messageID) {
        return new EGLMessage(resource, 1, messageID, EGLMESSAGE_GROUP_DEBUGGER, new String[1]);
    }

    public static EGLMessage createEGLDebuggerErrorMessage(ResourceBundle resource, String messageID, String[] inserts) {
        return new EGLMessage(resource, 1, messageID, EGLMESSAGE_GROUP_DEBUGGER, inserts);
    }

    public static EGLMessage createEGLDebuggerErrorMessage(ResourceBundle resource, String messageID, String insert) {
        return new EGLMessage(resource, 1, messageID, EGLMESSAGE_GROUP_DEBUGGER, new String[]{insert});
    }

    public static EGLMessage createEGLDebuggerWarningMessage(ResourceBundle resource, String messageID) {
        return new EGLMessage(resource, 2, messageID, EGLMESSAGE_GROUP_DEBUGGER, new String[1]);
    }

    public static EGLMessage createEGLDebuggerWarningMessage(ResourceBundle resource, String messageID, String[] inserts) {
        return new EGLMessage(resource, 2, messageID, EGLMESSAGE_GROUP_DEBUGGER, inserts);
    }

    public static EGLMessage createEGLDebuggerWarningMessage(ResourceBundle resource, String messageID, String insert) {
        return new EGLMessage(resource, 2, messageID, EGLMESSAGE_GROUP_DEBUGGER, new String[]{insert});
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[1], -1, -1, -1, -1);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String[] inserts) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLDeploymentErrorMessage(String messageID, Object messageContributor, String[] inserts) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_DEPLOYMENT, messageContributor, inserts, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLDeploymentInformationalMessage(String messageID, Object messageContributor, String[] inserts) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 3, messageID, EGLMESSAGE_GROUP_DEPLOYMENT, messageContributor, inserts, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String[] inserts, int aStartLine, int aStartColumn) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, aStartLine, aStartColumn, -1, -1);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String[] inserts, int aStartLine, int aStartColumn, int anEndLine, int anEndColumn) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, aStartLine, aStartColumn, anEndLine, anEndColumn);
    }

    public static EGLMessage createEGLValidationPartErrorMessage(ResourceBundle resource, String messageID, Object messageContributor, String[] inserts, int aStartLine, int aStartColumn, int anEndLine, int anEndColumn) {
        return new EGLMessage(resource, 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, aStartLine, aStartColumn, anEndLine, anEndColumn);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String[] inserts, IEGLStatementNode node) {
        EGLMessage message = new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, node.getStartLine(), node.getStartColumn(), node.getEndLine(), node.getEndColumn());
        message.setStartOffset(node.getStartOffset());
        message.setEndOffset(node.getEndOffset() + 1);
        return message;
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String insert) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[]{insert}, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String insert, int aStartOffset, int anEndOffset) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[]{insert}, aStartOffset, anEndOffset);
    }

    public static EGLMessage createEGLValidationErrorMessage(String bundleName, String messageID, String[] inserts, int aStartOffset, int anEndOffset) {
        Object messageContributor = null;
        return new EGLMessage(bundleName, 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, aStartOffset, anEndOffset);
    }

    public static EGLMessage createEGLValidationErrorMessage(String messageID, Object messageContributor, String insert, int aStartLine, int aStartColumn, int anEndLine, int anEndColumn) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[]{insert}, aStartLine, aStartColumn, anEndLine, anEndColumn);
    }

    public static EGLMessage createEGLValidationInformationalMessage(String messageID, Object messageContributor) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 3, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[1], 1, 1, -1, -1);
    }

    public static EGLMessage createEGLValidationInformationalMessage(String messageID, Object messageContributor, String[] inserts) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 3, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, 1, 1, -1, -1);
    }

    public static EGLMessage createEGLValidationInformationalMessage(String messageID, Object messageContributor, String insert) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 3, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[]{insert}, 1, 1, -1, -1);
    }

    public static EGLMessage createEGLValidationWarningMessage(String bundleName, String messageID, String[] inserts, int aStartOffset, int anEndOffset) {
        Object messageContributor = null;
        return new EGLMessage(bundleName, 2, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, aStartOffset, anEndOffset);
    }

    public static EGLMessage createEGLValidationWarningMessage(String messageID, Object messageContributor) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 2, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[1], -1, -1, -1, -1);
    }

    public static EGLMessage createEGLValidationWarningMessage(String messageID, Object messageContributor, String[] inserts) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 2, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, inserts, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLValidationWarningMessage(String messageID, Object messageContributor, String insert) {
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 2, messageID, EGLMESSAGE_GROUP_VALIDATION, messageContributor, new String[]{insert}, -1, -1, -1, -1);
    }

    public static EGLMessage createEGLSytaxErrorMessage(String bundleName, String messageID, String[] inserts, int aStartOffset, int anEndOffset) {
        Object messageContributor = null;
        return new EGLMessage(bundleName, 1, messageID, EGLMESSAGE_GROUP_SYNTAX, messageContributor, inserts, aStartOffset, anEndOffset);
    }

    public static EGLMessage createEGLSyntaxWarningMessage(String bundleName, String messageID, String[] inserts, int aStartOffset, int anEndOffset) {
        Object messageContributor = null;
        return new EGLMessage(bundleName, 2, messageID, EGLMESSAGE_GROUP_SYNTAX, messageContributor, inserts, aStartOffset, anEndOffset);
    }

    public static EGLMessage createEGLXMLValidationErrorMessage(String messageString, String fileName, int lineNumber, int columnNumber, Object messageContributor) {
        String[] messageInserts;
        String messageNumber;
        if (fileName == null) {
            messageNumber = EGLMESSAGE_XML_VALIDATION_ERROR;
            messageInserts = new String[]{messageString};
        } else {
            messageNumber = EGLMESSAGE_XML_VALIDATION_ERROR_IN_FILE;
            messageInserts = new String[]{messageString, fileName};
        }
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 1, messageNumber, EGLMESSAGE_GROUP_XML_VALIDATION, messageContributor, messageInserts, lineNumber, columnNumber, lineNumber, columnNumber);
    }

    public static EGLMessage createEGLXMLValidationWarningMessage(String messageString, String fileName, int lineNumber, int columnNumber, Object messageContributor) {
        String[] messageInserts;
        String messageNumber;
        if (fileName == null) {
            messageNumber = EGLMESSAGE_XML_VALIDATION_ERROR;
            messageInserts = new String[]{messageString};
        } else {
            messageNumber = EGLMESSAGE_XML_VALIDATION_ERROR_IN_FILE;
            messageInserts = new String[]{messageString, fileName};
        }
        return new EGLMessage(EGLMessage.getValidationResourceBundleName(), 2, messageNumber, EGLMESSAGE_GROUP_XML_VALIDATION, messageContributor, messageInserts, lineNumber, columnNumber, lineNumber, columnNumber);
    }

    @Override
    public String getBuiltMessage() {
        String flag = " ";
        switch (this.getSeverity()) {
            case 1: {
                flag = "e";
                break;
            }
            case 2: {
                flag = "w";
                break;
            }
            case 3: {
                flag = "i";
            }
        }
        return "IWN." + this.getMessagePrefix() + "." + this.id + "." + flag + " " + this.startLineNumber + "/" + this.startColumnNumber + " " + this.builtMessage;
    }

    public String getBuiltMessageWithoutLineAndColumn() {
        String flag = " ";
        switch (this.getSeverity()) {
            case 1: {
                flag = "e";
                break;
            }
            case 2: {
                flag = "w";
                break;
            }
            case 3: {
                flag = "i";
            }
        }
        return "IWN." + this.getMessagePrefix() + "." + this.id + "." + flag + " " + this.builtMessage;
    }

    @Override
    public String getBuiltMessageWithLineAndColumn() {
        String flag = " ";
        switch (this.getSeverity()) {
            case 1: {
                flag = "e";
                break;
            }
            case 2: {
                flag = "w";
                break;
            }
            case 3: {
                flag = "i";
            }
        }
        if (this.messageContributor instanceof IEGLMessageContributor && this.messageContributor.getResourceName() != null) {
            return "IWN." + this.getMessagePrefix() + "." + this.id + "." + flag + " - " + this.messageContributor.getResourceName() + " - " + this.startLineNumber + "/" + this.startColumnNumber + " - " + this.builtMessage;
        }
        return "IWN." + this.getMessagePrefix() + "." + this.id + "." + flag + " - " + this.startLineNumber + "/" + this.startColumnNumber + " - " + this.builtMessage;
    }

    public int getEndColumn() {
        return this.endColumnNumber;
    }

    public int getEndLine() {
        return this.endLineNumber;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean isSyntaxMessage() {
        return this.groupName.equals(EGLMESSAGE_GROUP_SYNTAX);
    }

    public String getMessagePrefix() {
        if (this.groupName.equals(EGLMESSAGE_GROUP_VALIDATION)) {
            return "VAL";
        }
        if (this.groupName.equals(EGLMESSAGE_GROUP_STATEMENT_PARSER)) {
            return "EGL";
        }
        if (this.groupName.equals(EGLMESSAGE_GROUP_XML_VALIDATION)) {
            return "XML";
        }
        if (this.groupName.equals(EGLMESSAGE_GROUP_EDITOR)) {
            return "EDT";
        }
        if (this.groupName.equals(EGLMESSAGE_GROUP_INPUT)) {
            return "INP";
        }
        if (this.groupName.equals(EGLMESSAGE_GROUP_DEBUGGER)) {
            return "DBG";
        }
        if (this.groupName.equals(EGLMESSAGE_VAG_MIGRATION)) {
            return "MIG";
        }
        if (this.groupName.equals(EGLMESSAGE_GROUP_SYNTAX)) {
            return "SYN";
        }
        if (this.groupName.equals(EGLMESSAGE_GROUP_DEPLOYMENT)) {
            return "DEP";
        }
        return "XXX";
    }

    public Object getMessageContributor() {
        return this.messageContributor;
    }

    public static ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(EGLMessage.getResourceBundleName());
    }

    public static String getResourceBundleName() {
        return "org.eclipse.edt.compiler.internal.core.builder.EGLValidationResources";
    }

    public static String getResourceString(String key) {
        try {
            return EGLMessage.getResourceBundle().getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    public int getStartColumn() {
        return this.startColumnNumber;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public int getStartLine() {
        return this.startLineNumber;
    }

    public static String getValidationResourceBundleName() {
        return "org.eclipse.edt.compiler.internal.core.builder.EGLValidationResources";
    }

    @Override
    public boolean isError() {
        return this.getSeverity() == 1;
    }

    @Override
    public boolean isInformational() {
        return this.getSeverity() == 3;
    }

    @Override
    public boolean isWarning() {
        return this.getSeverity() == 2;
    }

    public String primGetBuiltMessage() {
        return this.builtMessage;
    }

    public void setBuiltMessage(String msgText) {
        this.builtMessage = msgText;
    }

    public void setEndColumn(int newColumnNumber) {
        this.endColumnNumber = newColumnNumber < 0 ? 0 : newColumnNumber;
    }

    public void setEndLine(int lineNumber) {
        this.endLineNumber = lineNumber < 0 ? 0 : lineNumber;
    }

    public void setGroupName(String name) {
        this.groupName = name;
    }

    public void setMessageContributor(IEGLMessageContributor newPart) {
        this.messageContributor = newPart.getMessageContributor();
    }

    public void setMessageContributor(IEGLNestedMessageContributor newPart) {
        this.messageContributor = newPart.getMessageContributor();
    }

    public void setStartColumn(int newColumnNumber) {
        this.startColumnNumber = newColumnNumber < 0 ? 0 : newColumnNumber;
    }

    public void setStartLine(int lineNumber) {
        this.startLineNumber = lineNumber < 0 ? 0 : lineNumber;
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset < 0 ? 0 : offset;
    }

    public void setEndOffset(int offset) {
        this.endOffset = offset < 0 ? 0 : offset;
    }

    public String toString() {
        return String.valueOf(this.getId()) + ": " + this.builtMessage;
    }

    public String[] getParams() {
        return this.params;
    }

    @Override
    public String getResourceName() {
        if (this.getMessageContributor() instanceof IEGLMessageContributor) {
            return ((IEGLMessageContributor)this.getMessageContributor()).getResourceName();
        }
        return null;
    }
}

