/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.util;

public class Tea {
    private int[] _key;
    private int _padding;

    public Tea(int[] key) {
        this._key = key;
    }

    public Tea(byte[] key) {
        int klen = key.length;
        this._key = new int[4];
        if (klen != 16) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(this.getClass().getName()) + ": Key is not 16 bytes: " + klen);
        }
        int i = 0;
        int j = 0;
        while (j < klen) {
            this._key[i] = key[j] << 24 | (key[j + 1] & 0xFF) << 16 | (key[j + 2] & 0xFF) << 8 | key[j + 3] & 0xFF;
            j += 4;
            ++i;
        }
    }

    int[] encode(byte[] b, int count) {
        int bLen = count;
        byte[] bp = b;
        this._padding = bLen % 8;
        if (this._padding != 0) {
            this._padding = 8 - bLen % 8;
            bp = new byte[bLen + this._padding];
            System.arraycopy(b, 0, bp, 0, bLen);
            bLen = bp.length;
        }
        int intCount = bLen / 4;
        int[] r = new int[2];
        int[] out = new int[intCount];
        int i = 0;
        int j = 0;
        while (j < bLen) {
            r[0] = bp[j] << 24 | (bp[j + 1] & 0xFF) << 16 | (bp[j + 2] & 0xFF) << 8 | bp[j + 3] & 0xFF;
            r[1] = bp[j + 4] << 24 | (bp[j + 5] & 0xFF) << 16 | (bp[j + 6] & 0xFF) << 8 | bp[j + 7] & 0xFF;
            this.encipher(r);
            out[i] = r[0];
            out[i + 1] = r[1];
            j += 8;
            i += 2;
        }
        return out;
    }

    public int[] encipher(int[] v) {
        int y = v[0];
        int z = v[1];
        int sum = 0;
        int delta = -1640531527;
        int a = this._key[0];
        int b = this._key[1];
        int c = this._key[2];
        int d = this._key[3];
        int n = 32;
        while (n-- > 0) {
            z += ((y += (z << 4) + a ^ z + (sum += delta) ^ (z >>> 5) + b) << 4) + c ^ y + sum ^ (y >>> 5) + d;
        }
        v[0] = y;
        v[1] = z;
        return v;
    }

    public byte[] decode(int[] b) {
        int intCount = b.length;
        byte[] outb = new byte[intCount * 4];
        int[] tmp = new int[2];
        int j = 0;
        int i = 0;
        while (i < intCount) {
            tmp[0] = b[i];
            tmp[1] = b[i + 1];
            this.decipher(tmp);
            outb[j] = (byte)(tmp[0] >>> 24);
            outb[j + 1] = (byte)(tmp[0] >>> 16);
            outb[j + 2] = (byte)(tmp[0] >>> 8);
            outb[j + 3] = (byte)tmp[0];
            outb[j + 4] = (byte)(tmp[1] >>> 24);
            outb[j + 5] = (byte)(tmp[1] >>> 16);
            outb[j + 6] = (byte)(tmp[1] >>> 8);
            outb[j + 7] = (byte)tmp[1];
            i += 2;
            j += 8;
        }
        return outb;
    }

    public int[] decipher(int[] v) {
        int y = v[0];
        int z = v[1];
        int sum = -957401312;
        int delta = -1640531527;
        int a = this._key[0];
        int b = this._key[1];
        int c = this._key[2];
        int d = this._key[3];
        int n = 32;
        while (n-- > 0) {
            y -= ((z -= (y << 4) + c ^ y + sum ^ (y >>> 5) + d) << 4) + a ^ z + sum ^ (z >>> 5) + b;
            sum -= delta;
        }
        v[0] = y;
        v[1] = z;
        return v;
    }
}

