/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.tools;

import java.io.File;
import java.io.FileFilter;
import java.util.Vector;
import org.eclipse.edt.compiler.EDTCompiler;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.lookup.PartEnvironment;
import org.eclipse.edt.mof.egl.utils.LoadPartException;
import org.eclipse.edt.mof.impl.Bootstrap;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.FileSystemObjectStore;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class IRLoader {
    public static Part loadEGLPart(String rootDir, String partName, ICompiler compiler) throws LoadPartException {
        String EGL_SCHEMA = "egl:";
        if (partName != null && !partName.startsWith(EGL_SCHEMA)) {
            partName = String.valueOf(EGL_SCHEMA) + partName;
        }
        try {
            EObject eClass = IRLoader.loadEObject(rootDir, partName, compiler);
            if (eClass instanceof Part) {
                return (Part)eClass;
            }
            throw new LoadPartException(String.valueOf(partName) + " Not a part.");
        }
        catch (MofObjectNotFoundException e) {
            throw new LoadPartException("Fail to load part:" + partName, (Throwable)e);
        }
        catch (DeserializationException e) {
            throw new LoadPartException("Fail to load part:" + partName, (Throwable)e);
        }
    }

    public static EObject loadEObject(String rootDir, String key, ICompiler compiler) throws MofObjectNotFoundException, DeserializationException {
        if (rootDir == null || key == null) {
            throw new DeserializationException("rootDir and key must be specified");
        }
        File root = new File(rootDir);
        EObject eClass = null;
        try {
            Environment env = new Environment();
            Environment.pushEnv((IEnvironment)env);
            Bootstrap.initialize((IEnvironment)env);
            PartEnvironment partEnv = new PartEnvironment((IEnvironment)env);
            PartEnvironment.pushEnv((PartEnvironment)partEnv);
            FileSystemObjectStore typeStore = new FileSystemObjectStore(root, (IEnvironment)partEnv, "XML");
            partEnv.registerObjectStore("mof", (ObjectStore)typeStore);
            typeStore = new FileSystemObjectStore(root, (IEnvironment)partEnv, "XML", ".eglxml");
            partEnv.registerObjectStore("egl", (ObjectStore)typeStore);
            if (compiler == null) {
                compiler = new EDTCompiler();
            }
            partEnv.registerObjectStores(compiler.getSystemEnvironment(null).getStores());
            eClass = Environment.getCurrentEnv().find(key);
        }
        finally {
            Environment.popEnv();
            PartEnvironment.popEnv();
        }
        return eClass;
    }

    public static Vector<String> getPartNamesFromDirectory(File root, String packageName) {
        Vector<String> partNames = new Vector<String>();
        IRLoader.getIRsFromDirectory(partNames, root, new EGLIRFileFilter(), packageName);
        return partNames;
    }

    public static Vector<String> getMofIRNamesFromDirectory(File root, String packageName) {
        Vector<String> partNames = new Vector<String>();
        IRLoader.getIRsFromDirectory(partNames, root, new MofIRFileFilter(), packageName);
        return partNames;
    }

    private static void getIRsFromDirectory(Vector<String> fileList, File root, FileFilter filter, String packageName) {
        if (root.isDirectory()) {
            File[] fileArray = root.listFiles(filter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    IRLoader.getIRsFromDirectory(fileList, file, filter, String.valueOf(packageName) + "." + file.getName());
                } else {
                    String partName = String.valueOf(packageName) + "." + file.getName().substring(0, file.getName().indexOf("."));
                    if (partName.startsWith(".")) {
                        partName = partName.substring(1);
                    }
                    fileList.add(partName);
                }
                ++n2;
            }
        }
    }

    private static class EGLIRFileFilter
    implements FileFilter {
        private EGLIRFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            return pathname.getName().endsWith(".eglxml");
        }
    }

    private static class MofIRFileFilter
    implements FileFilter {
        private MofIRFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            return pathname.getName().endsWith(".mofbin") || pathname.getName().endsWith(".mofxml");
        }
    }
}

