/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.utils;

import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.Context;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2Mof;
import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.deployment.javascript.CompileErrorHTMLGenerator;
import org.eclipse.edt.gen.javascriptdev.ide.VEJavaScriptDevGenerator;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IProblemRequestorFactory;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.generation.IDEContext;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.ide.rui.internal.deployment.javascript.EGL2HTML4VE;
import org.eclipse.edt.ide.rui.internal.lookup.PreviewIREnvironmentManager;
import org.eclipse.edt.ide.rui.internal.nls.EWTPreviewMessages;
import org.eclipse.edt.ide.rui.utils.IWorkingCopyGenerationOperationNotifier;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.SerializationException;

public class WorkingCopyGenerationOperation {
    private String EGL_SCHEMA = "egl:";
    private IFile file;
    private IProblemRequestorFactory problemRequestorFactory;
    private IPath buildDescriptorFile;
    private String buildDescriptorName;
    private IPath outputLocation;
    private String eglPath;
    private IGenerationMessageRequestor generationMessageRequestor;
    private IWorkingCopyGenerationOperationNotifier notifier;
    private boolean editingMode = false;

    public WorkingCopyGenerationOperation(IFile file, IProblemRequestorFactory problemRequestorFactory, IGenerationMessageRequestor generationMessageRequestor, IPath buildDescriptorFile, String buildDescriptorName, IPath outputLocation, String eglPath, IWorkingCopyGenerationOperationNotifier notifier) {
        this.file = file;
        this.problemRequestorFactory = problemRequestorFactory;
        this.generationMessageRequestor = generationMessageRequestor;
        this.buildDescriptorFile = buildDescriptorFile;
        this.buildDescriptorName = buildDescriptorName;
        this.outputLocation = outputLocation;
        this.eglPath = eglPath;
        this.notifier = notifier;
    }

    public void generate() throws Exception {
        block7: {
            final IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.file);
            final String partName = new Path(this.file.getName()).removeFileExtension().toString();
            final HashSet<String> generatePartList = new HashSet<String>();
            if (this.notifier.isCancelled()) {
                return;
            }
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            try {
                if (sharedWorkingCopy.getPart(partName).exists()) {
                    if (this.notifier.isCancelled()) {
                        return;
                    }
                    final IEnvironment previewEnvironment = PreviewIREnvironmentManager.getPreviewIREnvironment(this.file.getProject(), this.outputLocation.toFile());
                    WorkingCopyCompiler.getInstance().compileAllParts(this.file.getProject(), ((EGLFile)modelFile).getPackageName(), this.file, new IWorkingCopy[]{sharedWorkingCopy}, new IWorkingCopyCompileRequestor(){

                        public void acceptResult(WorkingCopyCompilationResult result) {
                            Node boundPart = result.getBoundPart();
                            if (WorkingCopyGenerationOperation.this.notifier.isCancelled()) {
                                return;
                            }
                            boundPart.accept((IASTVisitor)new AbstractASTPartVisitor(){

                                public void visitPart(Part partAST) {
                                    String qualifiedName = WorkingCopyGenerationOperation.this.getQualifiedName(((EGLFile)modelFile).getPackageName(), partAST.getIdentifier());
                                    generatePartList.add(qualifiedName);
                                    if (!WorkingCopyGenerationOperation.this.problemRequestorFactory.getProblemRequestor(WorkingCopyGenerationOperation.this.file, partName).hasError()) {
                                        Egl2Mof generator = new Egl2Mof(previewEnvironment);
                                        EObject mof = generator.convert(partAST, (Context)new IDEContext(WorkingCopyGenerationOperation.this.file, (ICompiler)ProjectSettingsUtility.getCompiler((IProject)WorkingCopyGenerationOperation.this.file.getProject())), WorkingCopyGenerationOperation.this.problemRequestorFactory.getProblemRequestor(WorkingCopyGenerationOperation.this.file, partName));
                                        if (WorkingCopyGenerationOperation.this.notifier.isCancelled()) {
                                            return;
                                        }
                                        if (!WorkingCopyGenerationOperation.this.problemRequestorFactory.getProblemRequestor(WorkingCopyGenerationOperation.this.file, partName).hasError() && mof instanceof MofSerializable) {
                                            try {
                                                previewEnvironment.save((MofSerializable)mof);
                                            }
                                            catch (SerializationException se) {
                                                throw new BuildException("Mof SerializationException", (Throwable)se);
                                            }
                                        }
                                    }
                                }
                            });
                        }
                    }, this.problemRequestorFactory);
                    this.generateParts(generatePartList, previewEnvironment);
                    break block7;
                }
                throw new EGLModelException((IEGLModelStatus)new EGLModelStatus(968));
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
    }

    private void generateParts(HashSet<String> generatePartList, IEnvironment environment) {
        Environment.pushEnv((IEnvironment)environment);
        try {
            for (String partName : generatePartList) {
                try {
                    org.eclipse.edt.mof.egl.Part part = null;
                    EObject eObject = environment.find(PreviewIREnvironmentManager.makeEGLKey(partName));
                    if (!(eObject instanceof org.eclipse.edt.mof.egl.Part)) continue;
                    part = (org.eclipse.edt.mof.egl.Part)eObject;
                    VEJavaScriptDevGenerator veJavaScriptDevGenerator = new VEJavaScriptDevGenerator();
                    veJavaScriptDevGenerator.setOutputDirectory(this.outputLocation);
                    veJavaScriptDevGenerator.generate(this.file.getFullPath().toOSString(), (org.eclipse.edt.mof.egl.Part)part.clone(), environment, this.generationMessageRequestor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    EGL2HTML4VE cmd = new EGL2HTML4VE();
                    String message = MessageFormat.format(EWTPreviewMessages.COMPILEFAILEDPAGE_HEADERMSG, partName);
                    CompileErrorHTMLGenerator generator = new CompileErrorHTMLGenerator((AbstractGeneratorCommand)cmd, null, message);
                    generator.generate();
                }
            }
        }
        finally {
            if (environment != null) {
                Environment.popEnv();
            }
        }
    }

    private String getQualifiedName(String[] packageName, String partName) {
        String[] normalizedPckageName = IRFileNameUtility.toIRFileName((String[])packageName);
        StringBuffer qualifiedName = new StringBuffer(50);
        String[] stringArray = normalizedPckageName;
        int n = normalizedPckageName.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            qualifiedName.append(string).append(".");
            ++n2;
        }
        qualifiedName.append(partName);
        return qualifiedName.toString();
    }
}

