/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model;

import java.util.List;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.HandlerFieldsResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.DataFieldPageDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.HandlerPageDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.PageDataModel;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.PageDataNodeFactory;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class PageDataModelBuilder {
    private static PageDataModelBuilder instance;

    public static PageDataModelBuilder getInstance() {
        if (instance == null) {
            instance = new PageDataModelBuilder();
        }
        return instance;
    }

    private PageDataModelBuilder() {
    }

    public PageDataModel create(File file, EGLEditor editor) {
        PageDataModel model = new PageDataModel();
        List parts = file.getParts();
        for (Part part : parts) {
            if (!(part instanceof Handler)) continue;
            this.fillPageDataModel(editor, model);
        }
        return model;
    }

    private void fillPageDataModel(EGLEditor editor, PageDataModel model) {
        IEditorInput editorInput;
        if (editor != null && (editorInput = editor.getEditorInput()) instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
            HandlerFieldsResolver handlerFieldsResolver = new HandlerFieldsResolver(fileEditorInput.getFile());
            handlerFieldsResolver.resolve();
            Handler handler = handlerFieldsResolver.getRUIHandler();
            if (handler != null) {
                HandlerPageDataNode handlerPageDataNode = (HandlerPageDataNode)PageDataNodeFactory.newPageDataNode(this.getName(handler), 1);
                model.addRootPageDataNode(handlerPageDataNode);
                List contents = handler.getContents();
                int i = 0;
                while (i < contents.size()) {
                    if (contents.get(i) instanceof ClassDataDeclaration) {
                        ClassDataDeclaration classDataDeclaration = (ClassDataDeclaration)contents.get(i);
                        List names = classDataDeclaration.getNames();
                        int j = 0;
                        while (j < names.size()) {
                            ITypeBinding typeBinding;
                            SimpleName simpleName;
                            IDataBinding dataBinding;
                            Object oName = names.get(j);
                            if (oName instanceof SimpleName && (dataBinding = (simpleName = (SimpleName)oName).resolveDataBinding()) != null && (typeBinding = dataBinding.getType()) != null && this.isAcceptType(typeBinding)) {
                                ArrayTypeBinding arrayTypeBinding;
                                ITypeBinding elementTypeBinding;
                                if (!(typeBinding.getKind() != 3 && typeBinding.getKind() != 17 && typeBinding.getKind() != 7 || this.isAnyType(typeBinding))) {
                                    DataFieldPageDataNode dataFieldPageDataNode = null;
                                    dataFieldPageDataNode = classDataDeclaration.isPrivate() ? (DataFieldPageDataNode)PageDataNodeFactory.newPageDataNode(this.getName(dataBinding), 3) : (DataFieldPageDataNode)PageDataNodeFactory.newPageDataNode(this.getName(dataBinding), 2);
                                    dataFieldPageDataNode.setDataBindingName(dataBinding.getCaseSensitiveName());
                                    handlerPageDataNode.addChild(dataFieldPageDataNode);
                                }
                                if (!(typeBinding.getKind() != 2 || (elementTypeBinding = (arrayTypeBinding = (ArrayTypeBinding)typeBinding).getElementType()).getKind() != 3 && elementTypeBinding.getKind() != 17 && elementTypeBinding.getKind() != 7 || this.isAnyType(elementTypeBinding))) {
                                    DataFieldPageDataNode dataFieldPageDataNode = null;
                                    dataFieldPageDataNode = classDataDeclaration.isPrivate() ? (DataFieldPageDataNode)PageDataNodeFactory.newPageDataNode(this.getName(dataBinding), 3) : (DataFieldPageDataNode)PageDataNodeFactory.newPageDataNode(this.getName(dataBinding), 2);
                                    dataFieldPageDataNode.setDataBindingName(dataBinding.getCaseSensitiveName());
                                    handlerPageDataNode.addChild(dataFieldPageDataNode);
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private boolean isAcceptType(ITypeBinding typeBinding) {
        String packageQualifiedName = typeBinding.getPackageQualifiedName();
        return !packageQualifiedName.equals("org.eclipse.edt.rui.mvc.FormField");
    }

    private boolean isAnyType(ITypeBinding typeBinding) {
        DataItemBinding dataItemBinding;
        PrimitiveTypeBinding primitiveTypeBinding;
        if (typeBinding.getKind() == 3 && (primitiveTypeBinding = (PrimitiveTypeBinding)typeBinding).getPrimitive().getType() == 0) {
            return true;
        }
        return typeBinding.getKind() == 17 && (dataItemBinding = (DataItemBinding)typeBinding).getPrimitiveTypeBinding().getPrimitive().getType() == 0;
    }

    private String getName(Handler handler) {
        StringBuffer sbName = new StringBuffer(handler.getName().getCanonicalName());
        Name handlerType = handler.getSubType();
        if (handlerType != null) {
            sbName.append(" : ");
            sbName.append(handlerType.getCanonicalString());
        }
        return sbName.toString();
    }

    private String getName(IDataBinding dataBinding) {
        StringBuffer sbName = new StringBuffer(dataBinding.getCaseSensitiveName());
        sbName.append(" : ");
        sbName.append(dataBinding.getType().getName());
        return sbName.toString();
    }
}

