/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.ComposeGenNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.GenModel;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.GenNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataNode;

public class GenModelBuilder {
    private static GenModelBuilder instance;
    private GenModel genModel;

    public static GenModelBuilder getInstance() {
        if (instance == null) {
            instance = new GenModelBuilder();
        }
        return instance;
    }

    private GenModelBuilder() {
    }

    public GenModel create(InsertDataNode insertDataNode) {
        this.genModel = new GenModel();
        if (insertDataNode.isGen()) {
            ComposeGenNode root = new ComposeGenNode(this.genModel, insertDataNode);
            this.genModel.setRoot(root);
            this.processChildren(root, insertDataNode, this.genModel);
        }
        this.cleanModel(this.genModel);
        return this.genModel;
    }

    public GenModel getGenModel() {
        return this.genModel;
    }

    private void cleanModel(GenModel genModel) {
        List<GenNode> children = genModel.getRoot().getChildren();
        ArrayList<GenNode> clearedChildren = new ArrayList<GenNode>();
        for (GenNode child : children) {
            if (child.getInsertDataNode().getParent().getParent() == null) {
                clearedChildren.add(child);
                continue;
            }
            if (!child.getInsertDataNode().getParent().getDataTemplate().getDataMapping().isGenChildWidget()) continue;
            clearedChildren.add(child);
        }
        genModel.getRoot().setChildren(clearedChildren);
    }

    private void processChildren(ComposeGenNode parentCGN, InsertDataNode parentIDN, GenModel genModel) {
        for (InsertDataNode childIDN : parentIDN.getChildren()) {
            if (childIDN.isGen()) {
                if (childIDN.isArray() && childIDN.getNodeType().equals("TYPE_RECORD_ALL")) {
                    ComposeGenNode childCGN = new ComposeGenNode(genModel, childIDN);
                    parentCGN.addChild(childCGN);
                    this.processChildren(childCGN, childIDN, genModel);
                } else {
                    GenNode childGN = new GenNode(genModel, childIDN);
                    parentCGN.addChild(childGN);
                    this.processChildren(parentCGN, childIDN, genModel);
                }
            }
            this.processChildren(parentCGN, childIDN, genModel);
        }
    }
}

