/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.java.jtopen.access;

import eglx.jtopen.IBMiConnection;
import eglx.lang.StringLib;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.edt.java.jtopen.access.AS400DateTimeUtil;
import org.eclipse.edt.runtime.java.eglx.lang.ETimestamp;

public class AS400Timestamp
extends com.ibm.as400.access.AS400Timestamp {
    private static final long serialVersionUID = 1L;
    private int startCode;
    private int endCode;
    private SimpleDateFormat sdf;

    public AS400Timestamp(Integer ibmiFormat, int startCode, int endCode, String timeZoneID, IBMiConnection conn) {
        super(AS400DateTimeUtil.getIBMiTimezone(timeZoneID, conn));
        this.startCode = startCode;
        this.endCode = endCode;
    }

    public int getStartCode() {
        return this.startCode;
    }

    public int getEndCode() {
        return this.endCode;
    }

    public byte[] toBytes(Object object) {
        if (object instanceof Calendar) {
            object = this.toSqlTimestamp((Calendar)object);
        }
        return super.toBytes(object);
    }

    public int toBytes(Object object, byte[] bytes) {
        if (object instanceof Calendar) {
            object = this.toSqlTimestamp((Calendar)object);
        }
        return super.toBytes(object, bytes);
    }

    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object instanceof Calendar) {
            object = this.toSqlTimestamp((Calendar)object);
        }
        return super.toBytes(object, bytes, offset);
    }

    private Object toSqlTimestamp(Calendar cal) {
        Timestamp returnVal = null;
        try {
            returnVal = new Timestamp(this.ibmiSimpleDateFormat().parse(StringLib.format((Calendar)cal, (String)"yyyy-MM-dd HH:mm:ss.SSSSSS")).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return returnVal;
    }

    public Object toObject(byte[] arg0) {
        Object obj = super.toObject(arg0);
        return this.convert(obj);
    }

    public Object toObject(byte[] arg0, int arg1) {
        Object obj = super.toObject(arg0, arg1);
        return this.convert(obj);
    }

    private Object convert(Object obj) {
        if (obj instanceof Calendar) {
            return ETimestamp.asTimestamp((Calendar)((Calendar)obj), (int)this.startCode, (int)this.endCode);
        }
        if (obj instanceof Timestamp) {
            return ETimestamp.asTimestamp((String)this.ibmiSimpleDateFormat().format((Timestamp)obj), (Integer[])new Integer[]{this.startCode, this.endCode});
        }
        if (obj instanceof Date) {
            return ETimestamp.asTimestamp((String)this.ibmiSimpleDateFormat().format((Date)obj), (Integer[])new Integer[]{this.startCode, this.endCode});
        }
        return obj;
    }

    private SimpleDateFormat ibmiSimpleDateFormat() {
        if (this.sdf == null) {
            this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
            this.sdf.setTimeZone(this.getTimeZone());
        }
        return this.sdf;
    }
}

