/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

class SearchInDialog
extends TrayDialog {
    private Button[] fIncludeMasks;
    private IDialogSettings fSettings;
    private int fIncludeMask;
    private boolean fIncludeMaskChanged = false;
    private static final String DIALOG_SETTINGS_SECTION = "SearchInDialog";
    private static final String SEARCH_IN_SOURCES = "SearchInSources";
    private static final String SEARCH_IN_PROJECTS = "SearchInProjects";
    private static final String SEARCH_IN_APPLIBS = "SearchInAppLibs";
    private static final String SEARCH_IN_JRE = "SearchInJRE";
    private String[] fKeys = new String[]{"SearchInSources", "SearchInProjects", "SearchInJRE", "SearchInAppLibs"};

    public SearchInDialog(Shell parentShell) {
        super(parentShell);
        this.fSettings = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_SECTION);
        if (this.fSettings == null) {
            this.fSettings = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_SECTION);
            this.fSettings.put(SEARCH_IN_SOURCES, true);
            this.fSettings.put(SEARCH_IN_PROJECTS, true);
            this.fSettings.put(SEARCH_IN_JRE, true);
            this.fSettings.put(SEARCH_IN_APPLIBS, true);
        }
        this.fIncludeMask = this.getInt(this.fKeys);
    }

    private int getInt(String[] str) {
        int mask = 0;
        int val = 0;
        int i = 0;
        while (i < str.length) {
            boolean value = this.fSettings.getBoolean(str[i]);
            if (value) {
                switch (i) {
                    case 0: {
                        val = 1;
                        break;
                    }
                    case 1: {
                        val = 8;
                        break;
                    }
                    case 2: {
                        val = 4;
                        break;
                    }
                    case 3: {
                        val = 2;
                    }
                }
                mask |= val;
            }
            ++i;
        }
        return mask;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CallHierarchyMessages.SearchInDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.call_hierarchy_search_in_dialog_context");
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Control includeMask = this.createIncludeMask(composite);
        includeMask.setLayoutData((Object)new GridData(4, 4, true, false));
        return composite;
    }

    private Control createIncludeMask(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(SearchMessages.SearchPage_searchIn_label);
        result.setLayout((Layout)new GridLayout(4, false));
        this.fIncludeMasks = new Button[]{this.createButton((Composite)result, 32, SearchMessages.SearchPage_searchIn_sources, 1, this.fSettings.getBoolean(SEARCH_IN_SOURCES)), this.createButton((Composite)result, 32, SearchMessages.SearchPage_searchIn_projects, 8, this.fSettings.getBoolean(SEARCH_IN_PROJECTS)), this.createButton((Composite)result, 32, SearchMessages.SearchPage_searchIn_jre, 4, this.fSettings.getBoolean(SEARCH_IN_JRE)), this.createButton((Composite)result, 32, SearchMessages.SearchPage_searchIn_libraries, 2, this.fSettings.getBoolean(SEARCH_IN_APPLIBS))};
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchInDialog.this.updateOKStatus();
            }
        };
        int i = 0;
        while (i < this.fIncludeMasks.length) {
            this.fIncludeMasks[i].addSelectionListener((SelectionListener)listener);
            ++i;
        }
        return result;
    }

    protected void updateOKStatus() {
        boolean isValidMask = this.getIncludeMask() != 0;
        this.getButton(0).setEnabled(isValidMask);
    }

    int getIncludeMask() {
        if (this.fIncludeMasks == null || this.fIncludeMasks[0].isDisposed()) {
            return this.fIncludeMask;
        }
        int mask = 0;
        int i = 0;
        while (i < this.fIncludeMasks.length) {
            Button button = this.fIncludeMasks[i];
            if (button.getSelection()) {
                mask |= this.getIntData(button);
            }
            ++i;
        }
        return mask;
    }

    private int getIntData(Button button) {
        return (Integer)button.getData();
    }

    private Button createButton(Composite parent, int style, String text, int data, boolean isSelected) {
        Button button = new Button(parent, style);
        button.setText(text);
        button.setData((Object)new Integer(data));
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setSelection(isSelected);
        return button;
    }

    protected void okPressed() {
        int mask = this.getIncludeMask();
        if (mask != this.fIncludeMask) {
            this.fIncludeMask = mask;
            int i = 0;
            while (i < this.fIncludeMasks.length) {
                this.fSettings.put(this.fKeys[i], this.fIncludeMasks[i].getSelection());
                ++i;
            }
            this.fIncludeMaskChanged = true;
        } else {
            this.fIncludeMaskChanged = false;
        }
        super.okPressed();
    }

    public boolean isIncludeMaskChanged() {
        return this.fIncludeMaskChanged;
    }
}

