/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java.filters;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugTarget;
import org.eclipse.edt.debug.core.java.filters.ClasspathEntryFilter;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public class JREFilter
extends ClasspathEntryFilter {
    @Override
    protected void processClasspath(IClasspathEntry entry, IEGLJavaDebugTarget target, Map<String, Object> classMap) throws CoreException {
        IVMInstall vm = JavaRuntime.computeVMInstall((ILaunchConfiguration)target.getJavaDebugTarget().getLaunch().getLaunchConfiguration());
        if (vm != null) {
            LibraryLocation[] libraries;
            LibraryLocation[] libraryLocationArray = libraries = JavaRuntime.getLibraryLocations((IVMInstall)vm);
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                LibraryLocation library = libraryLocationArray[n2];
                this.processJar(library.getSystemLibraryPath().toFile(), library.getPackageRootPath().toString(), classMap);
                ++n2;
            }
        }
    }

    @Override
    protected IClasspathEntry[] getClasspathEntries(IEGLJavaDebugTarget target) throws CoreException {
        IRuntimeClasspathEntry entry = JavaRuntime.computeJREEntry((ILaunchConfiguration)target.getJavaDebugTarget().getLaunch().getLaunchConfiguration());
        if (entry != null) {
            return new IClasspathEntry[]{entry.getClasspathEntry()};
        }
        return null;
    }

    @Override
    protected Object getContainerClassMapKey(IEGLJavaDebugTarget target) throws CoreException {
        IVMInstall vm = JavaRuntime.computeVMInstall((ILaunchConfiguration)target.getJavaDebugTarget().getLaunch().getLaunchConfiguration());
        if (vm != null) {
            return vm.getId();
        }
        return null;
    }
}

