/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntry;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntryFactory;
import org.eclipse.edt.compiler.ISystemPartBindingLoadedRequestor;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DictionaryBinding;
import org.eclipse.edt.compiler.binding.EnumerationTypeBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.LibraryBinding;
import org.eclipse.edt.compiler.binding.PackageBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeManager;
import org.eclipse.edt.compiler.internal.EGLBaseNlsStrings;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.lookup.EnumerationManager;
import org.eclipse.edt.compiler.internal.core.lookup.ExternalTypePartManager;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemLibraryManager;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemPartManager;
import org.eclipse.edt.compiler.internal.util.NameUtil;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.osgi.util.NLS;

public class SystemEnvironment
implements ISystemEnvironment {
    protected IEnvironment irEnv;
    private PackageBinding rootPackageBinding = new PackageBinding(new String[0], null, this);
    private Map systemPackages = Collections.EMPTY_MAP;
    private Map unqualifiedSystemParts = Collections.EMPTY_MAP;
    private EnumerationManager enumerationManager;
    private SystemLibraryManager sysLibManager;
    private ExternalTypePartManager externalTypePartsManager;
    private AnnotationTypeManager annTypeManger;
    private ICompiler compiler;
    private List<ISystemPackageBuildPathEntry> sysPackages = new ArrayList<ISystemPackageBuildPathEntry>();
    private ISystemEnvironment parentSystemEnvironment;
    private Collection<String> implicitlyUsedEnumerationNames = Collections.EMPTY_SET;
    private boolean systemPackagesInitialized = false;

    private Map getSystemPackages() {
        if (this.systemPackages == Collections.EMPTY_MAP) {
            this.initializeMaps();
        }
        return this.systemPackages;
    }

    private Collection<String> getImplicitlyUsedEnumerationNames() {
        return this.implicitlyUsedEnumerationNames;
    }

    private Map getUnqualifiedSystemParts() {
        if (this.unqualifiedSystemParts == Collections.EMPTY_MAP) {
            this.initializeMaps();
        }
        return this.unqualifiedSystemParts;
    }

    private void initializeMaps() {
        this.systemPackages = new HashMap();
        this.unqualifiedSystemParts = new HashMap();
        this.addSystemTypes(EnumerationManager.getEnumTypes().values());
        this.addSystemTypes(SystemPartManager.getSystemParts().values());
    }

    private void addSystemTypes(Collection libraries) {
        for (IPartBinding part : libraries) {
            this.addSystemEntry(part);
        }
    }

    public void initializeSystemPackages(String libFolderPath, ISystemPackageBuildPathEntryFactory factory, IBuildNotifier notifier) {
        if (!this.systemPackagesInitialized) {
            if (notifier != null) {
                notifier.begin();
                notifier.subTask(NLS.bind((String)EGLBaseNlsStrings.SystemPackagesInit, (Object)libFolderPath));
                notifier.checkCancel();
            }
            try {
                Environment.pushEnv((IEnvironment)this.irEnv);
                String[] paths = NameUtil.toStringArray(libFolderPath, File.pathSeparator);
                float increment = 0.5f / (float)paths.length;
                int i = 0;
                while (i < paths.length) {
                    File libfolder = new File(paths[i]);
                    if (libfolder.exists() && libfolder.isDirectory()) {
                        File[] files = libfolder.listFiles();
                        this.sysPackages.addAll(factory.createEntries(this, this.irEnv, files, new ISystemPartBindingLoadedRequestor(){

                            @Override
                            public void partBindingLoaded(IPartBinding part) {
                                SystemEnvironment.this.addSystemEntry(part);
                            }
                        }));
                    }
                    if (notifier != null) {
                        notifier.checkCancel();
                        notifier.updateProgressDelta(increment);
                    }
                    ++i;
                }
                this.appendStoresToIREnvironment(this.parentSystemEnvironment);
                if (notifier != null) {
                    notifier.checkCancel();
                    notifier.updateProgressDelta(0.01f);
                }
                increment = 0.9f / (float)this.sysPackages.size();
                for (ISystemPackageBuildPathEntry entry : this.sysPackages) {
                    if (notifier != null) {
                        notifier.subTask(NLS.bind((String)EGLBaseNlsStrings.SystemPackagesProcessingArchive, (Object)entry.getID()));
                    }
                    entry.readPartBindings();
                    if (notifier == null) continue;
                    notifier.checkCancel();
                    notifier.updateProgressDelta(increment);
                }
                this.addSystemTypes(EnumerationManager.getEnumTypes().values());
                if (notifier != null) {
                    notifier.checkCancel();
                    notifier.updateProgressDelta(0.02f);
                }
                this.addSystemTypes(SystemPartManager.getSystemParts().values());
                if (notifier != null) {
                    notifier.checkCancel();
                    notifier.updateProgressDelta(0.02f);
                }
                this.systemPackagesInitialized = true;
            }
            finally {
                Environment.popEnv();
                DictionaryBinding.setDictionaryEnvironment(this);
                if (notifier != null) {
                    notifier.done();
                }
            }
        }
    }

    private boolean shouldAddToUnqualified(IPartBinding part) {
        String name;
        return !Binding.isValidBinding(part) || !(name = part.getPackageQualifiedName().toUpperCase().toLowerCase()).startsWith("org.eclipse.edt.mof.");
    }

    private void addSystemEntry(IPartBinding part) {
        if (this.shouldAddToUnqualified(part)) {
            this.getUnqualifiedSystemParts().put(part.getName(), part);
        }
        Map map = this.getPackageParts(part.getPackageName());
        map.put(part.getName(), part);
        if (part.getKind() == 11) {
            this.getSystemLibraryManager().addSystemLibrary((LibraryBinding)part);
        } else if (part.getKind() == 28) {
            if (ExternalTypePartManager.isLibraryType((ExternalTypeBinding)part)) {
                this.getExternalTypePartsManager().addExternalTypeLibrary((ExternalTypeBinding)part);
            } else if (ExternalTypePartManager.isExceptionType((ExternalTypeBinding)part)) {
                this.getExternalTypePartsManager().addExternalTypeException((ExternalTypeBinding)part);
            }
        } else if (part.getKind() == 19) {
            this.getEnumerationManager().addSystemEnumType((EnumerationTypeBinding)part);
            if (this.enumerationIsImplicitlyUsed(part)) {
                this.getEnumerationManager().addResolvableDataBindings((EnumerationTypeBinding)part);
            }
        } else if (part.getKind() == 7) {
            this.getAnnotationTypeManager().addSystemPackageRecord((FlexibleRecordBinding)part);
        }
    }

    private boolean enumerationIsImplicitlyUsed(IPartBinding part) {
        return this.getImplicitlyUsedEnumerationNames().contains(part.getName());
    }

    private Map getPackageParts(String[] packageName) {
        HashMap map = (HashMap)this.getSystemPackages().get(packageName);
        if (map == null) {
            map = new HashMap();
            this.getSystemPackages().put(packageName, map);
        }
        return map;
    }

    public SystemEnvironment(IEnvironment irEnv, ISystemEnvironment parentEnv, List<String> implicitlyUsedEnumerations, ICompiler compiler) {
        this.irEnv = irEnv;
        this.parentSystemEnvironment = parentEnv;
        this.implicitlyUsedEnumerationNames = implicitlyUsedEnumerations;
        this.compiler = compiler;
        if (parentEnv != null) {
            this.enumerationManager = new EnumerationManager(parentEnv.getEnumerationManager());
            this.sysLibManager = new SystemLibraryManager(parentEnv.getSystemLibraryManager());
            this.annTypeManger = new AnnotationTypeManager(parentEnv.getAnnotationTypeManager());
            this.externalTypePartsManager = new ExternalTypePartManager(parentEnv.getExternalTypePartsManager());
        } else {
            this.enumerationManager = new EnumerationManager(null);
            this.sysLibManager = new SystemLibraryManager(null);
            this.annTypeManger = new AnnotationTypeManager(null);
            this.externalTypePartsManager = new ExternalTypePartManager(null);
        }
    }

    @Override
    public IPartBinding getPartBinding(String[] packageName, String partName) {
        IPartBinding result = null;
        if (packageName == null && (result = (IPartBinding)this.getUnqualifiedSystemParts().get(partName)) != null) {
            return result;
        }
        Map map = (Map)this.getSystemPackages().get(packageName);
        if (map != null && (result = (IPartBinding)map.get(partName)) != null) {
            return result;
        }
        for (ISystemPackageBuildPathEntry entry : this.sysPackages) {
            result = entry.getPartBinding(packageName, partName);
            if (result == null) continue;
            return result;
        }
        if (result == null && this.parentSystemEnvironment != null) {
            return this.parentSystemEnvironment.getPartBinding(packageName, partName);
        }
        return result == null ? IBinding.NOT_FOUND_BINDING : result;
    }

    @Override
    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        IPartBinding result = null;
        Map map = (Map)this.getSystemPackages().get(packageName);
        if (map != null) {
            result = (IPartBinding)map.get(partName);
        }
        if (result == null && this.parentSystemEnvironment != null) {
            return this.parentSystemEnvironment.getCachedPartBinding(packageName, partName);
        }
        return result == null ? IBinding.NOT_FOUND_BINDING : result;
    }

    @Override
    public IPartBinding getNewPartBinding(String[] packageName, String partName, int kind) {
        return null;
    }

    @Override
    public boolean hasPackage(String[] packageName) {
        for (ISystemPackageBuildPathEntry entry : this.sysPackages) {
            if (!entry.hasPackage(packageName)) continue;
            return true;
        }
        if (this.parentSystemEnvironment != null) {
            return this.parentSystemEnvironment.hasPackage(packageName);
        }
        return false;
    }

    @Override
    public IPackageBinding getRootPackage() {
        return this.rootPackageBinding;
    }

    @Override
    public void clearParts() {
        for (ISystemPackageBuildPathEntry entry : this.sysPackages) {
            entry.clearParts();
        }
        if (this.parentSystemEnvironment != null) {
            this.parentSystemEnvironment.clearParts();
        }
    }

    public InputStream getResourceAsStream(String relativePath) {
        throw new UnsupportedOperationException();
    }

    public String getResourceLocation(String relativePath) {
        throw new UnsupportedOperationException();
    }

    public List<ISystemPackageBuildPathEntry> getSysPackages() {
        return this.sysPackages;
    }

    @Override
    public void addPartBindingToCache(IPartBinding partBinding) {
        this.addSystemEntry(partBinding);
    }

    @Override
    public ISystemEnvironment getSystemEnvironment() {
        return this;
    }

    @Override
    public ICompiler getCompiler() {
        return this.compiler;
    }

    private void appendStoresToIREnvironment(ISystemEnvironment env) {
        if (env == null || this.irEnv == null) {
            return;
        }
        Map<String, List<ObjectStore>> newStores = env.getStores();
        for (Map.Entry<String, List<ObjectStore>> entry : newStores.entrySet()) {
            String scheme = entry.getKey();
            List<ObjectStore> stores = entry.getValue();
            for (ObjectStore store : stores) {
                this.irEnv.registerObjectStore(scheme, store);
            }
        }
    }

    @Override
    public Map<String, List<ObjectStore>> getStores() {
        if (this.irEnv != null) {
            return this.irEnv.getObjectStores();
        }
        return new HashMap<String, List<ObjectStore>>();
    }

    @Override
    public IEnvironment getIREnvironment() {
        return this.irEnv;
    }

    @Override
    public EnumerationManager getEnumerationManager() {
        return this.enumerationManager;
    }

    @Override
    public SystemLibraryManager getSystemLibraryManager() {
        return this.sysLibManager;
    }

    @Override
    public AnnotationTypeManager getAnnotationTypeManager() {
        return this.annTypeManger;
    }

    @Override
    public ExternalTypePartManager getExternalTypePartsManager() {
        return this.externalTypePartsManager;
    }
}

