/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.edt.compiler.binding.DelegateBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.OverloadedFunctionSet;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.SystemFunctionBinding;
import org.eclipse.edt.compiler.binding.TypeBinding;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemLibrary;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ArrayTypeBinding
extends TypeBinding {
    private boolean isReference = true;
    private static Map typeBindingsToArrayForms = new WeakHashMap();
    private static Map typeBindingsToNonReferenceArrayForms = new WeakHashMap();
    private transient ITypeBinding elementType;
    public static final SystemFunctionBinding APPENDELEMENT = ArrayTypeBinding.createAppendElement(null);
    public static final SystemFunctionBinding APPENDALL = ArrayTypeBinding.createAppendAll(null);
    public static final SystemFunctionBinding INSERTELEMENT = SystemLibrary.createSystemFunction("insertElement", null, new String[]{"insertElement", "arrayIndex"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.ANY), PrimitiveTypeBinding.getInstance(Primitive.INT)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN, FunctionParameter.UseType.IN}, 172);
    public static final SystemFunctionBinding REMOVEELEMENT = SystemLibrary.createSystemFunction("removeElement", null, new String[]{"arrayIndex"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.INT)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 173);
    public static final SystemFunctionBinding INDEXOFELEMENT1 = SystemLibrary.createSystemFunction("indexOfElement", null, PrimitiveTypeBinding.getInstance(Primitive.INT), new String[]{"value", "index"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.ANY), PrimitiveTypeBinding.getInstance(Primitive.INT)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN, FunctionParameter.UseType.IN}, 0);
    public static final SystemFunctionBinding INDEXOFELEMENT2 = SystemLibrary.createSystemFunction("indexOfElement", null, PrimitiveTypeBinding.getInstance(Primitive.INT), new String[]{"value"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.ANY)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
    public static final OverloadedFunctionSet INDEXOFELEMENT3 = new OverloadedFunctionSet();
    public static final SystemFunctionBinding REMOVEALL;
    public static final SystemFunctionBinding SETELEMENT;
    public static final SystemFunctionBinding GETSIZE;
    public static final SystemFunctionBinding RESIZE;
    public static final DelegateBinding SORT_FUNCTION;
    public static final SystemFunctionBinding SORT;
    protected static final Map ARRAY_FUNCTIONS;
    private transient Map instanceArrayFunctions;

    static {
        INDEXOFELEMENT3.setName(INDEXOFELEMENT1.getCaseSensitiveName());
        INDEXOFELEMENT3.addNestedFunctionBinding(new NestedFunctionBinding(INDEXOFELEMENT1.getCaseSensitiveName(), null, INDEXOFELEMENT1));
        INDEXOFELEMENT3.addNestedFunctionBinding(new NestedFunctionBinding(INDEXOFELEMENT2.getCaseSensitiveName(), null, INDEXOFELEMENT2));
        REMOVEALL = SystemLibrary.createSystemFunction("removeAll", null, 174);
        SETELEMENT = SystemLibrary.createSystemFunction("setElement", null, new String[]{"value", "arrayIndex"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.ANY), PrimitiveTypeBinding.getInstance(Primitive.INT)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN, FunctionParameter.UseType.IN}, 0);
        GETSIZE = SystemLibrary.createSystemFunction("getSize", null, PrimitiveTypeBinding.getInstance(Primitive.INT), 179);
        RESIZE = SystemLibrary.createSystemFunction("resize", null, new String[]{"newDimension"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.INT)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 175);
        SORT_FUNCTION = new DelegateBinding(InternUtil.intern((String[])new String[]{"eglx", "lang"}), InternUtil.intern((String)"SortFunction"));
        FunctionParameterBinding parm1 = new FunctionParameterBinding("a", SORT_FUNCTION, PrimitiveTypeBinding.getInstance(Primitive.ANY), null);
        parm1.setInput(true);
        SORT_FUNCTION.addParameter(parm1);
        FunctionParameterBinding parm2 = new FunctionParameterBinding("b", SORT_FUNCTION, PrimitiveTypeBinding.getInstance(Primitive.ANY), null);
        parm2.setInput(true);
        SORT_FUNCTION.addParameter(parm2);
        SORT_FUNCTION.setReturnType(PrimitiveTypeBinding.getInstance(Primitive.INT));
        SORT = SystemLibrary.createSystemFunction("Sort", null, new String[]{"sortFunction"}, new ITypeBinding[]{SORT_FUNCTION}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 0);
        ARRAY_FUNCTIONS = new HashMap();
        ARRAY_FUNCTIONS.put(APPENDELEMENT.getName(), new NestedFunctionBinding(APPENDELEMENT.getName(), null, APPENDELEMENT));
        ARRAY_FUNCTIONS.put(APPENDALL.getName(), new NestedFunctionBinding(APPENDALL.getName(), null, APPENDALL));
        ARRAY_FUNCTIONS.put(INSERTELEMENT.getName(), new NestedFunctionBinding(INSERTELEMENT.getName(), null, INSERTELEMENT));
        ARRAY_FUNCTIONS.put(REMOVEELEMENT.getName(), new NestedFunctionBinding(REMOVEELEMENT.getName(), null, REMOVEELEMENT));
        ARRAY_FUNCTIONS.put(INDEXOFELEMENT3.getName(), INDEXOFELEMENT3);
        ARRAY_FUNCTIONS.put(REMOVEALL.getName(), new NestedFunctionBinding(REMOVEALL.getName(), null, REMOVEALL));
        ARRAY_FUNCTIONS.put(SETELEMENT.getName(), new NestedFunctionBinding(SETELEMENT.getName(), null, SETELEMENT));
        ARRAY_FUNCTIONS.put(GETSIZE.getName(), new NestedFunctionBinding(GETSIZE.getName(), null, GETSIZE));
        ARRAY_FUNCTIONS.put(RESIZE.getName(), new NestedFunctionBinding(RESIZE.getName(), null, RESIZE));
        ARRAY_FUNCTIONS.put(SORT.getName(), new NestedFunctionBinding(SORT.getName(), null, SORT));
    }

    protected ArrayTypeBinding(ITypeBinding elementType) {
        super(String.valueOf(elementType.getCaseSensitiveName()) + "[]");
        this.elementType = elementType;
    }

    public static ArrayTypeBinding getInstance(ITypeBinding elementType) {
        WeakReference<ArrayTypeBinding> result = (WeakReference<ArrayTypeBinding>)typeBindingsToArrayForms.get(elementType);
        if (result == null || result.get() == null) {
            result = new WeakReference<ArrayTypeBinding>(new ArrayTypeBinding(elementType));
            typeBindingsToArrayForms.put(elementType, result);
        }
        return (ArrayTypeBinding)result.get();
    }

    public static ArrayTypeBinding getNonReferenceInstance(ITypeBinding elementType) {
        WeakReference<ArrayTypeBinding> result = (WeakReference<ArrayTypeBinding>)typeBindingsToNonReferenceArrayForms.get(elementType);
        if (result == null || result.get() == null) {
            ArrayTypeBinding arr = new ArrayTypeBinding(elementType);
            arr.isReference = false;
            result = new WeakReference<ArrayTypeBinding>(arr);
            typeBindingsToNonReferenceArrayForms.put(elementType, result);
        }
        return (ArrayTypeBinding)result.get();
    }

    public static Map getARRAY_FUNCTIONS() {
        return ARRAY_FUNCTIONS;
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    public ITypeBinding getElementType() {
        return this.elementType;
    }

    public ITypeBinding realize() {
        return this;
    }

    public String getQualifiedName() {
        return null;
    }

    @Override
    public void clear() {
        this.instanceArrayFunctions = null;
    }

    @Override
    public ITypeBinding getBaseType() {
        return this.elementType.getKind() == 2 ? ((ArrayTypeBinding)this.elementType).getBaseType() : this.elementType;
    }

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    public IDataBinding findData(String simpleName) {
        IDataBinding result = (IDataBinding)this.getInstanceArrayFunctions().get(simpleName);
        if (result != null) {
            return result;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public IFunctionBinding findFunction(String simpleName) {
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public Map getSimpleNamesToDataBindingsMap() {
        ITypeBinding baseElementType = this.getBaseType();
        if (baseElementType.getKind() == 6) {
            return baseElementType.getSimpleNamesToDataBindingsMap();
        }
        return Collections.EMPTY_MAP;
    }

    private Object readResolve() {
        return ArrayTypeBinding.getInstance(this.elementType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.elementType = this.readTypeBindingReference(in);
    }

    @Override
    public boolean isValid() {
        return this.elementType.isValid();
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        ArrayTypeBinding nullable = new ArrayTypeBinding(this.elementType);
        nullable.setNullable(true);
        return nullable;
    }

    private Map getInstanceArrayFunctions() {
        if (this.instanceArrayFunctions == null) {
            this.instanceArrayFunctions = new HashMap(ARRAY_FUNCTIONS);
            this.instanceArrayFunctions.put(APPENDALL.getName(), new NestedFunctionBinding(APPENDALL.getName(), null, ArrayTypeBinding.createAppendAll(this)));
            this.instanceArrayFunctions.put(APPENDELEMENT.getName(), new NestedFunctionBinding(APPENDELEMENT.getName(), null, ArrayTypeBinding.createAppendElement(this)));
        }
        return this.instanceArrayFunctions;
    }

    private static SystemFunctionBinding createAppendAll(ITypeBinding returnType) {
        return SystemLibrary.createSystemFunction("appendAll", null, returnType, new String[]{"array"}, new ITypeBinding[]{ArrayTypeBinding.getInstance(PrimitiveTypeBinding.getInstance(Primitive.ANY))}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 171);
    }

    private static SystemFunctionBinding createAppendElement(ITypeBinding returnType) {
        return SystemLibrary.createSystemFunction("appendElement", null, returnType, new String[]{"appendElement"}, new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.ANY)}, new FunctionParameter.UseType[]{FunctionParameter.UseType.IN}, 170);
    }
}

