/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.EnumerationTypeBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.EnumerationField;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class EnumerationBindingCompletor
extends AbstractBinder {
    private EnumerationTypeBinding enumerationBinding;
    private IProblemRequestor problemRequestor;
    private Set fieldNames = new HashSet();

    public EnumerationBindingCompletor(Scope currentScope, EnumerationTypeBinding enumerationBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, enumerationBinding, dependencyRequestor, compilerOptions);
        this.enumerationBinding = enumerationBinding;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(Enumeration enumeration) {
        enumeration.getName().setBinding(this.enumerationBinding);
        this.enumerationBinding.setPrivate(this.enumerationBinding.isPrivate());
        return true;
    }

    @Override
    public void endVisit(Enumeration enumeration) {
        this.enumerationBinding.setValid(true);
    }

    @Override
    public boolean visit(EnumerationField enumerationField) {
        int constantValue = -1;
        if (enumerationField.hasConstantValue()) {
            final int[] constantValueAry = new int[]{-1};
            enumerationField.getConstantValue().accept(new AbstractASTExpressionVisitor(){

                @Override
                public void endVisit(IntegerLiteral integerLiteral) {
                    try {
                        constantValueAry[0] = Integer.parseInt(integerLiteral.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }

                @Override
                public boolean visit(UnaryExpression unaryExpression) {
                    return true;
                }

                @Override
                public void endVisit(UnaryExpression unaryExpression) {
                    if (unaryExpression.getOperator() == UnaryExpression.Operator.MINUS) {
                        constantValueAry[0] = constantValueAry[0] * -1;
                    }
                }

                @Override
                public void endVisitExpression(Expression expression) {
                }
            });
            constantValue = constantValueAry[0];
        } else {
            constantValue = this.fieldNames.size();
        }
        EnumerationDataBinding enumDataBinding = new EnumerationDataBinding(enumerationField.getName().getCaseSensitiveIdentifier(), this.enumerationBinding, this.enumerationBinding, constantValue);
        enumerationField.getName().setBinding(enumDataBinding);
        if (this.fieldNames.contains(enumerationField.getName().getIdentifier())) {
            this.problemRequestor.acceptProblem((Node)enumerationField.getName(), 3010, new String[]{enumerationField.getName().getCanonicalName(), this.enumerationBinding.getCaseSensitiveName()});
        } else {
            this.fieldNames.add(enumerationField.getName().getIdentifier());
            this.enumerationBinding.addEnumeration(enumDataBinding);
        }
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        AnnotationLeftHandScope scope = new AnnotationLeftHandScope(this.currentScope, this.enumerationBinding, this.enumerationBinding, this.enumerationBinding, -1, this.enumerationBinding);
        SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.enumerationBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        settingsBlock.accept(blockCompletor);
        return false;
    }
}

