/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.ConstantFormFieldBinding;
import org.eclipse.edt.compiler.binding.FieldLenUtility;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormBindingFieldsCompletor;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.PartSubTypeAndAnnotationCollector;
import org.eclipse.edt.compiler.binding.PositionUtility;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.binding.VariableFormFieldBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.FormScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class FormBindingCompletor
extends AbstractBinder {
    private FormBinding formBinding;
    private IAnnotationBinding partSubTypeAnnotationBinding;
    private IProblemRequestor problemRequestor;

    public FormBindingCompletor(Scope currentScope, FormBinding formBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, formBinding, dependencyRequestor, compilerOptions);
        this.formBinding = formBinding;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(TopLevelForm form) {
        PartSubTypeAndAnnotationCollector collector = new PartSubTypeAndAnnotationCollector(this.formBinding, this, this.currentScope, this.problemRequestor);
        form.accept(collector);
        this.processSubType(collector, form.getName());
        form.accept(new FormBindingFieldsCompletor(this.currentScope, this.formBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        this.processSettingsBlocksFromCollector(collector);
        this.setDefaultAnnotationsOnFields();
        this.formBinding.setPrivate(form.isPrivate());
        form.getName().setBinding(this.formBinding);
        return false;
    }

    @Override
    public void endVisit(TopLevelForm topLevelForm) {
        this.formBinding.setValid(true);
    }

    private void setDefaultAnnotationsOnFields() {
        for (FormFieldBinding field : this.formBinding.getFields()) {
            if (field.isVariable()) {
                this.setDefaultAnntoations((VariableFormFieldBinding)field);
                continue;
            }
            this.setDefaultAnntoations((ConstantFormFieldBinding)field);
        }
    }

    private void setDefaultAnntoations(VariableFormFieldBinding field) {
        new FieldLenUtility(field, this.compilerOptions, this.currentScope).checkFieldLen();
        new PositionUtility(field, field.getOccurs(), this.compilerOptions, this.currentScope).checkPosition();
    }

    private void setDefaultAnntoations(ConstantFormFieldBinding field) {
        new PositionUtility(field, 0, this.compilerOptions, this.currentScope).checkPosition();
    }

    private void processSettingsBlocksFromCollector(PartSubTypeAndAnnotationCollector collector) {
        if (collector.getSettingsBlocks().size() > 0) {
            AnnotationLeftHandScope scope = new AnnotationLeftHandScope(new FormScope(this.currentScope, this.formBinding), this.formBinding, this.formBinding, this.formBinding, -1, this.formBinding);
            if (!collector.isFoundSubTypeInSettingsBlock() && this.partSubTypeAnnotationBinding != null) {
                scope = new AnnotationLeftHandScope(scope, this.partSubTypeAnnotationBinding, this.partSubTypeAnnotationBinding.getType(), this.partSubTypeAnnotationBinding, -1, this.formBinding);
            }
            SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.formBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            for (SettingsBlock block : collector.getSettingsBlocks()) {
                block.accept(blockCompletor);
            }
        }
    }

    @Override
    public boolean visit(NestedForm form) {
        PartSubTypeAndAnnotationCollector collector = new PartSubTypeAndAnnotationCollector(this.formBinding, this, this.currentScope, this.problemRequestor);
        form.accept(collector);
        this.processSubType(collector, form.getName());
        form.accept(new FormBindingFieldsCompletor(this.currentScope, this.formBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        this.processSettingsBlocksFromCollector(collector);
        this.setDefaultAnnotationsOnFields();
        form.getName().setBinding(this.formBinding);
        this.formBinding.setPrivate(form.isPrivate());
        return false;
    }

    @Override
    public void endVisit(NestedForm nestedForm) {
        this.formBinding.setValid(true);
    }

    protected void processSubType(PartSubTypeAndAnnotationCollector collector, Name formName) {
        if (collector.getSubTypeAnnotationBinding() == null) {
            this.problemRequestor.acceptProblem((Node)formName, 5390, new String[]{formName.getCanonicalName()});
        }
        if (collector.isFoundSubTypeInSettingsBlock()) {
            this.partSubTypeAnnotationBinding = collector.getSubTypeAnnotationBinding();
        }
    }
}

