/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormBindingCompletor;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class FormGroupBindingCompletor
extends AbstractBinder {
    private FormGroupBinding formGroupBinding;
    private IProblemRequestor problemRequestor;
    private Set definedFormNames = new HashSet();

    public FormGroupBindingCompletor(Scope currentScope, FormGroupBinding formGroupBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, formGroupBinding, dependencyRequestor, compilerOptions);
        this.formGroupBinding = formGroupBinding;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(FormGroup formGroup) {
        formGroup.getName().setBinding(this.formGroupBinding);
        this.formGroupBinding.setPrivate(formGroup.isPrivate());
        return true;
    }

    @Override
    public void endVisit(FormGroup formGroup) {
        this.formGroupBinding.setValid(true);
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        AnnotationLeftHandScope lhScope = new AnnotationLeftHandScope(this.currentScope, this.formGroupBinding, this.formGroupBinding, this.formGroupBinding, -1, this.formGroupBinding);
        SettingsBlockAnnotationBindingsCompletor completor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.formGroupBinding, lhScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        settingsBlock.accept(completor);
        return false;
    }

    @Override
    public boolean visit(NestedForm form) {
        String formName = form.getName().getIdentifier();
        FormBinding formBinding = new FormBinding(this.formGroupBinding.getPackageName(), form.getName().getCaseSensitiveIdentifier(), this.formGroupBinding);
        formBinding.setEnvironment(this.formGroupBinding.getEnvironment());
        FormBindingCompletor formBinder = new FormBindingCompletor(this.currentScope, formBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        form.accept(formBinder);
        if (this.definedFormNames.contains(formName)) {
            this.problemRequestor.acceptProblem((Node)form.getName(), 5331, new String[]{formName, this.formGroupBinding.getCaseSensitiveName()});
        } else {
            this.formGroupBinding.addNestedForm(formBinding);
            this.definedFormNames.add(formName);
        }
        formBinding.setEnvironment(this.formGroupBinding.getEnvironment());
        return false;
    }

    @Override
    public boolean visit(UseStatement useStatement) {
        for (Name nextName : useStatement.getNames()) {
            String nextFormName = nextName.getIdentifier();
            ITypeBinding typeBinding = null;
            try {
                typeBinding = this.bindTypeName(nextName);
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                continue;
            }
            if (typeBinding.getKind() == 8) {
                if (this.definedFormNames.contains(nextFormName)) {
                    this.problemRequestor.acceptProblem((Node)nextName, 5331, new String[]{nextName.getCanonicalName(), this.formGroupBinding.getCaseSensitiveName()});
                    continue;
                }
                this.formGroupBinding.addUsedForm(typeBinding);
                this.definedFormNames.add(nextFormName);
                continue;
            }
            this.problemRequestor.acceptProblem((Node)nextName, 5378, new String[]{nextName.getCanonicalName(), this.formGroupBinding.getCaseSensitiveName()});
        }
        return false;
    }
}

