/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashSet;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.BindingUtilities;
import org.eclipse.edt.compiler.binding.ConstructorBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionContainerBindingCompletor;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.HandlerBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartSubTypeAndAnnotationCollector;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class HandlerBindingCompletor
extends FunctionContainerBindingCompletor {
    private HandlerBinding handlerBinding;

    public HandlerBindingCompletor(Scope currentScope, HandlerBinding handlerBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(handlerBinding, currentScope, dependencyRequestor, problemRequestor, compilerOptions);
        this.handlerBinding = handlerBinding;
    }

    @Override
    public boolean visit(Handler handler) {
        handler.getName().setBinding(this.handlerBinding);
        this.handlerBinding.setPrivate(handler.isPrivate());
        PartSubTypeAndAnnotationCollector col = this.getPartSubTypeAndAnnotationCollector();
        handler.accept(col);
        this.addImplicitFieldsFromAnnotations();
        for (Name nextName : handler.getImplementedInterfaces()) {
            try {
                ITypeBinding typeBinding = this.bindTypeName(nextName);
                this.handlerBinding.addExtenedInterface(typeBinding);
                if (15 == typeBinding.getKind()) continue;
                this.problemRequestor.acceptProblem(nextName, 7801);
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
        return true;
    }

    @Override
    public boolean visit(Constructor constructor) {
        final ConstructorBinding constructorBinding = new ConstructorBinding(this.handlerBinding);
        final HashSet definedParameters = new HashSet();
        constructor.setBinding(constructorBinding);
        constructorBinding.setPrivate(constructor.isPrivate());
        constructor.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(FunctionParameter functionParameter) {
                String parmName = functionParameter.getName().getIdentifier();
                Type parmType = functionParameter.getType();
                ITypeBinding typeBinding = null;
                try {
                    typeBinding = HandlerBindingCompletor.this.bindType(parmType);
                }
                catch (ResolutionException e) {
                    functionParameter.getName().setBinding(new FunctionParameterBinding(functionParameter.getName().getCaseSensitiveIdentifier(), HandlerBindingCompletor.this.handlerBinding, IBinding.NOT_FOUND_BINDING, (IFunctionBinding)constructorBinding.getType()));
                    HandlerBindingCompletor.this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                    return false;
                }
                FunctionParameterBinding funcParmBinding = new FunctionParameterBinding(functionParameter.getName().getCaseSensitiveIdentifier(), HandlerBindingCompletor.this.handlerBinding, typeBinding, (IFunctionBinding)constructorBinding.getType());
                functionParameter.getName().setBinding(funcParmBinding);
                if (!BindingUtilities.isValidDeclarationType(typeBinding)) {
                    HandlerBindingCompletor.this.problemRequestor.acceptProblem((Node)parmType, 4902, new String[]{functionParameter.getName().getCanonicalName(), "constructor"});
                    return false;
                }
                FunctionParameter.AttrType attrType = functionParameter.getAttrType();
                if (attrType == FunctionParameter.AttrType.FIELD) {
                    funcParmBinding.setField(true);
                } else if (attrType == FunctionParameter.AttrType.SQLNULLABLE) {
                    funcParmBinding.setSqlNullable(true);
                }
                FunctionParameter.UseType useType = functionParameter.getUseType();
                if (useType == FunctionParameter.UseType.IN) {
                    funcParmBinding.setInput(true);
                } else if (useType == FunctionParameter.UseType.OUT) {
                    funcParmBinding.setOutput(true);
                } else if (useType == null && Binding.isValidBinding(typeBinding) && typeBinding.isReference()) {
                    funcParmBinding.setInput(true);
                }
                if (definedParameters.contains(parmName)) {
                    HandlerBindingCompletor.this.problemRequestor.acceptProblem((Node)functionParameter, 3012, new String[]{functionParameter.getName().getCanonicalName(), "constructor"});
                } else {
                    constructorBinding.addParameter(funcParmBinding);
                    definedParameters.add(parmName);
                }
                return false;
            }
        });
        this.handlerBinding.addConstructor(constructorBinding);
        if (constructor.hasSettingsBlock()) {
            FunctionScope functionScope = new FunctionScope(this.currentScope, (FunctionBinding)constructorBinding.getType());
            AnnotationLeftHandScope scope = new AnnotationLeftHandScope(functionScope, constructorBinding, null, constructorBinding, -1, this.handlerBinding);
            SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(functionScope, this.handlerBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            constructor.getSettingsBlock().accept(blockCompletor);
        }
        return false;
    }

    @Override
    public void endVisit(Handler handler) {
        this.processSettingsBlocks();
        if (this.handlerBinding.getConstructors().isEmpty()) {
            this.handlerBinding.addConstructor(new ConstructorBinding(this.handlerBinding));
        }
        this.endVisitFunctionContainer(handler);
    }

    @Override
    protected IPartSubTypeAnnotationTypeBinding getDefaultSubType() {
        return null;
    }
}

