/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.Map;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.FieldContentValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class MutuallyExclusiveAnnotationAnnotationTypeBinding
extends FieldContentValidationAnnotationTypeBinding {
    private String annotationName;
    private String[] mutuallyExclusiveWith;

    public MutuallyExclusiveAnnotationAnnotationTypeBinding(String annotationName, String[] mutuallyExclusiveWith) {
        super(InternUtil.internCaseSensitive((String)"MutuallyExclusive"));
        this.annotationName = annotationName;
        this.mutuallyExclusiveWith = mutuallyExclusiveWith;
    }

    @Override
    public void validate(Node errorNode, Node target, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding aBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)this.annotationName));
        if (aBinding != null && Boolean.NO != aBinding.getValue()) {
            int i = 0;
            while (i < this.mutuallyExclusiveWith.length) {
                IAnnotationBinding anotherABinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)this.mutuallyExclusiveWith[i]));
                if (anotherABinding != null && !this.isNonApplicable(anotherABinding.getValue())) {
                    problemRequestor.acceptProblem(errorNode, 3070, new String[]{this.annotationName, this.mutuallyExclusiveWith[i]});
                }
                ++i;
            }
        }
    }

    private boolean isNonApplicable(Object value) {
        EnumerationDataBinding enumBinding;
        if (Boolean.NO == value) {
            return true;
        }
        return value instanceof EnumerationDataBinding && (enumBinding = (EnumerationDataBinding)value).getName() == InternUtil.intern((String)"none");
    }
}

