/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.Set;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FunctionContainerBindingCompletor;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.ProgramBinding;
import org.eclipse.edt.compiler.binding.ProgramParameterBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ProgramBindingCompletor
extends FunctionContainerBindingCompletor {
    private ProgramBinding programBinding;
    private IProblemRequestor problemRequestor;
    private String canonicalProgramName;

    public ProgramBindingCompletor(Scope currentScope, ProgramBinding programBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(programBinding, currentScope, dependencyRequestor, problemRequestor, compilerOptions);
        this.programBinding = programBinding;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(Program program) {
        this.canonicalProgramName = program.getName().getCanonicalName();
        program.getName().setBinding(this.programBinding);
        program.accept(this.getPartSubTypeAndAnnotationCollector());
        this.programBinding.setPrivate(program.isPrivate());
        this.programBinding.setCallable(program.isCallable());
        this.addImplicitFieldsFromAnnotations();
        return true;
    }

    @Override
    public void endVisit(Program program) {
        for (ProgramParameter programParameter : program.getParameters()) {
            Name parameterNameNode = programParameter.getName();
            String parameterName = parameterNameNode.getIdentifier();
            Type parameterType = programParameter.getType();
            ITypeBinding typeBinding = null;
            try {
                typeBinding = this.bindType(parameterType);
            }
            catch (ResolutionException e) {
                IDataBinding formDB;
                Type baseType = parameterType.getBaseType();
                IDataBinding iDataBinding = formDB = baseType.isNameType() ? this.getForm(((NameType)baseType).getName().getIdentifier(), this.usedForms) : null;
                if (formDB != null && IBinding.NOT_FOUND_BINDING != formDB && this.usedForms.contains(formDB.getType().getBaseType())) {
                    typeBinding = formDB.getType();
                    ((NameType)baseType).getName().setBinding(typeBinding);
                    if (parameterType.isArrayType()) {
                        this.problemRequestor.acceptProblem((Node)parameterType, 4939, new String[]{parameterNameNode.getCanonicalName(), this.canonicalProgramName});
                    }
                }
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                continue;
            }
            if (typeBinding.isNullable()) {
                this.problemRequestor.acceptProblem(programParameter.getType(), 3431);
                typeBinding = typeBinding.getBaseType();
            }
            ProgramParameterBinding parameterBinding = new ProgramParameterBinding(parameterNameNode.getCaseSensitiveIdentifier(), this.programBinding, typeBinding);
            if (this.definedDataNames.contains(parameterName)) {
                this.problemRequestor.acceptProblem((Node)parameterNameNode, 3012, new String[]{parameterNameNode.getCanonicalName(), this.programBinding.getCaseSensitiveName()});
            } else {
                this.programBinding.addParameter(parameterBinding);
                this.definedDataNames.add(parameterName);
            }
            parameterNameNode.setBinding(parameterBinding);
        }
        this.processSettingsBlocks();
        this.endVisitFunctionContainer(program);
    }

    @Override
    protected IPartSubTypeAnnotationTypeBinding getDefaultSubType() {
        try {
            return new AnnotationTypeBindingImpl((FlexibleRecordBinding)this.currentScope.findPackage(InternUtil.intern((String)"eglx")).resolvePackage(InternUtil.intern((String)"lang")).resolveType(InternUtil.intern((String)"BasicProgram")), this.programBinding);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private IDataBinding getForm(String name, Set usedForms) {
        for (IBinding next : usedForms) {
            if (next.getName() != name) continue;
            return ((FormBinding)next).getStaticFormDataBinding();
        }
        return null;
    }
}

