/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Stack;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.ast.AbstractRecovery;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ITokenStream;
import org.eclipse.edt.compiler.core.ast.ParseStack;

public class AdvancedPhraseRecovery
extends AbstractRecovery {
    public static final int INPUT_DELETION_LIMIT = 15;
    private RecoveryConfiguration bestConfiguration;

    public AdvancedPhraseRecovery(ParseStack errorStack, Stack realStack, ITokenStream tokenStream, ISyntaxErrorRequestor problemRequestor) {
        super(errorStack, realStack, tokenStream, problemRequestor);
    }

    @Override
    protected void performTrial() {
        ParseStack poppingStack = this.errorStack.createCopy();
        int stackDeleted = 0;
        while (!poppingStack.isEmpty()) {
            this.performTrial(poppingStack, stackDeleted);
            poppingStack.pop();
            poppingStack.breakRightEdge();
            ++stackDeleted;
        }
    }

    protected void performTrial(ParseStack poppedStack, int stackDeleted) {
        int inputDeleted = 0;
        while (inputDeleted < 15) {
            ITokenStream trialStream = this.tokenStream.createTokenStreamAtOffset(inputDeleted);
            short[] nonTerminalCandidates = poppedStack.getNonTerminalCandidates(poppedStack.getCurrentState());
            int i = 0;
            while (i < nonTerminalCandidates.length) {
                short nonTerminalCandidate = nonTerminalCandidates[i];
                ParseStack trialStack = poppedStack.createCopy();
                trialStack.processNonTerminal(nonTerminalCandidate);
                int parseCheckDistance = trialStack.parseCheck(trialStream);
                RecoveryConfiguration configuration = new RecoveryConfiguration(stackDeleted, inputDeleted, nonTerminalCandidate, parseCheckDistance);
                if (configuration.isBetterThan(this.bestConfiguration)) {
                    this.bestConfiguration = configuration;
                }
                if (parseCheckDistance > 5) {
                    return;
                }
                ++i;
            }
            ParseStack trialStack = poppedStack.createCopy();
            int parseCheckDistance = trialStack.parseCheck(trialStream);
            RecoveryConfiguration configuration = new RecoveryConfiguration(stackDeleted, inputDeleted, -1, parseCheckDistance);
            if (configuration.isBetterThan(this.bestConfiguration)) {
                this.bestConfiguration = configuration;
            }
            if (parseCheckDistance > 5) {
                return;
            }
            ++inputDeleted;
        }
    }

    @Override
    public float getMisspellingIndex() {
        return 0.0f;
    }

    @Override
    public int getParseCheckDistance() {
        return this.bestConfiguration == null ? 0 : this.bestConfiguration.parseCheckDistance;
    }

    public int getNumTokensDeleted() {
        return this.bestConfiguration == null ? 0 : this.bestConfiguration.inputDeleted;
    }

    @Override
    public int performRecovery() {
        int deleteStart = this.tokenStream.getLookAhead().left;
        int deleteEnd = this.errorStack.getStackRightEdge();
        int i = 0;
        while (i < this.bestConfiguration.stackDeleted) {
            deleteStart = this.errorStack.getStackLeftEdge();
            this.errorStack.pop();
            this.realStack.pop();
            this.errorStack.breakRightEdge();
            ((Symbol)this.realStack.peek()).parse_state = this.errorStack.getCurrentState();
            ++i;
        }
        i = 0;
        while (i < this.bestConfiguration.inputDeleted) {
            deleteEnd = this.tokenStream.getLookAhead().right;
            this.tokenStream.advanceLookAhead();
            ++i;
        }
        if (this.bestConfiguration.nonTerminalSubstitution != -1) {
            int currentState = this.errorStack.getCurrentState();
            short gotoState = this.errorStack.get_reduce(currentState, this.bestConfiguration.nonTerminalSubstitution);
            if (gotoState != -1) {
                Symbol nonTerminal = new Symbol(this.bestConfiguration.nonTerminalSubstitution, gotoState);
                this.realStack.push(nonTerminal);
                this.errorStack.processNonTerminal(this.bestConfiguration.nonTerminalSubstitution);
                this.problemRequestor.incorrectPhrase(this.bestConfiguration.nonTerminalSubstitution, deleteStart, deleteEnd);
                return this.realStack.size() - 1;
            }
            this.problemRequestor.unexpectedPhrase(deleteStart, deleteEnd);
            return 0;
        }
        this.problemRequestor.unexpectedPhrase(deleteStart, deleteEnd);
        return 0;
    }

    private static class RecoveryConfiguration {
        private int stackDeleted;
        private int inputDeleted;
        private int nonTerminalSubstitution;
        private int parseCheckDistance;

        public RecoveryConfiguration(int stackDeleted, int inputDeleted, int nonTerminalSubstitution, int parseCheckDistance) {
            this.stackDeleted = stackDeleted;
            this.inputDeleted = inputDeleted;
            this.nonTerminalSubstitution = nonTerminalSubstitution;
            this.parseCheckDistance = parseCheckDistance;
        }

        public boolean isBetterThan(RecoveryConfiguration other) {
            if (this.parseCheckDistance < 5) {
                return false;
            }
            if (other == null) {
                return true;
            }
            int thisTotal = this.inputDeleted + this.stackDeleted;
            int otherTotal = other.inputDeleted + other.stackDeleted;
            return thisTotal < otherTotal;
        }
    }
}

