/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;

public class BooleanLiteral
extends LiteralExpression {
    private Boolean value;

    public BooleanLiteral(Boolean value, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.value = value;
    }

    public Boolean booleanValue() {
        return this.value;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int getLiteralKind() {
        return 7;
    }

    @Override
    public String getCanonicalString() {
        return Boolean.YES == this.value ? "yes" : "no";
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new BooleanLiteral(this.value, this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public String getValue() {
        return this.booleanValue().toString();
    }
}

