/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Parameter;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Type;

public class FunctionParameter
extends Parameter {
    private AttrType attrTypeOpt;
    private UseType useTypeOpt;
    private boolean parmConst;

    public FunctionParameter(SimpleName name, Type type, AttrType attrTypeOpt, Boolean parmConst, UseType useTypeOpt, int startOffset, int endOffset) {
        super(name, type, startOffset, endOffset);
        this.attrTypeOpt = attrTypeOpt;
        this.useTypeOpt = useTypeOpt;
        this.parmConst = parmConst;
    }

    public AttrType getAttrType() {
        return this.attrTypeOpt;
    }

    public UseType getUseType() {
        return this.useTypeOpt;
    }

    public boolean isParmConst() {
        return this.parmConst;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.name.accept(visitor);
            this.type.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new FunctionParameter((SimpleName)this.name.clone(), (Type)this.type.clone(), this.attrTypeOpt, this.parmConst, this.useTypeOpt, this.getOffset(), this.getOffset() + this.getLength());
    }

    public static class AttrType {
        private String token;
        public static final AttrType FIELD = new AttrType("field");
        public static final AttrType SQLNULLABLE = new AttrType("SQLNullable");
        private static final Map CODES = new HashMap(2);

        static {
            AttrType[] ops = new AttrType[]{FIELD, SQLNULLABLE};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private AttrType(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }
    }

    public static class UseType {
        private String token;
        public static final UseType IN = new UseType("in");
        public static final UseType OUT = new UseType("out");
        public static final UseType INOUT = new UseType("inout");
        private static final Map CODES = new HashMap(4);

        static {
            UseType[] ops = new UseType[]{IN, OUT, INOUT};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private UseType(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }
    }
}

