/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Stack;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.ast.AbstractRecovery;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ITokenStream;
import org.eclipse.edt.compiler.core.ast.ParseStack;
import org.eclipse.edt.compiler.core.ast.Terminal;

public class PreviousNonTerminalInsertionRecovery
extends AbstractRecovery {
    private int parseCheckDistance;
    private int missingNonTerminal;

    public PreviousNonTerminalInsertionRecovery(ParseStack errorStack, Stack realStack, ITokenStream tokenStream, ISyntaxErrorRequestor problemRequestor) {
        super(errorStack, realStack, tokenStream, problemRequestor);
    }

    @Override
    protected void performTrial() {
        ParseStack previousStack = this.errorStack.createCopy();
        Terminal previousTerminal = previousStack.undoLastTerminal();
        if (previousTerminal == null) {
            return;
        }
        short[] nonterminalCandidates = previousStack.getNonTerminalCandidates(previousStack.getCurrentState());
        int i = 0;
        while (i < nonterminalCandidates.length) {
            ParseStack trialStack = previousStack.createCopy();
            trialStack.processNonTerminal(nonterminalCandidates[i]);
            if (trialStack.canShift(previousTerminal)) {
                trialStack.processLookAhead(previousTerminal);
                int trialDistance = trialStack.parseCheck(this.tokenStream);
                if (trialDistance > this.parseCheckDistance) {
                    this.parseCheckDistance = trialDistance;
                    this.missingNonTerminal = nonterminalCandidates[i];
                }
            }
            ++i;
        }
    }

    @Override
    public float getMisspellingIndex() {
        return 0.0f;
    }

    @Override
    public int getParseCheckDistance() {
        return this.parseCheckDistance;
    }

    @Override
    public int performRecovery() {
        Terminal previousTerminal = this.errorStack.undoLastTerminal();
        Symbol previousSymbol = (Symbol)this.realStack.peek();
        int errorStackTop = this.errorStack.getStackTop();
        int i = this.realStack.size();
        while (i > errorStackTop + 1) {
            this.realStack.pop();
            --i;
        }
        ((Symbol)this.realStack.peek()).parse_state = this.errorStack.getCurrentState();
        ParseStack messageStack = this.errorStack.createCopy();
        messageStack.processNonTerminal(this.missingNonTerminal);
        int highestNonTerminalType = messageStack.getHighestNonTerminal(previousTerminal.symbolType);
        this.problemRequestor.incorrectPreviousNonTerminal(previousTerminal.left, previousTerminal.right, highestNonTerminalType);
        int currentState = this.errorStack.getCurrentState();
        short gotoState = this.errorStack.get_reduce(currentState, highestNonTerminalType);
        this.realStack.push(new Symbol(highestNonTerminalType, gotoState));
        this.errorStack.processNonTerminal(highestNonTerminalType);
        this.tokenStream.rollBack(previousTerminal, previousSymbol);
        return this.realStack.size() - 1;
    }
}

