/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.List;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;

public class SettingsBlock
extends Node {
    private List settings;

    public SettingsBlock(List settings, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.settings = this.setParent(settings);
    }

    public List getSettings() {
        return this.settings;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            SettingsBlock.acceptChildren(visitor, this.settings);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new SettingsBlock(this.cloneList(this.settings), this.getOffset(), this.getOffset() + this.getLength());
    }

    public Assignment getSetting(final String propertyName) {
        final Assignment[] result = new Assignment[1];
        SettingsBlock.acceptChildren(new DefaultASTVisitor(){

            @Override
            public boolean visit(Assignment assignment) {
                IDataBinding binding = assignment.getLeftHandSide().resolveDataBinding();
                if (binding != null && binding != IBinding.NOT_FOUND_BINDING && binding.isAnnotationBinding() && propertyName == binding.getName()) {
                    result[0] = assignment;
                }
                return false;
            }
        }, this.settings);
        return result[0];
    }

    public Assignment getSetting(final IAnnotationTypeBinding annotationTypeBinding) {
        final Assignment[] result = new Assignment[1];
        SettingsBlock.acceptChildren(new DefaultASTVisitor(){

            @Override
            public boolean visit(Assignment assignment) {
                IDataBinding binding = assignment.getLeftHandSide().resolveDataBinding();
                if (binding != null && binding != IBinding.NOT_FOUND_BINDING && binding.isAnnotationBinding() && annotationTypeBinding.getName() == binding.getName()) {
                    result[0] = assignment;
                }
                return false;
            }
        }, this.settings);
        return result[0];
    }

    public Node getSetting(final String[] annotationPackage, final String anotationName) {
        final Node[] result = new Node[1];
        SettingsBlock.acceptChildren(new DefaultASTVisitor(){

            @Override
            public boolean visit(Assignment assignment) {
                IDataBinding binding = assignment.getLeftHandSide().resolveDataBinding();
                if (binding != null && binding != IBinding.NOT_FOUND_BINDING && binding.isAnnotationBinding() && AbstractBinder.annotationIs(((IAnnotationBinding)binding).getAnnotationType(), annotationPackage, anotationName)) {
                    result[0] = assignment;
                }
                return false;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                setValuesExpression.getExpression().accept(this);
                return false;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                IDataBinding binding = annotationExpression.resolveDataBinding();
                if (binding != null && binding != IBinding.NOT_FOUND_BINDING && binding.isAnnotationBinding() && AbstractBinder.annotationIs(((IAnnotationBinding)binding).getAnnotationType(), annotationPackage, anotationName)) {
                    result[0] = annotationExpression;
                }
                return false;
            }
        }, this.settings);
        return result[0];
    }
}

