/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.internal.core.dependency.NullDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FileASTScope
extends FileScope {
    private List importedTypeNames = new ArrayList();

    public FileASTScope(Scope parentScope, FileBinding fileBinding, File fileAST) {
        super(parentScope, fileBinding, NullDependencyRequestor.getInstance());
        List importDeclarations = fileAST.getImportDeclarations();
        for (ImportDeclaration importDeclaration : importDeclarations) {
            if (importDeclaration.isOnDemand()) continue;
            this.importedTypeNames.add(importDeclaration);
        }
    }

    @Override
    public ITypeBinding findType(String simpleName) {
        ITypeBinding result = null;
        if (this.importedTypeNames != null) {
            for (ImportDeclaration importDeclaration : this.importedTypeNames) {
                if (importDeclaration.getName().getIdentifier() != simpleName) continue;
                IPartBinding temp = null;
                temp = importDeclaration.getName().isQualifiedName() ? this.fileBinding.getEnvironment().getPartBinding(((QualifiedName)importDeclaration.getName()).getQualifier().getNameComponents(), importDeclaration.getName().getIdentifier()) : this.fileBinding.getEnvironment().getPartBinding(InternUtil.intern((String[])new String[0]), importDeclaration.getName().getIdentifier());
                if (temp == null || temp == IBinding.NOT_FOUND_BINDING || (this.fileBinding.getDeclaringPackage() == null || this.fileBinding.getDeclaringPackage().getPackageName() != temp.getPackageName()) && temp.isPrivate()) continue;
                return temp;
            }
        }
        if ((result = this.findTypeInDeclaringPackage(simpleName)) != null) {
            return result;
        }
        result = this.findTypeInOnDemandImports(simpleName);
        return result == null ? IBinding.NOT_FOUND_BINDING : result;
    }
}

