/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import org.eclipse.edt.compiler.binding.FixedStructureBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class FixedStructureScope
extends Scope {
    private FixedStructureBinding recordBinding;

    public FixedStructureScope(Scope parentScope, FixedStructureBinding recordBinding) {
        super(parentScope);
        this.recordBinding = recordBinding;
    }

    @Override
    public IDataBinding findData(String simpleName) {
        IDataBinding result = this.recordBinding.findData(simpleName);
        if (result != IBinding.NOT_FOUND_BINDING) {
            return result;
        }
        result = (IDataBinding)this.recordBinding.getSimpleNamesToDataBindingsMap().get(simpleName);
        if (result != null) {
            return result;
        }
        return this.parentScope.findData(simpleName);
    }

    @Override
    public IFunctionBinding findFunction(String simpleName) {
        return this.parentScope.findFunction(simpleName);
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.parentScope.findPackage(simpleName);
    }

    @Override
    public ITypeBinding findType(String simpleName) {
        return this.parentScope.findType(simpleName);
    }

    @Override
    public IPartBinding getPartBinding() {
        return this.recordBinding;
    }
}

